/*
 * Decompiled with CFR 0.152.
 */
package example.pushpuzzle;

import java.io.IOException;
import java.io.InputStream;

public class Board {
    public static final int LEFT = 0;
    public static final int RIGHT = 3;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int MOVEPACKET = 4;
    public static final byte GROUND = 0;
    public static final byte STORE = 1;
    public static final byte PACKET = 2;
    public static final byte WALL = 4;
    public static final byte PUSHER = 8;
    private int level;
    private byte[] array;
    private byte[] pathmap;
    private int width;
    private int height;
    private int pusher;
    private int packets = 0;
    private int stored = 0;
    private byte[] moves = new byte[200];
    private int nmoves;
    private int npushes;

    public Board() {
        this.screen0();
    }

    public void screen0() {
        this.width = 9;
        this.height = 7;
        this.array = new byte[this.width * this.height];
        this.level = 0;
        this.nmoves = 0;
        this.npushes = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                byte by = i == 0 || j == 0 || i == this.width - 1 || j == this.height - 1 ? (byte)4 : 0;
                this.set(i, j, by);
            }
        }
        this.packets = 2;
        this.stored = 0;
        this.set(2, 2, (byte)2);
        this.set(4, 4, (byte)2);
        this.set(4, 2, (byte)1);
        this.set(6, 4, (byte)1);
        this.pusher = this.index(1, 1);
    }

    public int move(int n) {
        int n2 = this.pusher + this.indexOffset(n);
        if ((this.array[n2] & 4) != 0) {
            return -1;
        }
        int n3 = this.movePacket(n2, n);
        if (n3 < 0) {
            return -1;
        }
        this.pusher = n2;
        this.saveMove(n3);
        return n3;
    }

    private int movePacket(int n, int n2) {
        if ((this.array[n] & 2) == 0) {
            return n2;
        }
        int n3 = n + this.indexOffset(n2);
        if (this.array[n3] > 1) {
            return -1;
        }
        int n4 = n;
        this.array[n4] = (byte)(this.array[n4] & 0xFFFFFFFD);
        if ((this.array[n] & 1) != 0) {
            --this.stored;
        }
        int n5 = n3;
        this.array[n5] = (byte)(this.array[n5] | 2);
        if ((this.array[n3] & 1) != 0) {
            ++this.stored;
        }
        ++this.npushes;
        return n2 + 4;
    }

    private void saveMove(int n) {
        if (this.nmoves >= this.moves.length) {
            byte[] byArray = new byte[this.moves.length + 50];
            System.arraycopy(this.moves, 0, byArray, 0, this.moves.length);
            this.moves = byArray;
        }
        this.moves[this.nmoves++] = (byte)n;
    }

    public int undoMove() {
        if (this.nmoves <= 0) {
            return -1;
        }
        byte by = this.moves[--this.nmoves];
        int n = by & 3 ^ 3;
        int n2 = this.pusher + this.indexOffset(n);
        if ((by & 4) != 0) {
            --this.npushes;
            this.movePacket(this.pusher + this.indexOffset(by), n);
        }
        this.pusher = n2;
        return by;
    }

    public boolean solved() {
        return this.packets == this.stored;
    }

    public int runTo(int n, int n2, int n3) {
        int n4;
        int n5 = this.index(n, n2);
        if (n5 < 0 || n5 >= this.array.length) {
            return -1;
        }
        if (n5 == this.pusher) {
            return -1;
        }
        if (this.pathmap == null || this.pathmap.length != this.array.length) {
            this.pathmap = new byte[this.array.length];
        }
        for (n4 = 0; n4 < this.pathmap.length; ++n4) {
            this.pathmap[n4] = 127;
        }
        this.findTarget(n5, (byte)0);
        if (this.pathmap[this.pusher] == 127) {
            return -1;
        }
        n4 = this.pathmap[this.pusher];
        int n6 = n4 - n3;
        int n7 = -1;
        --n4;
        while (n4 >= n6) {
            if (this.pathmap[this.pusher - 1] == n4) {
                n7 = 0;
                this.saveMove(n7);
                --this.pusher;
            } else if (this.pathmap[this.pusher + 1] == n4) {
                n7 = 3;
                this.saveMove(n7);
                ++this.pusher;
            } else if (this.pathmap[this.pusher - this.width] == n4) {
                n7 = 1;
                this.saveMove(n7);
                this.pusher -= this.width;
            } else if (this.pathmap[this.pusher + this.width] == n4) {
                n7 = 2;
                this.saveMove(n7);
                this.pusher += this.width;
            } else {
                throw new RuntimeException("runTo abort");
            }
            --n4;
        }
        return n7;
    }

    private void findTarget(int n, byte by) {
        if (this.array[n] > 1) {
            return;
        }
        if (this.pathmap[n] <= by) {
            return;
        }
        byte by2 = by;
        by = (byte)(by + 1);
        this.pathmap[n] = by2;
        if (n == this.pusher) {
            return;
        }
        if (n - 1 >= 0) {
            this.findTarget(n - 1, by);
        }
        if (n + 1 < this.array.length) {
            this.findTarget(n + 1, by);
        }
        if (n - this.width >= 0) {
            this.findTarget(n - this.width, by);
        }
        if (n + this.width < this.array.length) {
            this.findTarget(n + this.width, by);
        }
    }

    public byte get(int n, int n2) {
        int n3 = this.index(n, n2);
        if (n3 == this.pusher) {
            return (byte)(this.array[n3] | 8);
        }
        return this.array[n3];
    }

    private void set(int n, int n2, byte by) {
        this.array[this.index((int)n, (int)n2)] = by;
    }

    private int index(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return -1;
        }
        return n2 * this.width + n;
    }

    public int getPusherLocation() {
        int n = this.pusher % this.width;
        int n2 = this.pusher / this.width;
        return (n2 << 16) + n;
    }

    private int indexOffset(int n) {
        switch (n & 3) {
            case 0: {
                return -1;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return -this.width;
            }
            case 2: {
                return this.width;
            }
        }
        return 0;
    }

    public void read(InputStream inputStream, int n) {
        byte[] byArray = new byte[400];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            int n8;
            while ((n8 = inputStream.read()) != -1) {
                switch (n8) {
                    case 10: {
                        if (n3 > n2) {
                            n2 = n3;
                        }
                        ++n4;
                        n3 = 0;
                        break;
                    }
                    case 36: {
                        byArray[n4 * 20 + n3++] = 2;
                        ++n7;
                        break;
                    }
                    case 35: {
                        byArray[n4 * 20 + n3++] = 4;
                        break;
                    }
                    case 32: {
                        byArray[n4 * 20 + n3++] = 0;
                        break;
                    }
                    case 46: {
                        byArray[n4 * 20 + n3++] = 1;
                        break;
                    }
                    case 42: {
                        byArray[n4 * 20 + n3] = 2;
                        int n9 = n4 * 20 + n3++;
                        byArray[n9] = (byte)(byArray[n9] | 1);
                        ++n7;
                        ++this.stored;
                        break;
                    }
                    case 43: {
                        byArray[n4 * 20 + n3++] = 1;
                    }
                    case 64: {
                        n5 = n3++;
                        n6 = n4;
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n4 > 0) {
            this.array = new byte[n2 * n4];
            if (n4 > n2) {
                this.width = n4;
                this.height = n2;
                for (n4 = 0; n4 < this.width; ++n4) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        this.array[this.index((int)n4, (int)n3)] = byArray[n4 * 20 + n3];
                    }
                }
                this.pusher = this.index(n6, n5);
            } else {
                this.width = n2;
                this.height = n4;
                this.array = new byte[this.width * this.height];
                for (n4 = 0; n4 < this.height; ++n4) {
                    for (n3 = 0; n3 < this.width; ++n3) {
                        this.array[this.index((int)n3, (int)n4)] = byArray[n4 * 20 + n3];
                    }
                }
                this.pusher = this.index(n5, n6);
            }
            this.stored = 0;
            this.packets = n7;
            this.level = n;
            this.nmoves = 0;
            this.npushes = 0;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMoves() {
        return this.nmoves;
    }

    public int getPushes() {
        return this.npushes;
    }

    public int getStored() {
        return this.stored;
    }

    private int dx(int n) {
        if (n == 0) {
            return -1;
        }
        if (n == 3) {
            return 1;
        }
        return 0;
    }

    private int dy(int n) {
        if (n == 1) {
            return -1;
        }
        if (n == 2) {
            return 1;
        }
        return 0;
    }
}

