/*
 * Decompiled with CFR 0.152.
 */
package example.pushpuzzle;

import example.pushpuzzle.Board;
import example.pushpuzzle.PushPuzzle;
import example.pushpuzzle.Score;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

class PushPuzzleCanvas
extends GameCanvas
implements Runnable {
    private static final int PanRate = 50;
    private static final int GroundColor0 = 0xFFFFFF;
    private static final int PacketColor0 = 16739584;
    private static final int StoreColor0 = 11927637;
    private static final int WallColor0 = 27989;
    private static final int PusherColor0 = 0x6D6DFF;
    private int level = 1;
    private int theme;
    private boolean solved;
    private int cell = 1;
    private int width;
    private int height;
    private int bwidth;
    private int bheight;
    private final Board board;
    private Score score;
    private CommandListener listener;
    private TextBox levelText;
    public final int TILE_GROUND;
    public final int TILE_PACKET;
    public final int TILE_STORE;
    public final int TILE_WALL;
    public final int TILE_PUSHER;
    private Image themeImage;
    private TiledLayer tiles;
    private Sprite sprite;
    private LayerManager layers;
    private Thread thread;
    private int targetx;
    private int targety;
    private Player tonePlayer;
    private ToneControl toneControl;
    private byte[] solvedTune = new byte[]{-2, 1, 74, 8, 75, 8, 73, 8};
    private byte[] storedTune = new byte[]{-2, 1, 50, 8, 60, 8, 70, 8};

    public PushPuzzleCanvas(PushPuzzle pushPuzzle, Score score) {
        super(false);
        this.TILE_GROUND = 1;
        this.TILE_PACKET = 2;
        this.TILE_STORE = 3;
        this.TILE_WALL = 4;
        this.TILE_PUSHER = 5;
        this.score = score;
        this.board = new Board();
        this.layers = new LayerManager();
        this.setupTheme();
        this.targety = -1;
        this.targetx = -1;
        this.height = this.getHeight();
        this.width = this.getWidth();
    }

    public void init() {
        this.theme = this.score.getTheme();
        this.setupTheme();
        this.level = this.score.getLevel();
        if (!this.readScreen(this.level)) {
            this.level = 0;
            this.readScreen(this.level);
        }
    }

    public void destroy() {
        this.hideNotify();
    }

    public void changeTheme() {
        ++this.theme;
        this.setupTheme();
        this.score.setLevel(this.level, this.theme);
        this.setupTiles();
        this.updateSprite(0);
    }

    public void undoMove() {
        int n = this.board.getPusherLocation();
        int n2 = this.board.undoMove();
        if (n2 >= 0) {
            this.updateTilesNear(n, n2);
            this.updateSprite(n2);
        }
        this.solved = this.board.solved();
    }

    public void restartLevel() {
        this.readScreen(this.level);
        this.solved = false;
    }

    public boolean nextLevel(int n) {
        this.updateScores();
        if (this.level + n >= 0 && this.readScreen(this.level + n)) {
            this.level += n;
            this.score.setLevel(this.level, this.theme);
            this.solved = false;
            return true;
        }
        return false;
    }

    public int getLevel() {
        return this.level;
    }

    public Screen getLevelScreen() {
        if (this.levelText == null) {
            this.levelText = new TextBox("Enter Level", Integer.toString(this.level), 4, 2);
        } else {
            this.levelText.setString(Integer.toString(this.level));
        }
        return this.levelText;
    }

    public boolean gotoLevel() {
        if (this.levelText != null) {
            int n;
            String string = this.levelText.getString();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            this.updateScores();
            if (n >= 0 && this.readScreen(n)) {
                this.level = n;
                this.score.setLevel(this.level, this.theme);
                this.solved = false;
                return true;
            }
        }
        return false;
    }

    private boolean readScreen(int n) {
        if (n <= 0) {
            this.board.screen0();
        } else {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/example/pushpuzzle/data/screen." + n);
                if (inputStream == null) {
                    System.out.println("Could not find the game board for level " + n);
                    return false;
                }
                this.board.read(inputStream, n);
                inputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        this.bwidth = this.board.getWidth();
        this.bheight = this.board.getHeight();
        this.setupTiles();
        this.updateSprite(0);
        return true;
    }

    private void setupTiles() {
        if (this.tiles != null) {
            this.layers.remove((Layer)this.tiles);
        }
        int n = (this.width + this.cell - 1) / this.cell;
        int n2 = (this.height + this.cell - 1) / this.cell;
        this.tiles = new TiledLayer(n > this.bwidth ? n : this.bwidth, n2 > this.bheight ? n2 : this.bheight, this.themeImage, this.cell, this.cell);
        this.tiles.fillCells(0, 0, n, n2, 1);
        for (int i = 0; i < this.bheight; ++i) {
            for (int j = 0; j < this.bwidth; ++j) {
                this.updateTile(j, i);
            }
        }
        this.layers.append((Layer)this.tiles);
    }

    private void updateTile(int n, int n2) {
        int n3;
        byte by = this.board.get(n, n2);
        switch (by & 0xFFFFFFF7) {
            case 4: {
                n3 = 4;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        this.tiles.setCell(n, n2, n3);
    }

    private void setupTheme0() {
        int n = this.board.getWidth();
        int n2 = this.board.getHeight();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.cell = (n4 - 14) / n2 < n3 / n ? (n4 - 14) / n2 : n3 / n;
        this.themeImage = Image.createImage((int)(this.cell * 5), (int)this.cell);
        Graphics graphics = this.themeImage.getGraphics();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0 * this.cell, 0, this.cell * 5, this.cell);
        graphics.setColor(16739584);
        graphics.fillRect(1 * this.cell + 1, 1, this.cell - 2, this.cell - 2);
        graphics.setColor(11927637);
        graphics.drawRect(2 * this.cell + 1, 1, this.cell - 2, this.cell - 2);
        graphics.setColor(27989);
        graphics.fillRect(3 * this.cell, 0, this.cell, this.cell);
        graphics.setColor(0x6D6DFF);
        graphics.fillArc(4 * this.cell, 0, this.cell, this.cell, 0, 360);
    }

    private void setupTheme() {
        Object object;
        if (this.sprite != null) {
            this.layers.remove((Layer)this.sprite);
            this.sprite = null;
        }
        if (this.theme > 0) {
            try {
                object = new StringBuffer("/example/pushpuzzle/images/Theme-");
                ((StringBuffer)object).append(this.theme);
                ((StringBuffer)object).append(".png");
                this.themeImage = Image.createImage((String)((StringBuffer)object).toString());
                int n = this.themeImage.getHeight();
                int n2 = this.themeImage.getWidth();
                this.cell = n2 < n ? n2 : n;
            }
            catch (IOException iOException) {
                this.theme = 0;
                this.setupTheme0();
            }
        } else {
            this.setupTheme0();
        }
        this.sprite = new Sprite(this.themeImage, this.cell, this.cell);
        this.sprite.defineReferencePixel(this.cell / 2, this.cell / 2);
        object = new int[]{4};
        this.sprite.setFrameSequence((int[])object);
        this.layers.insert((Layer)this.sprite, 0);
    }

    public Screen getScoreScreen() {
        int n = this.board.getPushes();
        int n2 = this.score.getPushes();
        int n3 = this.board.getMoves();
        int n4 = this.score.getMoves();
        boolean bl = this.solved && (n2 == 0 || n < n2);
        Form form = new Form(null);
        form.append((Item)new StringItem(bl ? "New Best:\n" : "Current:\n", n + " pushes\n" + n3 + " moves"));
        form.append((Item)new StringItem(bl ? "Old Best:\n" : "Best:\n", n2 + " pushes\n" + n4 + " moves"));
        String string = "Scores";
        if (bl) {
            string = "Congratulations";
        }
        form.setTitle(string);
        return form;
    }

    protected void keyRepeated(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(n);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        Board board = this.board;
        synchronized (board) {
            int n2;
            this.cancelTo();
            int n3 = this.getGameAction(n);
            switch (n3) {
                case 2: {
                    n2 = 0;
                    break;
                }
                case 5: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            int n4 = this.board.getStored();
            int n5 = this.board.move(n2);
            if (n4 < this.board.getStored()) {
                this.play(this.storedTune);
            }
            int n6 = this.board.getPusherLocation();
            this.updateTilesNear(n6, n5);
            this.updateSprite(n5);
        }
    }

    private void updateScores() {
        if (!this.solved) {
            return;
        }
        int n = this.score.getPushes();
        int n2 = this.board.getPushes();
        int n3 = this.board.getMoves();
        if (n == 0 || n2 < n) {
            this.score.setLevelScore(n2, n3);
        }
    }

    private void cancelTo() {
        this.targetx = -1;
        this.targety = -1;
    }

    protected void pointerPressed(int n, int n2) {
        this.targetx = (n - this.tiles.getX()) / this.cell;
        this.targety = (n2 - this.tiles.getY()) / this.cell;
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.listener = commandListener;
    }

    private void updateSprite(int n) {
        int n2 = this.board.getPusherLocation();
        int n3 = (n2 & Short.MAX_VALUE) * this.cell;
        int n4 = (n2 >> 16 & Short.MAX_VALUE) * this.cell;
        this.sprite.setPosition(this.tiles.getX() + n3, this.tiles.getY() + n4);
        n = 3;
        switch (n & 3) {
            case 0: {
                this.sprite.setTransform(3);
                break;
            }
            case 1: {
                this.sprite.setTransform(5);
                break;
            }
            case 2: {
                this.sprite.setTransform(6);
                break;
            }
            default: {
                this.sprite.setTransform(0);
            }
        }
    }

    void updateTilesNear(int n, int n2) {
        int n3 = n & Short.MAX_VALUE;
        int n4 = n >> 16 & Short.MAX_VALUE;
        if (n2 >= 0 && (n2 & 4) != 0) {
            this.updateTile(n3, n4);
            this.updateTile(n3 + 1, n4);
            this.updateTile(n3 - 1, n4);
            this.updateTile(n3, n4 + 1);
            this.updateTile(n3, n4 - 1);
        }
    }

    public void paint(Graphics graphics) {
        this.flushGraphics();
    }

    protected void showNotify() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void hideNotify() {
        this.thread = null;
    }

    public void run() {
        Graphics graphics = this.getGraphics();
        Thread thread = Thread.currentThread();
        while (thread == this.thread) {
            try {
                int n;
                int n2;
                boolean bl = false;
                if (!this.solved && this.board.solved()) {
                    this.solved = true;
                    bl = true;
                    this.play(this.solvedTune);
                }
                if (bl && this.listener != null) {
                    this.listener.commandAction(List.SELECT_COMMAND, (Displayable)this);
                }
                if (this.targetx >= 0 && this.targety >= 0) {
                    n2 = this.board.runTo(this.targetx, this.targety, 1);
                    n = this.board.getPusherLocation();
                    if (n2 < 0) {
                        this.targety = -1;
                        this.targetx = -1;
                    } else {
                        this.updateTilesNear(n, n2);
                        this.updateSprite(n2);
                    }
                }
                n2 = this.board.getPusherLocation();
                n = (n2 & Short.MAX_VALUE) * this.cell;
                int n3 = (n2 >> 16 & Short.MAX_VALUE) * this.cell;
                int n4 = this.tiles.getX();
                int n5 = this.tiles.getY();
                int n6 = this.cell / 4;
                if (n6 < 1) {
                    n6 = 1;
                }
                if (n4 + n > this.width - this.cell - this.cell) {
                    this.tiles.move(-n6, 0);
                    this.sprite.move(-n6, 0);
                }
                if (n4 + n < this.cell) {
                    this.tiles.move(n6, 0);
                    this.sprite.move(n6, 0);
                }
                if (n5 + n3 > this.height - this.cell - this.cell) {
                    this.tiles.move(0, -n6);
                    this.sprite.move(0, -n6);
                }
                if (n5 + n3 < this.cell) {
                    this.tiles.move(0, n6);
                    this.sprite.move(0, n6);
                }
                this.layers.paint(graphics, 0, 0);
                if (thread == this.thread) {
                    this.flushGraphics();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void play(byte[] byArray) {
        try {
            if (this.tonePlayer == null) {
                this.tonePlayer = Manager.createPlayer((String)"device://tone");
                this.tonePlayer.realize();
                this.toneControl = (ToneControl)this.tonePlayer.getControl("javax.microedition.media.control.ToneControl");
            }
            this.tonePlayer.deallocate();
            this.toneControl.setSequence(byArray);
            this.tonePlayer.start();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    void closePlayer() {
        if (this.tonePlayer != null) {
            this.toneControl = null;
            this.tonePlayer.close();
            this.tonePlayer = null;
        }
    }
}

