/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import example.wormgame.WormPit;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class WormMain
extends MIDlet
implements CommandListener {
    private WormPit theGame;
    private Command exitCmd = new Command("Exit", 7, 3);
    private Command levelCmd = new Command("Change Level", 1, 2);
    private Command startCmd = new Command("Start", 1, 1);
    private Command restartCmd = new Command("Restart", 1, 1);
    private Command audioOnCmd = new Command("Audio On", 1, 1);
    private Command audioOffCmd = new Command("Audio Off", 1, 1);
    private Command cancelCmd = new Command("Cancel", 8, 1);
    private Command OKCmd = new Command("OK", 4, 1);
    private Thread myThread;

    public WormMain() {
        this.theGame = new WormPit();
        this.theGame.addCommand(this.exitCmd);
        this.theGame.addCommand(this.levelCmd);
        this.theGame.addCommand(this.startCmd);
        this.theGame.addCommand(this.audioOnCmd);
        this.theGame.setCommandListener(this);
    }

    protected void destroyApp(boolean bl) {
        this.theGame.destroyAudioPlayer();
        this.theGame.destroyGame();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)null);
    }

    protected void pauseApp() {
        this.theGame.mute();
        this.theGame.destroyGame();
        try {
            this.myThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void startApp() {
        this.theGame.unMute();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.theGame);
        try {
            this.myThread = new Thread(this.theGame);
            this.theGame.setDestroyed(false);
            this.myThread.start();
        }
        catch (Error error) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.restartCmd) {
            this.theGame.restart();
        } else if (command == this.levelCmd) {
            Item[] itemArray = new Item[]{new Gauge("Level", true, 9, this.theGame.getLevel())};
            Form form = new Form("Change Level", itemArray);
            form.addCommand(this.OKCmd);
            form.addCommand(this.cancelCmd);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
        } else if (command == this.exitCmd) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.startCmd) {
            this.theGame.removeCommand(this.startCmd);
            this.theGame.addCommand(this.restartCmd);
            this.theGame.restart();
        } else if (command == this.OKCmd) {
            Form form = (Form)displayable;
            Gauge gauge = (Gauge)form.get(0);
            this.theGame.setLevel(gauge.getValue());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.theGame);
        } else if (command == this.cancelCmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.theGame);
        } else if (command == this.audioOnCmd) {
            this.theGame.createAudioPlayer();
            this.theGame.removeCommand(this.audioOnCmd);
            this.theGame.addCommand(this.audioOffCmd);
        } else if (command == this.audioOffCmd) {
            this.theGame.destroyAudioPlayer();
            this.theGame.removeCommand(this.audioOffCmd);
            this.theGame.addCommand(this.audioOnCmd);
        }
    }
}

