/*
 * Decompiled with CFR 0.152.
 */
package example.pushpuzzle;

import example.pushpuzzle.PushPuzzleCanvas;
import example.pushpuzzle.Score;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;

public class PushPuzzle
extends MIDlet
implements CommandListener {
    Display display;
    private PushPuzzleCanvas canvas;
    private Score score;
    private Screen scoreScreen;
    private Screen levelScreen;
    private Alert alert;
    private Command undoCommand = new Command("Undo", 2, 1);
    private Command restartCommand = new Command("Start Over", 3, 21);
    private Command exitCommand = new Command("Exit", 7, 60);
    private Command scoresCommand = new Command("Show Scores", 1, 26);
    private Command okCommand = new Command("OK", 4, 30);
    private Command levelCommand = new Command("Change Level", 1, 24);
    private Command nextCommand = new Command("Next Level", 1, 22);
    private Command prevCommand = new Command("Previous Level", 1, 23);
    private Command themeCommand = new Command("Switch Theme", 1, 25);

    public PushPuzzle() {
        this.display = Display.getDisplay((MIDlet)this);
        this.score = new Score();
        this.canvas = new PushPuzzleCanvas(this, this.score);
        this.alert = new Alert("Warning");
        if (!this.score.open()) {
            System.out.println("Score open failed");
        }
        this.canvas.init();
        this.canvas.addCommand(this.undoCommand);
        this.canvas.addCommand(this.scoresCommand);
        this.canvas.addCommand(this.restartCommand);
        this.canvas.addCommand(this.levelCommand);
        this.canvas.addCommand(this.exitCommand);
        this.canvas.addCommand(this.nextCommand);
        this.canvas.addCommand(this.prevCommand);
        this.canvas.addCommand(this.themeCommand);
        this.canvas.setCommandListener(this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.display.setCurrent(null);
        this.canvas.destroy();
        if (this.score != null) {
            this.score.close();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.undoCommand) {
            this.canvas.undoMove();
        } else if (command == this.restartCommand) {
            this.canvas.restartLevel();
        } else if (command == this.levelCommand) {
            this.levelScreen = this.canvas.getLevelScreen();
            this.levelScreen.addCommand(this.okCommand);
            this.levelScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.levelScreen);
        } else if (command == this.okCommand && displayable == this.levelScreen) {
            if (!this.canvas.gotoLevel()) {
                this.alert.setString("Could not load level");
                this.display.setCurrent(this.alert, (Displayable)this.canvas);
            } else {
                this.display.setCurrent((Displayable)this.canvas);
            }
        } else if (command == this.scoresCommand) {
            this.scoreScreen = this.canvas.getScoreScreen();
            this.scoreScreen.addCommand(this.okCommand);
            this.scoreScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.scoreScreen);
        } else if (command == this.okCommand && displayable == this.scoreScreen) {
            this.display.setCurrent((Displayable)this.canvas);
        } else if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == List.SELECT_COMMAND && displayable == this.canvas) {
            this.scoreScreen = this.canvas.getScoreScreen();
            this.scoreScreen.addCommand(this.okCommand);
            this.scoreScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.scoreScreen);
            this.canvas.nextLevel(1);
        } else if (command == this.nextCommand) {
            if (!this.canvas.nextLevel(1)) {
                this.alert.setString("Could not load level " + (this.canvas.getLevel() + 1));
                this.display.setCurrent(this.alert, (Displayable)this.canvas);
            } else {
                this.display.setCurrent((Displayable)this.canvas);
            }
            if (displayable == this.canvas) {
                this.canvas.repaint();
            }
        } else if (command == this.prevCommand) {
            if (!this.canvas.nextLevel(-1)) {
                this.alert.setString("Could not load level " + (this.canvas.getLevel() - 1));
                this.display.setCurrent(this.alert, (Displayable)this.canvas);
            } else {
                this.display.setCurrent((Displayable)this.canvas);
            }
            if (displayable == this.canvas) {
                this.canvas.repaint();
            }
        } else if (command == this.themeCommand) {
            this.canvas.changeTheme();
        }
    }
}

