/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class WormScore {
    private static short[] highScore = new short[10];
    private static String[] highScoreName = new String[10];
    private static RecordStore myStore;
    private static boolean highScoresHaveBeenInit;

    private WormScore() {
    }

    private static void initializeScores() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray;
            try {
                dataOutputStream.writeShort(0);
                dataOutputStream.writeUTF("");
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < 10; ++i) {
                myStore.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            WormScore.closeHighScores();
        }
    }

    static void openHighScores() {
        try {
            myStore = RecordStore.openRecordStore((String)"HighScores", (boolean)true);
            if (highScoresHaveBeenInit) {
                return;
            }
            if (myStore.getNumRecords() == 0) {
                WormScore.initializeScores();
            } else {
                for (int i = 0; i < 10; ++i) {
                    byte[] byArray = myStore.getRecord(i + 1);
                    if (byArray == null) continue;
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        WormScore.highScore[i] = dataInputStream.readShort();
                        WormScore.highScoreName[i] = dataInputStream.readUTF();
                        dataInputStream.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            highScoresHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void closeHighScores() {
        if (myStore != null) {
            try {
                myStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            myStore = null;
        }
    }

    static void setHighScore(int n, int n2, String string) {
        if (n2 <= highScore[n]) {
            return;
        }
        try {
            byte[] byArray;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeShort((short)n2);
                dataOutputStream.writeUTF(string);
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RecordStoreException();
            }
            if (myStore == null) {
                WormScore.openHighScores();
                myStore.setRecord(n + 1, byArray, 0, byArray.length);
                WormScore.closeHighScores();
            } else {
                myStore.setRecord(n + 1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        WormScore.highScore[n] = (short)n2;
        WormScore.highScoreName[n] = string;
    }

    static short getHighScore(int n) {
        if (!highScoresHaveBeenInit) {
            WormScore.openHighScores();
            WormScore.closeHighScores();
        }
        return highScore[n];
    }

    static String getHighScoreName(int n) {
        if (!highScoresHaveBeenInit) {
            WormScore.openHighScores();
            WormScore.closeHighScores();
        }
        return highScoreName[n];
    }
}

