/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Auto;
import game.Char;
import game.Code;
import game.GameCanvas;
import game.GameScr;
import game.Item;
import game.MyVector;
import game.RMS;
import game.Service;
import game.TileMap;

public final class AutoTrade
extends Auto {
    private static AutoTrade instance;
    public long lastInviteTime;
    private long searchStartTime;
    private int searchAttempt;
    public int tradeStep;
    public int itemLimitPerTrade;
    public static MyVector allowedTradeChars;
    public Char targetChar;
    private String[] itemIDList;
    private String targetCharName;
    private int currentItemsAdded = 0;
    public long waitAcceptStart = 0L;
    public long waitLockStart = 0L;
    public int addedItemCount = 0;
    public int lastTradeAccepted = -1;

    public static AutoTrade gI() {
        if (instance == null) {
            instance = new AutoTrade();
        }
        return instance;
    }

    private void resetTrade() {
        this.targetChar = null;
        this.tradeStep = 0;
        this.searchStartTime = 0L;
        this.searchAttempt = 0;
        this.itemLimitPerTrade = -1;
        this.currentItemsAdded = 0;
        this.lastInviteTime = 0L;
    }

    public static void saveTradeCharList() {
        String data = "";
        for (int i = 0; i < allowedTradeChars.size(); ++i) {
            String name = (String)allowedTradeChars.elementAt(i);
            if (name == null || name.length() <= 0) continue;
            if (data.length() > 0) {
                data = data + ";";
            }
            data = data + name;
        }
        if (data.length() > 0) {
            RMS.saveRMSString("chipSellerLists", data);
        } else {
            RMS.deleteRecord("chipSellerLists");
        }
    }

    public static MyVector getTradeCharList() {
        MyVector list = new MyVector();
        for (int i = 0; i < allowedTradeChars.size(); ++i) {
            String name = (String)allowedTradeChars.elementAt(i);
            list.addElement(i + 1 + ". " + name);
        }
        return list;
    }

    public final boolean handleTradeCommand(String sender, String message) {
        if (!AutoTrade.isAllowedTrader(sender)) {
            return false;
        }
        if (message.startsWith("@cmdcall")) {
            String[] splitMsg;
            if ((message = Code.sellerAI(message)) != null && message.length() > 0 && (splitMsg = Code.split(message, " ")).length >= 2) {
                String[] itemIDs = Code.split(splitMsg[1], ":");
                if (AutoTrade.hasAnyItem(itemIDs)) {
                    try {
                        String[] location = Code.split(splitMsg[0], ":");
                        int mapId = Integer.parseInt(location[0]);
                        int zoneId = Integer.parseInt(location[1]);
                        int itemCount = Integer.parseInt(location[2]);
                        AutoTrade trader = AutoTrade.gI();
                        trader.update();
                        trader.resetTrade();
                        trader.targetCharName = sender;
                        trader.mapID = mapId;
                        trader.zoneID = zoneId;
                        trader.advAG = TileMap.isHang(mapId);
                        trader.itemLimitPerTrade = itemCount;
                        trader.itemIDList = itemIDs;
                        Code.setAuto(trader);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                Code.sellerAB(sender, "chua co hang goi cc");
            }
        } else if (message.equals("Hi\u1ec7n t\u1ea1i kh\u00f4ng online.") || message.indexOf("em an com roi") != -1) {
            this.waitLockStart = System.currentTimeMillis() - 55000L;
            return true;
        }
        return false;
    }

    private static boolean hasAnyItem(String[] ids) {
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                try {
                    short id = Short.parseShort(ids[i]);
                    for (int j = 0; j < Char.getMyChar().arrItemBag.length; ++j) {
                        Item item = Char.getMyChar().arrItemBag[j];
                        if (item == null || item.isLock || item.template.id != id) continue;
                        return true;
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static boolean matchesItem(Item item, String[] ids) {
        if (ids != null && item != null && !item.isLock) {
            for (int i = 0; i < ids.length; ++i) {
                try {
                    if (Short.parseShort(ids[i]) == item.template.id) {
                        return true;
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static boolean isAllowedTrader(String name) {
        return !allowedTradeChars.isEmpty() && allowedTradeChars.contains(name);
    }

    public static boolean removeTradeChar(String name) {
        if (AutoTrade.isAllowedTrader(name)) {
            allowedTradeChars.removeElement(name);
            return true;
        }
        return false;
    }

    public static boolean addTradeChar(String name) {
        if (!AutoTrade.isAllowedTrader(name)) {
            allowedTradeChars.addElement(name);
            return true;
        }
        return false;
    }

    private static Char findCharByName(String name) {
        if (name != null && name.length() > 0) {
            for (int i = 0; i < GameScr.vCharInMap.size(); ++i) {
                Char c = (Char)GameScr.vCharInMap.elementAt(i);
                if (!c.cName.equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    private void cancelTrade() {
        this.itemIDList = null;
        this.targetCharName = null;
        if (this.T != null && !(this.T instanceof AutoTrade)) {
            Code.java_AC();
        } else {
            Code.endAuto();
        }
    }

    @Override
    protected final void auto() {
        if (AutoTrade.isMyCharInactive()) {
            this.resetTrade();
            AutoTrade.advAA(true);
        } else if (this.mapID == TileMap.mapID && this.zoneID == TileMap.zoneID) {
            if (this.targetChar == null) {
                if (GameScr.isPaintTrade) {
                    GameScr.gI().resetButton();
                    if (this.tradeStep != 0) {
                        this.resetTrade();
                    }
                }
                if ((this.targetChar = AutoTrade.findCharByName(this.targetCharName)) != null) {
                    this.searchAttempt = 0;
                } else if (System.currentTimeMillis() - this.searchStartTime > 6000L) {
                    if (this.searchAttempt >= 10) {
                        this.resetTrade();
                        this.cancelTrade();
                        return;
                    }
                    ++this.searchAttempt;
                    this.searchStartTime = System.currentTimeMillis();
                    GameScr.paint("Kh\u00f4ng t\u00ecm th\u1ea5y acc nh\u1eadn \u0111\u1ed3: " + this.targetCharName);
                }
            } else {
                switch (this.tradeStep) {
                    case -45: 
                    case -37: {
                        if (System.currentTimeMillis() - this.lastInviteTime <= 35000L) break;
                        GameCanvas.endDlg();
                        GameScr.gI().resetButton();
                        this.resetTrade();
                        break;
                    }
                    case 0: {
                        if (System.currentTimeMillis() - this.lastInviteTime <= 35000L) break;
                        this.lastInviteTime = System.currentTimeMillis();
                        this.targetChar = AutoTrade.findCharByName(this.targetCharName);
                        if (this.targetChar == null) break;
                        if (Math.abs(this.targetChar.cx - Char.getMyChar().cx) > 60 || Math.abs(this.targetChar.cy - Char.getMyChar().cy) > 40) {
                            Char.moveToChar(this.targetChar.cx, this.targetChar.cy);
                            AutoTrade.sleep(2000L);
                        }
                        Service.gI().tradeInvite(this.targetChar.charID);
                        break;
                    }
                    case 37: {
                        if (this.itemLimitPerTrade <= 0) {
                            this.resetTrade();
                            this.cancelTrade();
                            return;
                        }
                        if (GameScr.isPaintTrade && GameScr.arrItemTradeOrder != null) {
                            int count = 0;
                            for (int i = 0; i < Char.getMyChar().arrItemBag.length; ++i) {
                                Item item = Char.getMyChar().arrItemBag[i];
                                if (!AutoTrade.matchesItem(item, this.itemIDList)) continue;
                                GameScr.indexSelect = item.indexUI;
                                GameScr.gI().actTradeSelectItem();
                                if (++count >= this.itemLimitPerTrade || count >= 12) break;
                            }
                            this.currentItemsAdded = count;
                            AutoTrade.sleep(1000L);
                            this.lastInviteTime = System.currentTimeMillis();
                            this.tradeStep = -37;
                            GameScr.gI().actTradeLock();
                            break;
                        }
                        if (System.currentTimeMillis() - this.lastInviteTime <= 35000L) break;
                        GameCanvas.endDlg();
                        GameScr.gI().resetButton();
                        this.resetTrade();
                        break;
                    }
                    case 45: {
                        if (GameScr.gI().typeTradeOrder > 0 && System.currentTimeMillis() - this.lastInviteTime >= 6000L) {
                            this.lastInviteTime = System.currentTimeMillis();
                            this.tradeStep = -45;
                            GameScr.gI().actTradeAccept();
                            break;
                        }
                        if (System.currentTimeMillis() - this.lastInviteTime <= 35000L) break;
                        GameCanvas.endDlg();
                        GameScr.gI().resetButton();
                        this.resetTrade();
                        break;
                    }
                    case 57: {
                        if (System.currentTimeMillis() - this.lastInviteTime <= 2000L) break;
                        this.resetTrade();
                        break;
                    }
                    case 58: {
                        if (this.itemLimitPerTrade > this.currentItemsAdded && AutoTrade.hasAnyItem(this.itemIDList)) {
                            this.resetTrade();
                            this.itemLimitPerTrade -= this.currentItemsAdded;
                            AutoTrade.sleep(2000L);
                            break;
                        }
                        this.resetTrade();
                        this.cancelTrade();
                    }
                }
            }
        } else {
            this.remap(this.mapID, this.zoneID, -1, -1);
        }
    }

    @Override
    public final String toString() {
        return "Auto giao h\u00e0ng";
    }

    static {
        allowedTradeChars = new MyVector();
        String savedList = RMS.loadRMSString("chipSellerLists");
        if (savedList != null && savedList.length() > 0) {
            String[] names = Code.split(savedList, ";");
            for (int i = 0; i < names.length; ++i) {
                if (allowedTradeChars.contains(names[i])) continue;
                allowedTradeChars.addElement(names[i]);
            }
        }
    }
}

