/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class SettingStorageClass {
    private static final String STORAGE_NAME = "SETTING_STORAGE";
    private static final int DESTINATION_DISK = 1;
    private static final int VIDEO_FORMAT_ID = 3;
    private static final int PREVIEW_FORMAT = 4;
    private static final int SHOW_SETTINGS_ON_LAUNCH = 5;
    private static final int DEFAULT_VIDEO_FORMAT_ID = 0;
    private static final int DEFAULT_PREVIEW_FORMAT = 0;
    private static final boolean DEFAULT_SHOW_SETTINGS_ON_LAUNCH = true;
    private static Hashtable Hash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void Initialize() throws Exception {
        Exception exception = null;
        RecordStore storage = null;
        try {
            storage = RecordStore.openRecordStore((String)STORAGE_NAME, (boolean)true);
            RecordEnumeration rec_enum = storage.enumerateRecords(null, null, false);
            while (rec_enum.hasNextElement()) {
                int id = rec_enum.nextRecordId();
                SettingClass setting = new SettingClass(storage.getRecord(id));
                Hash.put(new Integer(setting.GetId()), setting);
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (storage != null) {
                try {
                    storage.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static synchronized SettingClass Get(int id) {
        return (SettingClass)Hash.get(new Integer(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void Set(SettingClass setting) throws Exception {
        Exception exception = null;
        RecordStore storage = null;
        try {
            Hash.put(new Integer(setting.GetId()), setting);
            RecordStore.deleteRecordStore((String)STORAGE_NAME);
            storage = RecordStore.openRecordStore((String)STORAGE_NAME, (boolean)true);
            Enumeration hash_enum = Hash.elements();
            while (hash_enum.hasMoreElements()) {
                SettingClass item = (SettingClass)hash_enum.nextElement();
                byte[] byte_array = item.ToByteArray();
                storage.addRecord(byte_array, 0, byte_array.length);
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (storage != null) {
                try {
                    storage.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static synchronized String GetDestinationDisk() {
        SettingClass setting = SettingStorageClass.Get(1);
        if (setting != null) {
            return setting.GetStringValue();
        }
        Vector roots = UtilClass.GetFileSystemRoots();
        String def_disk = UtilClass.GetDefaultVideoDisk();
        if (roots.size() != 0) {
            String result = (String)roots.elementAt(0);
            for (int i = 0; i < roots.size(); ++i) {
                if (!def_disk.equals((String)roots.elementAt(i))) continue;
                result = def_disk;
                break;
            }
            return result;
        }
        return "";
    }

    public static synchronized void SetDestinationDisk(String value) throws Exception {
        SettingStorageClass.Set(new SettingClass(1, false, 0, value));
    }

    public static synchronized int GetVideoFormatId() {
        SettingClass setting = SettingStorageClass.Get(3);
        if (setting != null) {
            return setting.GetIntValue();
        }
        return 0;
    }

    public static synchronized void SetVideoFormatId(int value) throws Exception {
        SettingStorageClass.Set(new SettingClass(3, false, value, ""));
    }

    public static synchronized int GetPreviewFormat() {
        SettingClass setting = SettingStorageClass.Get(4);
        if (setting != null) {
            return setting.GetIntValue();
        }
        return 0;
    }

    public static synchronized void SetPreviewFormat(int value) throws Exception {
        SettingStorageClass.Set(new SettingClass(4, false, value, ""));
    }

    public static synchronized boolean GetShowSettingsOnLaunch() {
        SettingClass setting = SettingStorageClass.Get(5);
        if (setting != null) {
            return setting.GetBoolValue();
        }
        return true;
    }

    public static synchronized void SetShowSettingsOnLaunch(boolean value) throws Exception {
        SettingStorageClass.Set(new SettingClass(5, value, 0, ""));
    }
}

