/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class UtilClass {
    private static final String HEXSTR = "0123456789ABCDEF";
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private static final String URL_UNRESERVED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.~";
    private static final String URL_ENCODEDOK = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.~%";
    private static final String USER_AGENT = "YourTube";

    public static String URLDecode(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '%' && i < str.length() - 2) {
                if (HEXSTR.indexOf(str.charAt(i + 1)) >= 0 && HEXSTR.indexOf(str.charAt(i + 2)) >= 0) {
                    buf.append((char)((HEXSTR.indexOf(str.charAt(i + 1)) << 4) + HEXSTR.indexOf(str.charAt(i + 2)) & 0xFF));
                    i += 2;
                    continue;
                }
                buf.append(str.charAt(i));
                continue;
            }
            buf.append(str.charAt(i));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLEncode(String str) {
        byte[] bytes = new byte[]{};
        ByteArrayOutputStream stream = null;
        FilterOutputStream data_stream = null;
        StringBuffer buf = new StringBuffer();
        try {
            stream = new ByteArrayOutputStream();
            data_stream = new DataOutputStream(stream);
            ((DataOutputStream)data_stream).writeUTF(str);
            bytes = stream.toByteArray();
        }
        catch (Exception ex) {
        }
        finally {
            if (data_stream != null) {
                try {
                    data_stream.close();
                }
                catch (Exception ex) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {}
            }
        }
        for (int i = 2; i < bytes.length; ++i) {
            if (URL_UNRESERVED.indexOf(bytes[i]) >= 0) {
                buf.append((char)bytes[i]);
                continue;
            }
            buf.append('%').append(HEX[bytes[i] >> 4 & 0xF]).append(HEX[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public static boolean URLEncodedOk(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (URL_ENCODEDOK.indexOf(str.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String DurationToString(int duration) {
        int d = duration / 86400;
        int h = duration % 86400 / 3600;
        int m = duration % 3600 / 60;
        int s = duration % 60;
        if (d == 0) {
            return UtilClass.ZeroPad(h) + ":" + UtilClass.ZeroPad(m) + ":" + UtilClass.ZeroPad(s);
        }
        return String.valueOf(d) + "d " + UtilClass.ZeroPad(h) + ":" + UtilClass.ZeroPad(m) + ":" + UtilClass.ZeroPad(s);
    }

    public static String ZeroPad(int num) {
        if (num < 10) {
            return new String("0") + String.valueOf(num);
        }
        return String.valueOf(num);
    }

    public static String MakeValidFilename(String string) {
        String file_name = new String(string);
        file_name = file_name.replace('\\', '_');
        file_name = file_name.replace('/', '_');
        file_name = file_name.replace(':', '_');
        file_name = file_name.replace('*', '_');
        file_name = file_name.replace('?', '_');
        file_name = file_name.replace('\"', '_');
        file_name = file_name.replace('\'', '_');
        file_name = file_name.replace('>', '_');
        file_name = file_name.replace('<', '_');
        file_name = file_name.replace('|', '_');
        return file_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String MakeFullFileURL(String file_name) {
        String ex;
        FileConnection file = null;
        try {
            file = (FileConnection)Connector.open((String)("file:///" + SettingStorageClass.GetDestinationDisk() + "DATA/Videos"));
            if (file.exists()) {
                String string = "file:///" + SettingStorageClass.GetDestinationDisk() + "DATA/Videos/" + file_name;
                return string;
            }
        }
        catch (Exception ex2) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ex3) {}
            }
        }
        file = null;
        try {
            file = (FileConnection)Connector.open((String)("file:///" + SettingStorageClass.GetDestinationDisk() + "Videos"));
            if (file.exists()) {
                ex = "file:///" + SettingStorageClass.GetDestinationDisk() + "Videos/" + file_name;
                return ex;
            }
        }
        catch (Exception ex4) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ex5) {}
            }
        }
        file = null;
        try {
            file = (FileConnection)Connector.open((String)("file:///" + SettingStorageClass.GetDestinationDisk() + "DATA/Videos"));
            file.mkdir();
            ex = "file:///" + SettingStorageClass.GetDestinationDisk() + "DATA/Videos/" + file_name;
            return ex;
        }
        catch (Exception ex6) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ex7) {}
            }
        }
        file = null;
        try {
            file = (FileConnection)Connector.open((String)("file:///" + SettingStorageClass.GetDestinationDisk() + "Videos"));
            file.mkdir();
            String ex8 = "file:///" + SettingStorageClass.GetDestinationDisk() + "Videos/" + file_name;
            return ex8;
        }
        catch (Exception ex9) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    public static boolean ValidateFileConnectionAPI() {
        return System.getProperty("microedition.io.file.FileConnection.version") != null;
    }

    public static Vector GetFileSystemRoots() {
        Vector roots = new Vector();
        try {
            Enumeration root_enum = FileSystemRegistry.listRoots();
            while (root_enum.hasMoreElements()) {
                roots.addElement(root_enum.nextElement());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roots;
    }

    public static String GetDefaultVideoDisk() {
        String path = System.getProperty("fileconn.dir.videos");
        if (path != null) {
            int pos = path.indexOf("file:///");
            if (pos != -1) {
                path = path.substring(pos + 8, path.length());
            }
            if ((pos = path.indexOf("/")) != -1) {
                path = path.substring(0, pos + 1);
            }
            return path;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image LoadImageFromURL(String url) {
        Image result = null;
        HttpConnection connection = null;
        InputStream stream = null;
        try {
            connection = (HttpConnection)Connector.open((String)url);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", USER_AGENT);
            stream = connection.openInputStream();
            result = Image.createImage((InputStream)stream);
        }
        catch (Exception ex) {
            result = null;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    public static Image ResizeImageToWidth(Image image, int width) {
        int src_width = image.getWidth();
        int src_height = image.getHeight();
        int height = width * src_height / src_width;
        Image result = Image.createImage((int)width, (int)height);
        Graphics graphics = result.getGraphics();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                graphics.setClip(x, y, 1, 1);
                int dx = x * src_width / width;
                int dy = y * src_height / height;
                graphics.drawImage(image, x - dx, y - dy, 20);
            }
        }
        return Image.createImage((Image)result);
    }
}

