/*
 * Decompiled with CFR 0.152.
 */
package com.alsutton.xmlparser;

import com.alsutton.xmlparser.EndOfXMLException;
import com.alsutton.xmlparser.XMLEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;

public class XMLParser {
    private Reader inputReader;
    private XMLEventListener eventHandler;
    private String rootTag = null;
    private boolean isUTF8Encoded;
    private StringBuffer dataBuffer;
    private InputStream is;
    private boolean convertTagsToLowerCase;

    public XMLParser(XMLEventListener _eventHandler) {
        this.eventHandler = _eventHandler;
        this.dataBuffer = new StringBuffer();
        this.convertTagsToLowerCase = true;
    }

    public void convertAllTagNamesToLowerCase(boolean doConversion) {
        this.convertTagsToLowerCase = doConversion;
    }

    public void setInputUTF8Encoded(boolean flag) {
        this.isUTF8Encoded = flag;
    }

    public int getNextCharacter() throws IOException {
        int actualValue = -1;
        int inputValue = this.inputReader.read();
        if (inputValue == -1) {
            return -1;
        }
        if (!this.isUTF8Encoded) {
            actualValue = inputValue;
        } else if (((inputValue &= 0xFF) & 0x80) == 0) {
            actualValue = inputValue;
        } else if ((inputValue & 0xF8) == 240) {
            actualValue = (inputValue & 0x1F) << 6;
            int nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += (nextByte & 0x3F) << 6;
            nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += (nextByte & 0x3F) << 6;
            nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += nextByte & 0x3F;
        } else if ((inputValue & 0xF0) == 224) {
            actualValue = (inputValue & 0x1F) << 6;
            int nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += (nextByte & 0x3F) << 6;
            nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += nextByte & 0x3F;
        } else if ((inputValue & 0xE0) == 192) {
            actualValue = (inputValue & 0x1F) << 6;
            int nextByte = this.inputReader.read() & 0xFF;
            if ((nextByte & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 format");
            }
            actualValue += nextByte & 0x3F;
        }
        return actualValue;
    }

    private String readUntilEnd(char endChar) throws IOException, EndOfXMLException {
        StringBuffer data = new StringBuffer();
        int nextChar = this.getNextCharacter();
        if (nextChar == -1) {
            throw new EndOfXMLException();
        }
        while (nextChar != -1 && nextChar != endChar) {
            data.append((char)nextChar);
            nextChar = this.getNextCharacter();
        }
        if (nextChar != 60 && nextChar != 62) {
            data.append((char)nextChar);
        }
        String returnData = data.toString();
        return returnData;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private Hashtable handleAttributes(String data) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        int length = data.length();
        int i = 0;
        while (i < length) {
            StringBuffer nameBuffer = new StringBuffer();
            char thisChar = data.charAt(i);
            while (this.isWhitespace(thisChar) && i < length && ++i != length) {
                thisChar = data.charAt(i);
            }
            if (thisChar == '>' || i == length) break;
            while (thisChar != '=') {
                nameBuffer.append(thisChar);
                if (++i == length) break;
                thisChar = data.charAt(i);
            }
            if (i == length) break;
            String name = nameBuffer.toString();
            thisChar = data.charAt(++i);
            while (this.isWhitespace(thisChar) && i < length && ++i != length) {
                thisChar = data.charAt(i);
            }
            int breakOn = 0;
            if (thisChar == '\"') {
                breakOn = 1;
            } else if (thisChar == '\'') {
                breakOn = 2;
            }
            StringBuffer valueBuffer = new StringBuffer();
            if (breakOn == 0) {
                valueBuffer.append(thisChar);
            }
            ++i;
            while (i < length) {
                thisChar = data.charAt(i);
                ++i;
                if (breakOn == 0 && this.isWhitespace(thisChar) || breakOn == 1 && thisChar == '\"' || breakOn == 2 && thisChar == '\'') break;
                valueBuffer.append(thisChar);
            }
            String value = valueBuffer.toString();
            attributes.put(name, value);
        }
        return attributes;
    }

    private void handleTag() throws IOException, EndOfXMLException {
        int spaceIdx;
        boolean startTag = true;
        boolean emptyTag = false;
        boolean hasMoreData = true;
        String tagName = null;
        Hashtable attributes = null;
        String data = this.readUntilEnd('>');
        if (data.startsWith("?")) {
            return;
        }
        int substringStart = 0;
        int substringEnd = data.length();
        if (data.startsWith("/")) {
            startTag = false;
            ++substringStart;
        }
        if (data.endsWith("/")) {
            emptyTag = true;
            --substringEnd;
        }
        data = data.substring(substringStart, substringEnd);
        for (spaceIdx = 0; spaceIdx < data.length() && !this.isWhitespace(data.charAt(spaceIdx)); ++spaceIdx) {
        }
        tagName = data.substring(0, spaceIdx);
        if (this.convertTagsToLowerCase) {
            tagName = tagName.toLowerCase();
        }
        if (spaceIdx != data.length()) {
            data = data.substring(spaceIdx + 1);
            attributes = this.handleAttributes(data);
        }
        if (startTag) {
            if (this.rootTag == null) {
                this.rootTag = tagName;
            }
            this.eventHandler.tagStarted(tagName, attributes);
        }
        if (emptyTag || !startTag) {
            this.eventHandler.tagEnded(tagName);
            if (this.rootTag != null && tagName.equals(this.rootTag)) {
                throw new EndOfXMLException();
            }
        }
    }

    private void handlePlainText() throws IOException, EndOfXMLException {
        String data = this.readUntilEnd('<');
        this.eventHandler.plaintextEncountered(data);
    }

    public void parse(InputStream _is) throws IOException {
        this.is = _is;
        InputStreamReader isr = new InputStreamReader(this.is);
        this.parse(isr);
    }

    public void parse(Reader _inputReader) throws IOException {
        this.inputReader = _inputReader;
        try {
            while (true) {
                this.handlePlainText();
                this.handleTag();
            }
        }
        catch (EndOfXMLException endOfXMLException) {
            return;
        }
    }
}

