/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class DownloadStorageClass {
    private static final String STORAGE_NAME = "DOWNLOAD_STORAGE";
    private static String ValidateErrorMsg;
    private static Hashtable Hash;

    private static void SortByState(Vector vector, int left, int right) {
        if (right > left) {
            DownloadClass item;
            int i = left - 1;
            int j = right;
            while (true) {
                if (((DownloadClass)vector.elementAt(++i)).GetState() < ((DownloadClass)vector.elementAt(right)).GetState()) {
                    continue;
                }
                while (j > 0 && ((DownloadClass)vector.elementAt(--j)).GetState() > ((DownloadClass)vector.elementAt(right)).GetState()) {
                }
                if (i >= j) break;
                item = (DownloadClass)vector.elementAt(i);
                vector.setElementAt(vector.elementAt(j), i);
                vector.setElementAt(item, j);
            }
            item = (DownloadClass)vector.elementAt(i);
            vector.setElementAt(vector.elementAt(right), i);
            vector.setElementAt(item, right);
            DownloadStorageClass.SortByState(vector, left, i - 1);
            DownloadStorageClass.SortByState(vector, i + 1, right);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void Initialize() throws Exception {
        Exception exception = null;
        RecordStore storage = null;
        try {
            storage = RecordStore.openRecordStore((String)STORAGE_NAME, (boolean)true);
            RecordEnumeration rec_enum = storage.enumerateRecords(null, null, false);
            while (rec_enum.hasNextElement()) {
                int id = rec_enum.nextRecordId();
                Hash.put(new Integer(id), new DownloadClass(id, storage.getRecord(id)));
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (storage != null) {
                try {
                    storage.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static synchronized boolean Validate(DownloadClass download) {
        if (download.GetTitle().equals("")) {
            ValidateErrorMsg = "Download task title is empty";
            return false;
        }
        if (download.GetVideoId().equals("")) {
            ValidateErrorMsg = "Download task video id is empty";
            return false;
        }
        if (download.GetFullFileName().equals("")) {
            ValidateErrorMsg = "Download task file name is empty";
            return false;
        }
        Enumeration hash_enum = Hash.elements();
        while (hash_enum.hasMoreElements()) {
            DownloadClass item = (DownloadClass)hash_enum.nextElement();
            if (!download.GetFullFileName().toLowerCase().equals(item.GetFullFileName().toLowerCase())) continue;
            ValidateErrorMsg = "Download task with the same file name already exists";
            return false;
        }
        return true;
    }

    public static synchronized String GetValidateErrorMsg() {
        return ValidateErrorMsg;
    }

    public static synchronized boolean ValidateFileNameForDups(String file_name) {
        Enumeration hash_enum = Hash.elements();
        while (hash_enum.hasMoreElements()) {
            DownloadClass item = (DownloadClass)hash_enum.nextElement();
            if (!file_name.toLowerCase().equals(item.GetFileName().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public static synchronized DownloadClass Get(int id) {
        return (DownloadClass)Hash.get(new Integer(id));
    }

    public static synchronized DownloadClass GetCopy(int id) {
        if (Hash.containsKey(new Integer(id))) {
            return new DownloadClass((DownloadClass)Hash.get(new Integer(id)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void Add(DownloadClass download) throws Exception {
        Exception exception = null;
        RecordStore storage = null;
        try {
            storage = RecordStore.openRecordStore((String)STORAGE_NAME, (boolean)true);
            byte[] byte_array = download.ToByteArray();
            int id = storage.addRecord(byte_array, 0, byte_array.length);
            download.SetId(id);
            Hash.put(new Integer(id), download);
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (storage != null) {
                try {
                    storage.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void Delete(int id) throws Exception {
        Exception exception = null;
        RecordStore storage = null;
        try {
            storage = RecordStore.openRecordStore((String)STORAGE_NAME, (boolean)false);
            storage.deleteRecord(id);
            Hash.remove(new Integer(id));
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (storage != null) {
                try {
                    storage.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void Replace(int id, DownloadClass download) throws Exception {
        Exception exception = null;
        RecordStore storage = null;
        try {
            storage = RecordStore.openRecordStore((String)STORAGE_NAME, (boolean)false);
            byte[] byte_array = download.ToByteArray();
            storage.setRecord(id, byte_array, 0, byte_array.length);
            download.SetId(id);
            Hash.put(new Integer(id), download);
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (storage != null) {
                try {
                    storage.closeRecordStore();
                }
                catch (Exception ex) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static synchronized int GetCount() {
        return Hash.size();
    }

    public static synchronized Vector GetListOfCopiesSortedByState() {
        Vector<DownloadClass> result = new Vector<DownloadClass>();
        Enumeration hash_enum = Hash.elements();
        while (hash_enum.hasMoreElements()) {
            result.addElement(new DownloadClass((DownloadClass)hash_enum.nextElement()));
        }
        DownloadStorageClass.SortByState(result, 0, result.size() - 1);
        return result;
    }

    public static synchronized void SetState(int id, int state, String error_msg) throws Exception {
        DownloadClass download = DownloadStorageClass.GetCopy(id);
        if (download == null) {
            throw new Exception("Invalid id");
        }
        download.SetState(state);
        download.SetErrorMsg(error_msg);
        DownloadStorageClass.Replace(id, download);
    }

    public static synchronized void SetSize(int id, long size) throws Exception {
        DownloadClass download = DownloadStorageClass.GetCopy(id);
        if (download == null) {
            throw new Exception("Invalid id");
        }
        download.SetSize(size);
        DownloadStorageClass.Replace(id, download);
    }

    public static synchronized void SetDone(int id, long done) throws Exception {
        DownloadClass download = DownloadStorageClass.GetCopy(id);
        if (download == null) {
            throw new Exception("Invalid id");
        }
        download.SetDone(done);
        DownloadStorageClass.Replace(id, download);
    }

    public static synchronized void IncrDone(int id, int incr) throws Exception {
        DownloadClass download = DownloadStorageClass.GetCopy(id);
        if (download == null) {
            throw new Exception("Invalid id");
        }
        download.SetDone(download.GetDone() + (long)incr);
        DownloadStorageClass.Replace(id, download);
    }

    static {
        Hash = new Hashtable();
    }
}

