/*
 * Decompiled with CFR 0.152.
 */
package com.alsutton.xmlparser.objectmodel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Node {
    public Vector children;
    private Node parent;
    private String tagName;
    private StringBuffer text;
    public Hashtable attributes;

    public Node(Node _parent, String _name, Hashtable _attributes) {
        this.tagName = _name;
        this.attributes = _attributes;
        this.parent = _parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public void addText(String newText) {
        if (this.text == null) {
            this.text = new StringBuffer();
        }
        this.text.append(newText);
    }

    public void setText(String newText) {
        this.text = new StringBuffer(newText);
    }

    public String getText() {
        String textString = "";
        if (this.text != null) {
            textString = this.text.toString();
        }
        return textString;
    }

    public String getName() {
        return this.tagName;
    }

    public void addChild(Node childNode) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(childNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Node childNode) {
        boolean removed = this.children.removeElement(childNode);
        if (removed) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        Vector vector = this.children;
        synchronized (vector) {
            Enumeration childIterator = this.children.elements();
            while (childIterator.hasMoreElements()) {
                Node thisChild = (Node)childIterator.nextElement();
                removed = thisChild.removeChild(childNode);
                if (!removed) continue;
                return true;
            }
        }
        return false;
    }

    public Vector getChildrenByName(String name) {
        Vector namedChildren = new Vector();
        this.getChildrenByName(name, namedChildren);
        return namedChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getChildrenByName(String name, Vector store) {
        if (this.children == null) {
            return;
        }
        try {
            Vector vector = this.children;
            synchronized (vector) {
                Enumeration childIterator = this.children.elements();
                while (childIterator.hasMoreElements()) {
                    Node thisChild = (Node)childIterator.nextElement();
                    String nodeName = thisChild.getName();
                    if (nodeName.equals(name)) {
                        store.addElement(thisChild);
                    }
                    thisChild.getChildrenByName(name, store);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Node getParent() {
        return this.parent;
    }

    public byte[] getBytes() {
        String data = this.toString();
        return data.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Cloneable cloneable;
        String nodeName = this.getName();
        StringBuffer xmlRepresentation = new StringBuffer("<");
        xmlRepresentation.append(nodeName);
        if (this.attributes != null) {
            cloneable = this.attributes;
            synchronized (cloneable) {
                Enumeration attrIter = this.attributes.keys();
                while (attrIter.hasMoreElements()) {
                    String key = (String)attrIter.nextElement();
                    String value = (String)this.attributes.get(key);
                    xmlRepresentation.append(' ');
                    xmlRepresentation.append(key);
                    xmlRepresentation.append("=\"");
                    xmlRepresentation.append(value);
                    xmlRepresentation.append('\"');
                }
            }
        }
        if (!(this.children != null && this.children.size() != 0 || this.text != null && this.text.length() != 0)) {
            xmlRepresentation.append("/>");
            return xmlRepresentation.toString();
        }
        xmlRepresentation.append(">");
        if (this.text != null) {
            xmlRepresentation.append((Object)this.text);
        }
        if (this.children != null) {
            cloneable = this.children;
            synchronized (cloneable) {
                Enumeration iter = this.children.elements();
                while (iter.hasMoreElements()) {
                    Object nextObject = iter.nextElement();
                    String nodeRepresentation = nextObject.toString();
                    xmlRepresentation.append(nodeRepresentation);
                }
            }
        }
        xmlRepresentation.append("</");
        xmlRepresentation.append(nodeName);
        xmlRepresentation.append(">");
        return xmlRepresentation.toString();
    }

    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, String value) {
        if (attributeName == null || value == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(attributeName, value);
    }

    public void removeAttribute(String attributeName) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceNode(Node replacementNode) {
        String replacementNodeName = replacementNode.getName();
        String nameSpace = null;
        if (replacementNode.attributes != null) {
            // empty if block
        }
        nameSpace = (String)replacementNode.attributes.get("xmlns");
        if (this.children == null) {
            this.addChild(replacementNode);
            return;
        }
        Vector vector = this.children;
        synchronized (vector) {
            Enumeration childIter = this.children.elements();
            while (childIter.hasMoreElements()) {
                String thisNodeNamespace;
                Node thisNode = (Node)childIter.nextElement();
                String thisNodeName = thisNode.getName();
                if (!thisNodeName.equals(replacementNodeName)) continue;
                if (nameSpace == null) {
                    this.children.removeElement(thisNode);
                    this.addChild(replacementNode);
                    return;
                }
                if (thisNode.attributes == null || !nameSpace.equals(thisNodeNamespace = (String)thisNode.attributes.get("xmlns"))) continue;
                this.children.removeElement(thisNode);
                this.addChild(replacementNode);
                return;
            }
        }
        this.addChild(replacementNode);
    }

    public Vector getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children;
    }
}

