/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DropTargetEffect
extends DropTargetAdapter {
    Control control;

    public DropTargetEffect(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        this.control = control;
    }

    public Control getControl() {
        return this.control;
    }

    public Widget getItem(int n2, int n3) {
        if (this.control instanceof Table) {
            return this.getItem((Table)this.control, n2, n3);
        }
        if (this.control instanceof Tree) {
            return this.getItem((Tree)this.control, n2, n3);
        }
        return null;
    }

    Widget getItem(Table table, int n2, int n3) {
        Rectangle rectangle;
        Point point = new Point(n2, n3);
        TableItem tableItem = table.getItem(point = table.toControl(point));
        if (tableItem == null && (rectangle = table.getClientArea()).contains(point)) {
            int n4 = rectangle.x;
            while (n4 < rectangle.x + rectangle.width) {
                Point point2 = new Point(n4, point.y);
                tableItem = table.getItem(point2);
                if (tableItem != null) break;
                ++n4;
            }
        }
        return tableItem;
    }

    Widget getItem(Tree tree, int n2, int n3) {
        Rectangle rectangle;
        Point point = new Point(n2, n3);
        TreeItem treeItem = tree.getItem(point = tree.toControl(point));
        if (treeItem == null && (rectangle = tree.getClientArea()).contains(point)) {
            int n4 = rectangle.x;
            while (n4 < rectangle.x + rectangle.width) {
                Point point2 = new Point(n4, point.y);
                treeItem = tree.getItem(point2);
                if (treeItem != null) break;
                ++n4;
            }
        }
        return treeItem;
    }

    TreeItem nextItem(Tree tree, TreeItem treeItem) {
        int n2;
        if (treeItem == null) {
            return null;
        }
        if (treeItem.getExpanded()) {
            return treeItem.getItem(0);
        }
        TreeItem treeItem2 = treeItem;
        TreeItem treeItem3 = treeItem2.getParentItem();
        int n3 = treeItem3 == null ? tree.indexOf(treeItem2) : treeItem3.indexOf(treeItem2);
        int n4 = n2 = treeItem3 == null ? tree.getItemCount() : treeItem3.getItemCount();
        while (n3 + 1 >= n2) {
            if (treeItem3 == null) {
                return null;
            }
            treeItem2 = treeItem3;
            n3 = (treeItem3 = treeItem2.getParentItem()) == null ? tree.indexOf(treeItem2) : treeItem3.indexOf(treeItem2);
            n2 = treeItem3 == null ? tree.getItemCount() : treeItem3.getItemCount();
        }
        return treeItem3 == null ? tree.getItem(n3 + 1) : treeItem3.getItem(n3 + 1);
    }

    TreeItem previousItem(Tree tree, TreeItem treeItem) {
        int n2;
        if (treeItem == null) {
            return null;
        }
        TreeItem treeItem2 = treeItem;
        TreeItem treeItem3 = treeItem2.getParentItem();
        int n3 = n2 = treeItem3 == null ? tree.indexOf(treeItem2) : treeItem3.indexOf(treeItem2);
        if (n2 == 0) {
            return treeItem3;
        }
        TreeItem treeItem4 = treeItem3 == null ? tree.getItem(n2 - 1) : treeItem3.getItem(n2 - 1);
        int n4 = treeItem4.getItemCount();
        while (n4 > 0 && treeItem4.getExpanded()) {
            treeItem4 = treeItem4.getItem(n4 - 1);
            n4 = treeItem4.getItemCount();
        }
        return treeItem4;
    }
}

