/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class TIFFRandomFileAccess {
    LEDataInputStream inputStream;
    int start;
    int current;
    int next;
    byte[][] buffers;
    static final int CHUNK_SIZE = 8192;
    static final int LIST_SIZE = 128;

    public TIFFRandomFileAccess(LEDataInputStream lEDataInputStream) {
        this.inputStream = lEDataInputStream;
        this.current = this.next = this.inputStream.getPosition();
        this.start = this.next;
        this.buffers = new byte[128][];
    }

    void seek(int n2) throws IOException {
        if (n2 == this.current) {
            return;
        }
        if (n2 < this.start) {
            throw new IOException();
        }
        this.current = n2;
        if (this.current > this.next) {
            int n3 = this.current - this.next;
            int n4 = this.next / 8192;
            int n5 = this.next % 8192;
            while (n3 > 0) {
                if (n4 >= this.buffers.length) {
                    byte[][] byArray = this.buffers;
                    this.buffers = new byte[Math.max(n4 + 1, byArray.length + 128)][];
                    System.arraycopy(byArray, 0, this.buffers, 0, byArray.length);
                }
                if (this.buffers[n4] == null) {
                    this.buffers[n4] = new byte[8192];
                }
                int n6 = this.inputStream.read(this.buffers[n4], n5, Math.min(n3, 8192 - n5));
                n3 -= n6;
                this.next += n6;
                ++n4;
                n5 = 0;
            }
        }
    }

    void read(byte[] byArray) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = byArray.length;
        int n6 = Math.min(n5, this.next - this.current);
        int n7 = n5 - this.next + this.current;
        int n8 = 0;
        if (n6 > 0) {
            n4 = this.current / 8192;
            n3 = this.current % 8192;
            while (n6 > 0) {
                n2 = Math.min(n6, 8192 - n3);
                System.arraycopy(this.buffers[n4], n3, byArray, n8, n2);
                n6 -= n2;
                n8 += n2;
                ++n4;
                n3 = 0;
            }
        }
        if (n7 > 0) {
            n4 = this.next / 8192;
            n3 = this.next % 8192;
            while (n7 > 0) {
                if (n4 >= this.buffers.length) {
                    byte[][] byArray2 = this.buffers;
                    this.buffers = new byte[Math.max(n4, byArray2.length + 128)][];
                    System.arraycopy(byArray2, 0, this.buffers, 0, byArray2.length);
                }
                if (this.buffers[n4] == null) {
                    this.buffers[n4] = new byte[8192];
                }
                n2 = this.inputStream.read(this.buffers[n4], n3, Math.min(n7, 8192 - n3));
                System.arraycopy(this.buffers[n4], n3, byArray, n8, n2);
                n7 -= n2;
                this.next += n2;
                n8 += n2;
                ++n4;
                n3 = 0;
            }
        }
        this.current += n5;
    }
}

