/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

class GTKColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    private static final float PI_3 = 1.0471976f;
    private ColorTriangle triangle;
    private JLabel lastLabel;
    private JLabel label;
    private JSpinner hueSpinner;
    private JSpinner saturationSpinner;
    private JSpinner valueSpinner;
    private JSpinner redSpinner;
    private JSpinner greenSpinner;
    private JSpinner blueSpinner;
    private JTextField colorNameTF;
    private boolean settingColor;
    private float hue;
    private float saturation;
    private float brightness;
    private static final int FLAGS_CHANGED_ANGLE = 1;
    private static final int FLAGS_DRAGGING = 2;
    private static final int FLAGS_DRAGGING_TRIANGLE = 4;
    private static final int FLAGS_SETTING_COLOR = 8;
    private static final int FLAGS_FOCUSED_WHEEL = 16;
    private static final int FLAGS_FOCUSED_TRIANGLE = 32;

    private float getBrightness() {
        return this.brightness;
    }

    private float getHue() {
        return this.hue;
    }

    private float getSaturation() {
        return this.saturation;
    }

    public int getDisplayedMnemonicIndex() {
        String string = (String)UIManager.get("GTKColorChooserPanel.dispalyedMnemonicIndex");
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getMnemonic() {
        String string = (String)UIManager.get("GTKColorChooserPanel.mnemonic");
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    GTKColorChooserPanel() {
    }

    protected void buildChooser() {
        this.triangle = new ColorTriangle();
        this.triangle.setName("GTKColorChooserPanel.triangle");
        this.label = new OpaqueLabel();
        this.label.setName("GTKColorChooserPanel.colorWell");
        this.label.setOpaque(true);
        this.label.setMinimumSize(new Dimension(67, 32));
        this.label.setPreferredSize(new Dimension(67, 32));
        this.label.setMaximumSize(new Dimension(67, 32));
        this.lastLabel = new OpaqueLabel();
        this.lastLabel.setName("GTKColorChooserPanel.lastColorWell");
        this.lastLabel.setOpaque(true);
        this.lastLabel.setMinimumSize(new Dimension(67, 32));
        this.lastLabel.setPreferredSize(new Dimension(67, 32));
        this.lastLabel.setMaximumSize(new Dimension(67, 32));
        this.hueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 360, 1));
        this.saturationSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.saturationSpinner, "GTKColorChooserPanel.saturationSpinner");
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.valueSpinner, "GTKColorChooserPanel.valueSpinner");
        this.redSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.redSpinner, "GTKColorChooserPanel.redSpinner");
        this.greenSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.greenSpinner, "GTKColorChooserPanel.greenSpinner");
        this.blueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.blueSpinner, "GTKColorChooserPanel.blueSpinner");
        this.colorNameTF = new JTextField(8);
        this.setLayout(new GridBagLayout());
        this.add(this, "GTKColorChooserPanel.hue", this.hueSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.red", this.redSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.saturation", this.saturationSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.green", this.greenSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.value", this.valueSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.blue", this.blueSpinner, -1, -1);
        this.add((Component)new JSeparator(0), new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 21, 2, new Insets(14, 0, 0, 0), 0, 0));
        this.add(this, "GTKColorChooserPanel.colorName", this.colorNameTF, 0, 4);
        this.add((Component)this.triangle, new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 21, 0, new Insets(14, 20, 2, 9), 0, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.lastLabel);
        box.add(this.label);
        this.add((Component)box, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JSeparator(0), new GridBagConstraints(0, 6, 5, 1, 1.0, 0.0, 21, 2, new Insets(12, 0, 0, 0), 0, 0));
    }

    public void updateChooser() {
        if (!this.settingColor) {
            this.lastLabel.setBackground(this.getColorFromModel());
            this.setColor(this.getColorFromModel(), true, true, false);
        }
    }

    private void setBrightness(float f2) {
        this.setHSB(this.hue, this.saturation, f2);
    }

    private void setSaturation(float f2) {
        this.setHSB(this.hue, f2, this.brightness);
    }

    private void setHSB(float f2, float f3, float f4) {
        Color color = Color.getHSBColor(f2, f3, f4);
        this.hue = f2;
        this.saturation = f3;
        this.brightness = f4;
        this.setColor(color, false, false, true);
        this.settingColor = true;
        this.redSpinner.setValue(new Integer(color.getRed()));
        this.greenSpinner.setValue(new Integer(color.getGreen()));
        this.blueSpinner.setValue(new Integer(color.getBlue()));
        this.settingColor = false;
    }

    private void setSaturationAndBrightness(float f2, float f3, boolean bl2) {
        this.setHSB(this.hue, f2, f3);
        if (bl2) {
            this.settingColor = true;
            this.saturationSpinner.setValue(new Integer((int)(f2 * 255.0f)));
            this.valueSpinner.setValue(new Integer((int)(f3 * 255.0f)));
            this.settingColor = false;
        }
    }

    private void setHue(float f2, boolean bl2) {
        this.setHSB(f2, this.saturation, this.brightness);
        if (bl2) {
            this.settingColor = true;
            this.hueSpinner.setValue(new Integer((int)(f2 * 360.0f)));
            this.settingColor = false;
        }
    }

    private void setBlue(int n2) {
        this.setRGB(this.getColor().getRed() << 16 | this.getColor().getGreen() << 8 | n2);
    }

    private void setGreen(int n2) {
        this.setRGB(this.getColor().getRed() << 16 | n2 << 8 | this.getColor().getBlue());
    }

    private void setRGB(int n2) {
        Color color = new Color(n2);
        this.setColor(color, false, true, true);
        this.settingColor = true;
        this.hueSpinner.setValue(new Integer((int)(this.hue * 360.0f)));
        this.saturationSpinner.setValue(new Integer((int)(this.saturation * 255.0f)));
        this.valueSpinner.setValue(new Integer((int)(this.brightness * 255.0f)));
        this.settingColor = false;
    }

    private void setRed(int n2) {
        this.setRGB(n2 << 16 | this.getColor().getGreen() << 8 | this.getColor().getBlue());
    }

    public Color getColor() {
        return this.label.getBackground();
    }

    private void setColor(Color color, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        if (color == null) {
            color = Color.BLACK;
        }
        this.settingColor = true;
        if (bl3) {
            object = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.hue = object[0];
            this.saturation = object[1];
            this.brightness = object[2];
        }
        if (bl4) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
        this.triangle.setColor(this.hue, this.saturation, this.brightness);
        this.label.setBackground(color);
        object = Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000);
        this.colorNameTF.setText("#" + ((String)object).substring(1));
        if (bl2) {
            this.redSpinner.setValue(new Integer(color.getRed()));
            this.greenSpinner.setValue(new Integer(color.getGreen()));
            this.blueSpinner.setValue(new Integer(color.getBlue()));
            this.hueSpinner.setValue(new Integer((int)(this.hue * 360.0f)));
            this.saturationSpinner.setValue(new Integer((int)(this.saturation * 255.0f)));
            this.valueSpinner.setValue(new Integer((int)(this.brightness * 255.0f)));
        }
        this.settingColor = false;
    }

    static void compositeRequestFocus(Component component, boolean bl2) {
        if (component instanceof Container) {
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocus();
                return;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null) {
                object2 = ((Container)object).getFocusTraversalPolicy();
                Component component2 = bl2 ? ((FocusTraversalPolicy)object2).getComponentAfter((Container)object, container) : ((FocusTraversalPolicy)object2).getComponentBefore((Container)object, container);
                if (component2 != null) {
                    component2.requestFocus();
                    return;
                }
            }
        }
        component.requestFocus();
    }

    public String getDisplayName() {
        return (String)UIManager.get("GTKColorChooserPanel.nameText");
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.settingColor) {
            return;
        }
        Color color = this.getColor();
        if (changeEvent.getSource() == this.hueSpinner) {
            this.setHue(((Number)this.hueSpinner.getValue()).floatValue() / 360.0f, false);
        } else if (changeEvent.getSource() == this.saturationSpinner) {
            this.setSaturation(((Number)this.saturationSpinner.getValue()).floatValue() / 255.0f);
        } else if (changeEvent.getSource() == this.valueSpinner) {
            this.setBrightness(((Number)this.valueSpinner.getValue()).floatValue() / 255.0f);
        } else if (changeEvent.getSource() == this.redSpinner) {
            this.setRed(((Number)this.redSpinner.getValue()).intValue());
        } else if (changeEvent.getSource() == this.greenSpinner) {
            this.setGreen(((Number)this.greenSpinner.getValue()).intValue());
        } else if (changeEvent.getSource() == this.blueSpinner) {
            this.setBlue(((Number)this.blueSpinner.getValue()).intValue());
        }
    }

    private void configureSpinner(JSpinner jSpinner, String string) {
        jSpinner.addChangeListener(this);
        jSpinner.setName(string);
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.setFocusLostBehavior(1);
        }
    }

    private void add(Container container, String string, JComponent jComponent, int n2, int n3) {
        Object object;
        JLabel jLabel = new JLabel(UIManager.getString((Object)(string + "Text"), this.getLocale()));
        String string2 = (String)UIManager.get(string + "Mnemonic", this.getLocale());
        if (string2 != null) {
            try {
                jLabel.setDisplayedMnemonic(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object = (String)UIManager.get(string + "MnemonicIndex", this.getLocale());
            if (object != null) {
                try {
                    jLabel.setDisplayedMnemonicIndex(Integer.parseInt((String)object));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        jLabel.setLabelFor(jComponent);
        if (n2 < 0) {
            n2 = container.getComponentCount() % 4;
        }
        if (n3 < 0) {
            n3 = container.getComponentCount() / 4;
        }
        object = new GridBagConstraints(n2 + 1, n3, 1, 1, 0.0, 0.0, 24, 0, new Insets(4, 0, 0, 4), 0, 0);
        if (n3 == 0) {
            ((GridBagConstraints)object).insets.top = 14;
        }
        container.add((Component)jLabel, object);
        ++((GridBagConstraints)object).gridx;
        container.add((Component)jComponent, object);
    }

    private static class ColorAction
    extends AbstractAction {
        private int type;

        public void actionPerformed(ActionEvent actionEvent) {
            ColorTriangle colorTriangle = (ColorTriangle)actionEvent.getSource();
            if (colorTriangle.isWheelFocused()) {
                float f2 = colorTriangle.getGTKColorChooserPanel().getHue();
                switch (this.type) {
                    case 0: 
                    case 2: {
                        colorTriangle.incrementHue(true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        colorTriangle.incrementHue(false);
                        break;
                    }
                    case 4: {
                        colorTriangle.focusTriangle();
                        break;
                    }
                    case 5: {
                        GTKColorChooserPanel.compositeRequestFocus(colorTriangle, false);
                    }
                }
            } else {
                int n2 = 0;
                int n3 = 0;
                switch (this.type) {
                    case 0: {
                        --n3;
                        break;
                    }
                    case 1: {
                        ++n3;
                        break;
                    }
                    case 2: {
                        --n2;
                        break;
                    }
                    case 3: {
                        ++n2;
                        break;
                    }
                    case 4: {
                        GTKColorChooserPanel.compositeRequestFocus(colorTriangle, true);
                        return;
                    }
                    case 5: {
                        colorTriangle.focusWheel();
                        return;
                    }
                }
                colorTriangle.adjustSB(colorTriangle.getColorX() + n2, colorTriangle.getColorY() + n3, true);
            }
        }

        ColorAction(String string, int n2) {
            super(string);
            this.type = n2;
        }
    }

    private class ColorTriangle
    extends JPanel {
        private Image wheelImage;
        private Image triangleImage;
        private double angle;
        private int flags;
        private int circleX;
        private int circleY;

        int getColorX() {
            return this.circleX + this.getIndicatorSize() / 2 - this.getWheelXOrigin();
        }

        int getColorY() {
            return this.circleY + this.getIndicatorSize() / 2 - this.getWheelYOrigin();
        }

        private int getIndicatorSize() {
            return 8;
        }

        private int getTriangleCircumscribedRadius() {
            return 72;
        }

        private int getWheelRadius() {
            return 85;
        }

        private int getWheelWidth() {
            return 13;
        }

        private int getWheelXOrigin() {
            return 85;
        }

        private int getWheelYOrigin() {
            return 85;
        }

        void focusTriangle() {
            this.setFocusType(2);
        }

        void focusWheel() {
            this.setFocusType(1);
        }

        boolean isWheelFocused() {
            return this.isSet(16);
        }

        private void setHueAngle(double d2) {
            double d3 = this.angle;
            this.angle = d2;
            if (d2 != d3) {
                this.setFlag(1, true);
                this.repaint();
            }
        }

        private void setAngleFromHue(float f2) {
            this.setHueAngle((1.0 - (double)f2) * Math.PI * 2.0);
        }

        private void setSaturationAndBrightness(float f2, float f3) {
            int n2 = this.getTriangleCircumscribedRadius();
            int n3 = n2 * 3 / 2;
            double d2 = f3 * (float)n3;
            double d3 = d2 * Math.tan(Math.toRadians(30.0));
            double d4 = 2.0 * d3 * (double)f2 - d3;
            double d5 = Math.cos(Math.toRadians(-60.0) - this.angle) * (d2 -= (double)n2) - Math.sin(Math.toRadians(-60.0) - this.angle) * d4;
            double d6 = Math.sin(Math.toRadians(-60.0) - this.angle) * d2 + Math.cos(Math.toRadians(-60.0) - this.angle) * d4;
            int n4 = (int)d5 + this.getWheelXOrigin();
            int n5 = this.getWheelYOrigin() - (int)d6;
            this.setSaturationAndBrightness(f2, f3, n4, n5);
        }

        public void setColor(float f2, float f3, float f4) {
            if (this.isSet(8)) {
                return;
            }
            this.setAngleFromHue(f2);
            this.setSaturationAndBrightness(f3, f4);
        }

        private void setSaturationAndBrightness(float f2, float f3, int n2, int n3) {
            int n4 = Math.min(n2 -= this.getIndicatorSize() / 2, this.circleX);
            int n5 = Math.min(n3 -= this.getIndicatorSize() / 2, this.circleY);
            this.repaint(n4, n5, Math.max(this.circleX, n2) - n4 + this.getIndicatorSize() + 1, Math.max(this.circleY, n3) - n5 + this.getIndicatorSize() + 1);
            this.circleX = n2;
            this.circleY = n3;
        }

        private void setFocusType(int n2) {
            if (n2 == 0) {
                this.setFlag(16, false);
                this.setFlag(32, false);
                this.repaint();
            } else {
                int n3 = 16;
                int n4 = 32;
                if (n2 == 2) {
                    n3 = 32;
                    n4 = 16;
                }
                if (!this.isSet(n3)) {
                    this.setFlag(n3, true);
                    this.repaint();
                    this.setFlag(n4, false);
                }
            }
        }

        private boolean isSet(int n2) {
            return (this.flags & n2) == n2;
        }

        private int colorWheelLocationToRGB(int n2, int n3, double d2) {
            int n4;
            double d3 = Math.acos((double)n2 / d2);
            if (d3 < 1.0471975803375244) {
                n4 = n3 < 0 ? 0xFF0000 | Math.min(255, (int)(255.0 * d3 / 1.0471975803375244)) << 8 : 0xFF0000 | Math.min(255, (int)(255.0 * d3 / 1.0471975803375244));
            } else if (d3 < 2.094395160675049) {
                n4 = n3 < 0 ? 0xFF00 | Math.max(0, 255 - (int)(255.0 * d3 / 1.0471975803375244)) << 16 : 0xFF | Math.max(0, 255 - (int)(255.0 * (d3 -= 1.0471975803375244) / 1.0471975803375244)) << 16;
            } else {
                d3 -= 2.094395160675049;
                n4 = n3 < 0 ? 0xFF00 | Math.min(255, (int)(255.0 * d3 / 1.0471975803375244)) : 0xFF | Math.min(255, (int)(255.0 * d3 / 1.0471975803375244)) << 8;
            }
            return n4;
        }

        private boolean adjustHue(int n2, int n3, boolean bl2) {
            double d2 = Math.sqrt(n2 * n2 + n3 * n3);
            int n4 = this.getWheelRadius();
            if (!bl2 || d2 >= (double)(n4 - this.getWheelWidth()) && d2 < (double)n4) {
                double d3;
                if (n2 == 0) {
                    d3 = n3 > 0 ? 1.5707963267948966 : 4.71238898038469;
                } else {
                    d3 = Math.atan((double)n3 / (double)n2);
                    if (n2 < 0) {
                        d3 += Math.PI;
                    } else if (d3 < 0.0) {
                        d3 += Math.PI * 2;
                    }
                }
                this.setFlag(8, true);
                GTKColorChooserPanel.this.setHue((float)(1.0 - d3 / Math.PI / 2.0), true);
                this.setFlag(8, false);
                this.setHueAngle(d3);
                this.setSaturationAndBrightness(GTKColorChooserPanel.this.getSaturation(), GTKColorChooserPanel.this.getBrightness());
                return true;
            }
            return false;
        }

        boolean adjustSB(int n2, int n3, boolean bl2) {
            int n4 = this.getWheelRadius() - this.getWheelWidth();
            boolean bl3 = false;
            n3 = -n3;
            if (bl2 && (n2 < -n4 || n2 > n4 || n3 < -n4 || n3 > n4)) {
                return false;
            }
            int n5 = n4 * 3 / 2;
            double d2 = Math.cos(this.angle) * (double)n2 - Math.sin(this.angle) * (double)n3;
            double d3 = Math.sin(this.angle) * (double)n2 + Math.cos(this.angle) * (double)n3;
            if (d2 < (double)(-(n4 / 2))) {
                if (bl2) {
                    return false;
                }
                d2 = -n4 / 2;
                bl3 = true;
            } else if ((int)d2 > n4) {
                if (bl2) {
                    return false;
                }
                d2 = n4;
                bl3 = true;
            }
            int n6 = (int)(((double)n5 - d2 - (double)n4 / 2.0) * Math.tan(Math.toRadians(30.0)));
            if (d3 <= (double)(-n6)) {
                if (bl2) {
                    return false;
                }
                d3 = -n6;
                bl3 = true;
            } else if (d3 > (double)n6) {
                if (bl2) {
                    return false;
                }
                d3 = n6;
                bl3 = true;
            }
            double d4 = Math.cos(Math.toRadians(-30.0)) * d2 - Math.sin(Math.toRadians(-30.0)) * d3;
            double d5 = Math.sin(Math.toRadians(-30.0)) * d2 + Math.cos(Math.toRadians(-30.0)) * d3;
            float f2 = Math.min(1.0f, (float)(((double)n4 - d5) / (double)n5));
            float f3 = (float)(Math.tan(Math.toRadians(30.0)) * ((double)n4 - d5));
            float f4 = Math.min(1.0f, (float)(d4 / (double)f3 / 2.0 + 0.5));
            this.setFlag(8, true);
            if (bl3) {
                this.setSaturationAndBrightness(f4, f2);
            } else {
                this.setSaturationAndBrightness(f4, f2, n2 + this.getWheelXOrigin(), this.getWheelYOrigin() - n3);
            }
            GTKColorChooserPanel.this.setSaturationAndBrightness(f4, f2, true);
            this.setFlag(8, false);
            return true;
        }

        private void setFlag(int n2, boolean bl2) {
            this.flags = bl2 ? (this.flags |= n2) : (this.flags &= ~n2);
        }

        void incrementHue(boolean bl2) {
            float f2 = GTKColorChooserPanel.this.triangle.getGTKColorChooserPanel().getHue();
            f2 = bl2 ? (f2 += 0.0027777778f) : (f2 -= 0.0027777778f);
            if (f2 > 1.0f) {
                f2 -= 1.0f;
            } else if (f2 < 0.0f) {
                f2 += 1.0f;
            }
            this.getGTKColorChooserPanel().setHue(f2, true);
        }

        GTKColorChooserPanel getGTKColorChooserPanel() {
            return GTKColorChooserPanel.this;
        }

        public ColorTriangle() {
            this.enableEvents(4L);
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.setMinimumSize(new Dimension(this.getWheelRadius() * 2 + 2, this.getWheelRadius() * 2 + 2));
            this.setPreferredSize(new Dimension(this.getWheelRadius() * 2 + 2, this.getWheelRadius() * 2 + 2));
            this.setFocusTraversalKeysEnabled(false);
            this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "up");
            this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "down");
            this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "left");
            this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "right");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_UP"), "up");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_DOWN"), "down");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_LEFT"), "left");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_RIGHT"), "right");
            this.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "focusNext");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), "focusLast");
            ActionMap actionMap = (ActionMap)UIManager.get("GTKColorChooserPanel.actionMap");
            if (actionMap == null) {
                actionMap = new ActionMapUIResource();
                actionMap.put("left", new ColorAction("left", 2));
                actionMap.put("right", new ColorAction("right", 3));
                actionMap.put("up", new ColorAction("up", 0));
                actionMap.put("down", new ColorAction("down", 1));
                actionMap.put("focusNext", new ColorAction("focusNext", 4));
                actionMap.put("focusLast", new ColorAction("focusLast", 5));
                UIManager.getLookAndFeelDefaults().put("GTKColorChooserPanel.actionMap", actionMap);
            }
            SwingUtilities.replaceUIActionMap(this, actionMap);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 501 || (this.isSet(2) || this.isSet(4)) && aWTEvent.getID() == 506) {
                int n2 = this.getWheelRadius();
                int n3 = ((MouseEvent)aWTEvent).getX() - n2;
                int n4 = ((MouseEvent)aWTEvent).getY() - n2;
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
                if (!this.isSet(4) && this.adjustHue(n3, n4, aWTEvent.getID() == 501)) {
                    this.setFlag(2, true);
                    this.setFocusType(1);
                } else if (this.adjustSB(n3, n4, aWTEvent.getID() == 501)) {
                    this.setFlag(4, true);
                    this.setFocusType(2);
                } else {
                    this.setFocusType(2);
                }
            } else if (aWTEvent.getID() == 502) {
                this.setFlag(4, false);
                this.setFlag(2, false);
            } else if (aWTEvent.getID() == 1005) {
                this.setFocusType(0);
            } else if (aWTEvent.getID() == 1004) {
                if (!this.isSet(32) && !this.isSet(16)) {
                    this.setFlag(16, true);
                    this.setFocusType(1);
                }
                this.repaint();
            }
            super.processEvent(aWTEvent);
        }

        public Color getColor() {
            return GTKColorChooserPanel.this.getColor();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n2 = this.getWheelRadius();
            int n3 = this.getWheelWidth();
            Image image = this.getImage(n2);
            graphics.drawImage(image, this.getWheelXOrigin() - n2, this.getWheelYOrigin() - n2, null);
            if (this.hasFocus() && this.isSet(16)) {
                graphics.setColor(Color.BLACK);
                graphics.drawOval(this.getWheelXOrigin() - n2, this.getWheelYOrigin() - n2, 2 * n2, 2 * n2);
                graphics.drawOval(this.getWheelXOrigin() - n2 + n3, this.getWheelYOrigin() - n2 + n3, 2 * (n2 - n3), 2 * (n2 - n3));
            }
            if (Math.toDegrees(Math.PI * 2 - this.angle) <= 20.0 || Math.toDegrees(Math.PI * 2 - this.angle) >= 201.0) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            int n4 = (int)(Math.cos(this.angle) * (double)n2);
            int n5 = (int)(Math.sin(this.angle) * (double)n2);
            int n6 = (int)(Math.cos(this.angle) * (double)(n2 - n3));
            int n7 = (int)(Math.sin(this.angle) * (double)(n2 - n3));
            graphics.drawLine(n4 + n2, n5 + n2, n6 + n2, n7 + n2);
            if (this.hasFocus() && this.isSet(32)) {
                Graphics graphics2 = graphics.create();
                int n8 = this.getTriangleCircumscribedRadius();
                int n9 = (int)((double)(3 * n8) / Math.sqrt(3.0));
                graphics2.translate(this.getWheelXOrigin(), this.getWheelYOrigin());
                ((Graphics2D)graphics2).rotate(this.angle + 1.5707963267948966);
                graphics2.setColor(Color.BLACK);
                graphics2.drawLine(0, -n8, n9 / 2, n8 / 2);
                graphics2.drawLine(n9 / 2, n8 / 2, -n9 / 2, n8 / 2);
                graphics2.drawLine(-n9 / 2, n8 / 2, 0, -n8);
                graphics2.dispose();
            }
            graphics.setColor(Color.BLACK);
            graphics.drawOval(this.circleX, this.circleY, this.getIndicatorSize() - 1, this.getIndicatorSize() - 1);
            graphics.setColor(Color.WHITE);
            graphics.drawOval(this.circleX + 1, this.circleY + 1, this.getIndicatorSize() - 3, this.getIndicatorSize() - 3);
        }

        private Image getImage(int n2) {
            if (!this.isSet(1) && this.wheelImage != null && this.wheelImage.getWidth(null) == n2 * 2) {
                return this.wheelImage;
            }
            if (this.wheelImage == null || this.wheelImage.getWidth(null) != n2) {
                this.wheelImage = this.getWheelImage(n2);
            }
            int n3 = this.getTriangleCircumscribedRadius();
            int n4 = (int)((double)n3 * 3.0 / 2.0);
            int n5 = (int)((double)(2 * n4) / Math.sqrt(3.0));
            if (this.triangleImage == null || this.triangleImage.getWidth(null) != n5) {
                this.triangleImage = new BufferedImage(n5, n5, 2);
            }
            Graphics graphics = this.triangleImage.getGraphics();
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, n5, n5);
            graphics.translate(n5 / 2, 0);
            this.paintTriangle(graphics, n4, this.getColor());
            graphics.translate(-n5 / 2, 0);
            graphics.dispose();
            graphics = this.wheelImage.getGraphics();
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillOval(this.getWheelWidth(), this.getWheelWidth(), 2 * (n2 - this.getWheelWidth()), 2 * (n2 - this.getWheelWidth()));
            double d2 = Math.toRadians(-30.0) + this.angle;
            graphics.translate(n2, n2);
            ((Graphics2D)graphics).rotate(d2);
            graphics.drawImage(this.triangleImage, -n5 / 2, this.getWheelWidth() - n2, null);
            ((Graphics2D)graphics).rotate(-d2);
            graphics.translate(n5 / 2, n2 - this.getWheelWidth());
            this.setFlag(1, false);
            return this.wheelImage;
        }

        private Image getWheelImage(int n2) {
            int n3 = n2 - this.getWheelWidth();
            int n4 = n2 * 2;
            BufferedImage bufferedImage = new BufferedImage(n4, n4, 2);
            for (int i2 = -n2; i2 < n2; ++i2) {
                int n5 = i2 * i2;
                for (int i3 = -n2; i3 < n2; ++i3) {
                    double d2 = Math.sqrt(n5 + i3 * i3);
                    if (!(d2 < (double)n2) || !(d2 > (double)n3)) continue;
                    int n6 = this.colorWheelLocationToRGB(i3, i2, d2) | 0xFF000000;
                    bufferedImage.setRGB(i3 + n2, i2 + n2, n6);
                }
            }
            this.wheelImage = bufferedImage;
            return this.wheelImage;
        }

        private void paintTriangle(Graphics graphics, int n2, Color color) {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            float f2 = fArray[0];
            double d2 = n2;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = (int)((double)i2 * Math.tan(Math.toRadians(30.0)));
                float f3 = n3 * 2;
                if (n3 > 0) {
                    float f4 = (float)((double)i2 / d2);
                    for (int i3 = -n3; i3 <= n3; ++i3) {
                        float f5 = (float)i3 / f3 + 0.5f;
                        graphics.setColor(Color.getHSBColor(f2, f5, f4));
                        graphics.fillRect(i3, i2, 1, 1);
                    }
                    continue;
                }
                graphics.setColor(color);
                graphics.fillRect(0, i2, 1, 1);
            }
        }
    }

    private class OpaqueLabel
    extends JLabel {
        public boolean isOpaque() {
            return true;
        }

        private OpaqueLabel() {
        }
    }
}

