/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;

public abstract class GenericURLContext
implements Context {
    protected Hashtable myEnv = null;

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.destroySubcontext(resolveResult.getRemainingName());
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.unbind(resolveResult.getRemainingName());
        }
        finally {
            context.close();
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public GenericURLContext(Hashtable hashtable) {
        this.myEnv = hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.destroySubcontext(name.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Name name) throws NamingException {
        if (name.size() == 1) {
            this.unbind(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.unbind(name.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Object object = context.lookup(resolveResult.getRemainingName());
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupLink(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Object object = context.lookupLink(resolveResult.getRemainingName());
            return object;
        }
        finally {
            context.close();
        }
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        this.myEnv = (Hashtable)this.myEnv.clone();
        return this.myEnv.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.bind(resolveResult.getRemainingName(), object);
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rebind(resolveResult.getRemainingName(), object);
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Object object = context.lookup(name.getSuffix(1));
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupLink(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Object object = context.lookupLink(name.getSuffix(1));
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.bind(name.get(0), object);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.bind(name.getSuffix(1), object);
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.rebind(name.get(0), object);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.rebind(name.getSuffix(1), object);
            }
            finally {
                context.close();
            }
        }
    }

    protected String getURLPrefix(String string) throws NamingException {
        int n2 = string.indexOf(":");
        if (n2 < 0) {
            throw new OperationNotSupportedException("Invalid URL: " + string);
        }
        if (string.startsWith("//", ++n2)) {
            int n3 = string.indexOf("/", n2 += 2);
            n2 = n3 >= 0 ? n3 : string.length();
        }
        return string.substring(0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2) throws NamingException {
        String string3;
        String string4 = this.getURLPrefix(string);
        if (!this.urlEquals(string4, string3 = this.getURLPrefix(string2))) {
            throw new OperationNotSupportedException("Renaming using different URL prefixes not supported : " + string + " " + string2);
        }
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rename(resolveResult.getRemainingName(), this.getURLSuffix(string3, string2));
        }
        finally {
            context.close();
        }
    }

    protected boolean urlEquals(String string, String string2) {
        return string.equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Context context2 = context.createSubcontext(resolveResult.getRemainingName());
            return context2;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Context context2 = context.createSubcontext(name.getSuffix(1));
            return context2;
        }
        finally {
            context.close();
        }
    }

    protected Context getContinuationContext(Name name) throws NamingException {
        Object object = this.lookup(name.get(0));
        CannotProceedException cannotProceedException = new CannotProceedException();
        cannotProceedException.setResolvedObj(object);
        cannotProceedException.setEnvironment(this.myEnv);
        return NamingManager.getContinuationContext(cannotProceedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(Name name, Name name2) throws NamingException {
        if (name.size() == 1) {
            if (name2.size() != 1) {
                throw new OperationNotSupportedException("Renaming to a Name with more components not supported: " + name2);
            }
            this.rename(name.get(0), name2.get(0));
        } else {
            if (!this.urlEquals(name.get(0), name2.get(0))) {
                throw new OperationNotSupportedException("Renaming using different URLs as first components not supported: " + name + " " + name2);
            }
            Context context = this.getContinuationContext(name);
            try {
                context.rename(name.getSuffix(1), name2.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameParser getNameParser(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            NameParser nameParser = context.getNameParser(resolveResult.getRemainingName());
            return nameParser;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NameParser nameParser = context.getNameParser(name.getSuffix(1));
            return nameParser;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            NamingEnumeration namingEnumeration = context.list(resolveResult.getRemainingName());
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            NamingEnumeration namingEnumeration = context.listBindings(resolveResult.getRemainingName());
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NamingEnumeration namingEnumeration = context.list(name.getSuffix(1));
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NamingEnumeration namingEnumeration = context.listBindings(name.getSuffix(1));
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.myEnv = this.myEnv == null ? new Hashtable(11, 0.75f) : (Hashtable)this.myEnv.clone();
        return this.myEnv.put(string, object);
    }

    public String composeName(String string, String string2) throws NamingException {
        if (string2.equals("")) {
            return string;
        }
        if (string.equals("")) {
            return string2;
        }
        return string2 + "/" + string;
    }

    protected Name getURLSuffix(String string, String string2) throws NamingException {
        String string3 = string2.substring(string.length());
        if (string3.length() == 0) {
            return new CompositeName();
        }
        if (string3.charAt(0) == '/') {
            string3 = string3.substring(1);
        }
        try {
            return new CompositeName().add(UrlUtil.decode(string3));
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidNameException(malformedURLException.getMessage());
        }
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    protected abstract ResolveResult getRootURLContext(String var1, Hashtable var2) throws NamingException;
}

