/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ColorChooserDialog;
import javax.swing.ColorTracker;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.plaf.ColorChooserUI;

public class JColorChooser
extends JComponent
implements Accessible {
    private static final String uiClassID = "ColorChooserUI";
    private ColorSelectionModel selectionModel;
    private JComponent previewPanel;
    private AbstractColorChooserPanel[] chooserPanels = new AbstractColorChooserPanel[0];
    private boolean dragEnabled;
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String PREVIEW_PANEL_PROPERTY = "previewPanel";
    public static final String CHOOSER_PANELS_PROPERTY = "chooserPanels";
    protected AccessibleContext accessibleContext = null;

    public JColorChooser() {
        this(Color.white);
    }

    public void updateUI() {
        this.setUI((ColorChooserUI)UIManager.getUI(this));
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setColor(int n2) {
        this.setColor(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public void setColor(int n2, int n3, int n4) {
        this.setColor(new Color(n2, n3, n4));
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public Color getColor() {
        return this.selectionModel.getSelectedColor();
    }

    public JColorChooser(Color color) {
        this(new DefaultColorSelectionModel(color));
    }

    public void setColor(Color color) {
        this.selectionModel.setSelectedColor(color);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i2 = 0; i2 < this.chooserPanels.length; ++i2) {
            stringBuffer.append("[" + this.chooserPanels[i2].toString() + "]");
        }
        String string = this.previewPanel != null ? this.previewPanel.toString() : "";
        return super.paramString() + ",chooserPanels=" + stringBuffer.toString() + ",previewPanel=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJColorChooser();
        }
        return this.accessibleContext;
    }

    public JComponent getPreviewPanel() {
        return this.previewPanel;
    }

    public void setPreviewPanel(JComponent jComponent) {
        if (this.previewPanel != jComponent) {
            JComponent jComponent2 = this.previewPanel;
            this.previewPanel = jComponent;
            this.firePropertyChange(PREVIEW_PANEL_PROPERTY, jComponent2, jComponent);
        }
    }

    public AbstractColorChooserPanel[] getChooserPanels() {
        return this.chooserPanels;
    }

    public void addChooserPanel(AbstractColorChooserPanel abstractColorChooserPanel) {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.getChooserPanels();
        AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[abstractColorChooserPanelArray.length + 1];
        System.arraycopy(abstractColorChooserPanelArray, 0, abstractColorChooserPanelArray2, 0, abstractColorChooserPanelArray.length);
        abstractColorChooserPanelArray2[abstractColorChooserPanelArray2.length - 1] = abstractColorChooserPanel;
        this.setChooserPanels(abstractColorChooserPanelArray2);
    }

    public void setChooserPanels(AbstractColorChooserPanel[] abstractColorChooserPanelArray) {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = this.chooserPanels;
        this.chooserPanels = abstractColorChooserPanelArray;
        this.firePropertyChange(CHOOSER_PANELS_PROPERTY, abstractColorChooserPanelArray2, abstractColorChooserPanelArray);
    }

    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JColorChooser(ColorSelectionModel colorSelectionModel) {
        this.selectionModel = colorSelectionModel;
        this.updateUI();
        this.dragEnabled = false;
    }

    public void setSelectionModel(ColorSelectionModel colorSelectionModel) {
        ColorSelectionModel colorSelectionModel2 = this.selectionModel;
        this.selectionModel = colorSelectionModel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, colorSelectionModel2, colorSelectionModel);
    }

    public ColorChooserUI getUI() {
        return (ColorChooserUI)this.ui;
    }

    public void setUI(ColorChooserUI colorChooserUI) {
        super.setUI(colorChooserUI);
    }

    public AbstractColorChooserPanel removeChooserPanel(AbstractColorChooserPanel abstractColorChooserPanel) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.chooserPanels.length; ++i2) {
            if (this.chooserPanels[i2] != abstractColorChooserPanel) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("chooser panel not in this chooser");
        }
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = new AbstractColorChooserPanel[this.chooserPanels.length - 1];
        if (n2 == this.chooserPanels.length - 1) {
            System.arraycopy(this.chooserPanels, 0, abstractColorChooserPanelArray, 0, abstractColorChooserPanelArray.length);
        } else if (n2 == 0) {
            System.arraycopy(this.chooserPanels, 1, abstractColorChooserPanelArray, 0, abstractColorChooserPanelArray.length);
        } else {
            System.arraycopy(this.chooserPanels, 0, abstractColorChooserPanelArray, 0, n2);
            System.arraycopy(this.chooserPanels, n2 + 1, abstractColorChooserPanelArray, n2, this.chooserPanels.length - n2 - 1);
        }
        this.setChooserPanels(abstractColorChooserPanelArray);
        return abstractColorChooserPanel;
    }

    public static Color showDialog(Component component, String string, Color color) throws HeadlessException {
        JColorChooser jColorChooser = new JColorChooser(color != null ? color : Color.white);
        ColorTracker colorTracker = new ColorTracker(jColorChooser);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, colorTracker, null);
        jDialog.addWindowListener(new ColorChooserDialog.Closer());
        jDialog.addComponentListener(new ColorChooserDialog.DisposeOnClose());
        jDialog.show();
        return colorTracker.getColor();
    }

    public static JDialog createDialog(Component component, String string, boolean bl2, JColorChooser jColorChooser, ActionListener actionListener, ActionListener actionListener2) throws HeadlessException {
        return new ColorChooserDialog(component, string, bl2, jColorChooser, actionListener, actionListener2);
    }

    protected class AccessibleJColorChooser
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }

        protected AccessibleJColorChooser() {
            super(JColorChooser.this);
        }
    }
}

