/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.lang.reflect.Constructor;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;

public class NumberFormatter
extends InternationalFormatter {
    private String specialChars;

    private char getDecimalSeparator() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            return decimalFormatSymbols.getDecimalSeparator();
        }
        return '.';
    }

    private char getMinusSign() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            return decimalFormatSymbols.getMinusSign();
        }
        return '-';
    }

    private char getPositiveSign() {
        return '+';
    }

    public NumberFormatter() {
        this(NumberFormat.getNumberInstance());
    }

    private boolean isValidInsertionCharacter(char c2) {
        return Character.isDigit(c2) || this.specialChars.indexOf(c2) != -1;
    }

    boolean isNavigatable(int n2) {
        if (!super.isNavigatable(n2)) {
            return this.getBufferedChar(n2) == this.getDecimalSeparator();
        }
        return true;
    }

    private boolean isOnlyIntegerField(int n2, int n3) {
        int n4;
        if (this.isValidMask() && (n4 = this.getAttributeStart(NumberFormat.Field.INTEGER)) != -1) {
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            attributedCharacterIterator.setIndex(n4);
            return n2 <= n4 && attributedCharacterIterator.getRunLimit(NumberFormat.Field.INTEGER) <= n2 + n3;
        }
        return false;
    }

    private Object toggleExponentSign(int n2, char c2) throws BadLocationException, ParseException {
        String string = this.getFormattedTextField().getText();
        int n3 = 0;
        int n4 = this.getAttributeStart(NumberFormat.Field.EXPONENT_SIGN);
        if (n4 >= 0) {
            n3 = 1;
            n2 = n4;
        }
        string = c2 == this.getPositiveSign() ? this.getReplaceString(n2, n3, null) : this.getReplaceString(n2, n3, new String(new char[]{c2}));
        return this.stringToValue(string);
    }

    private Object toggleSign(boolean bl2) throws ParseException {
        String string;
        Object object = this.stringToValue(this.getFormattedTextField().getText());
        if (object != null && (string = object.toString()) != null && string.length() > 0) {
            if (bl2) {
                if (string.charAt(0) == '-') {
                    string = string.substring(1);
                }
            } else {
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                if (string.length() > 0 && string.charAt(0) != '-') {
                    string = "-" + string;
                }
            }
            if (string != null) {
                Class clazz = this.getValueClass();
                if (clazz == null) {
                    clazz = object.getClass();
                }
                try {
                    Constructor constructor = clazz.getConstructor(new Class[]{String.class});
                    if (constructor != null) {
                        return constructor.newInstance(new Object[]{string});
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    boolean isLegalInsertText(String string) {
        if (this.getAllowsInvalid()) {
            return true;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2) || this.specialChars.indexOf(c2) != -1) continue;
            return false;
        }
        return true;
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        Format format = this.getFormat();
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).getDecimalFormatSymbols();
        }
        return null;
    }

    public void setFormat(Format format) {
        super.setFormat(format);
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(decimalFormatSymbols.getCurrencySymbol());
            stringBuffer.append(decimalFormatSymbols.getDecimalSeparator());
            stringBuffer.append(decimalFormatSymbols.getGroupingSeparator());
            stringBuffer.append(decimalFormatSymbols.getInfinity());
            stringBuffer.append(decimalFormatSymbols.getInternationalCurrencySymbol());
            stringBuffer.append(decimalFormatSymbols.getMinusSign());
            stringBuffer.append(decimalFormatSymbols.getMonetaryDecimalSeparator());
            stringBuffer.append(decimalFormatSymbols.getNaN());
            stringBuffer.append(decimalFormatSymbols.getPercent());
            stringBuffer.append('+');
            this.specialChars = stringBuffer.toString();
        } else {
            this.specialChars = "";
        }
    }

    public NumberFormatter(NumberFormat numberFormat) {
        super(numberFormat);
        this.setFormat(numberFormat);
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
    }

    private NumberFormat.Field getFieldFrom(int n2, int n3) {
        if (this.isValidMask()) {
            int n4 = this.getFormattedTextField().getDocument().getLength();
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            if (n2 >= n4) {
                n2 += n3;
            }
            while (n2 >= 0 && n2 < n4) {
                attributedCharacterIterator.setIndex(n2);
                Map map = attributedCharacterIterator.getAttributes();
                if (map != null && map.size() > 0) {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof NumberFormat.Field)) continue;
                        return (NumberFormat.Field)object;
                    }
                }
                n2 += n3;
            }
        }
        return null;
    }

    boolean isLiteral(Map map) {
        if (!super.isLiteral(map)) {
            if (map == null) {
                return false;
            }
            int n2 = map.size();
            if (map.get(NumberFormat.Field.GROUPING_SEPARATOR) != null) {
                --n2;
                if (map.get(NumberFormat.Field.INTEGER) != null) {
                    --n2;
                }
            }
            if (map.get(NumberFormat.Field.EXPONENT_SYMBOL) != null) {
                --n2;
            }
            if (map.get(NumberFormat.Field.PERCENT) != null) {
                --n2;
            }
            if (map.get(NumberFormat.Field.PERMILLE) != null) {
                --n2;
            }
            if (map.get(NumberFormat.Field.CURRENCY) != null) {
                --n2;
            }
            return n2 == 0;
        }
        return true;
    }

    private boolean toggleSignIfNecessary(DocumentFilter.FilterBypass filterBypass, int n2, char c2) throws BadLocationException {
        if (c2 == this.getMinusSign() || c2 == this.getPositiveSign()) {
            NumberFormat.Field field = this.getFieldFrom(n2, -1);
            try {
                Object object = field == null || field != NumberFormat.Field.EXPONENT && field != NumberFormat.Field.EXPONENT_SYMBOL && field != NumberFormat.Field.EXPONENT_SIGN ? this.toggleSign(c2 == this.getPositiveSign()) : this.toggleExponentSign(n2, c2);
                if (object != null && this.isValidValue(object, false)) {
                    int n3 = this.getLiteralCountTo(n2);
                    String string = this.valueToString(object);
                    filterBypass.remove(0, filterBypass.getDocument().getLength());
                    filterBypass.insertString(0, string, null);
                    this.updateValue(object);
                    this.repositionCursor(this.getLiteralCountTo(n2) - n3 + n2, 1);
                    return true;
                }
            }
            catch (ParseException parseException) {
                this.invalidEdit();
            }
        }
        return false;
    }

    private Object convertValueToValueClass(Object object, Class clazz) {
        if (clazz != null && object instanceof Number) {
            if (clazz == Integer.class) {
                return new Integer(((Number)object).intValue());
            }
            if (clazz == Long.class) {
                return new Long(((Number)object).longValue());
            }
            if (clazz == Float.class) {
                return new Float(((Number)object).floatValue());
            }
            if (clazz == Double.class) {
                return new Double(((Number)object).doubleValue());
            }
            if (clazz == Byte.class) {
                return new Byte(((Number)object).byteValue());
            }
            if (clazz == Short.class) {
                return new Short(((Number)object).shortValue());
            }
        }
        return object;
    }

    Object stringToValue(String string, Format format) throws ParseException {
        if (format == null) {
            return string;
        }
        Object object = format.parseObject(string);
        return this.convertValueToValueClass(object, this.getValueClass());
    }

    void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
        if (!this.getAllowsInvalid() && n3 == 0 && string != null && string.length() == 1 && this.toggleSignIfNecessary(filterBypass, n2, string.charAt(0))) {
            return;
        }
        super.replace(filterBypass, n2, n3, string, attributeSet);
    }
}

