/*
 * Decompiled with CFR 0.152.
 */
package nguyenvanquan7826;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import nguyenvanquan7826.CaroGraphics;
import nguyenvanquan7826.CaroInfo;
import nguyenvanquan7826.MyImage;
import nguyenvanquan7826.PlayerName;

public class CaroFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int width = 541;
    private int height = 541;
    private CaroGraphics caroGraphics;
    public static JLabel lbStatusO;
    public static JLabel lbStatusX;
    private JLabel lbNamePlayerO;
    private JLabel lbNamePlayerX;
    private JLabel lbScoreO;
    private JLabel lbScoreX;
    private ImageIcon iconPlayerO;
    private ImageIcon iconPlayerX;
    private int scoreO = 0;
    private int scoreX = 0;
    private String playerName1 = "Ng\u01b0\u1eddi ch\u01a1i 1";
    private String playerName2 = "Ng\u01b0\u1eddi ch\u01a1i 2";
    private MyImage myImage = new MyImage();
    private PlayerName selectPlayerFrame;

    public CaroFrame() {
        this.init();
    }

    private void init() {
        this.setTitle("Caro");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.initGraphics();
        this.setJMenuBar(this.createJMenuBar());
        this.add(this.createMainPainl());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.selectPlayer();
    }

    private void initGraphics() {
        this.caroGraphics = new CaroGraphics();
        this.caroGraphics.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CaroFrame.this.caroGraphics.actionClick(e.getPoint());
                if (CaroFrame.this.caroGraphics.getWiner() > 0) {
                    CaroFrame.this.win(CaroFrame.this.caroGraphics.getWiner());
                }
            }
        });
    }

    private void selectPlayer() {
        if (this.selectPlayerFrame == null) {
            this.selectPlayerFrame = new PlayerName(this);
        }
        this.selectPlayerFrame.setVisible(true);
    }

    public void updateStatus() {
        this.playerName1 = this.selectPlayerFrame.getPlayerName1();
        this.playerName2 = this.selectPlayerFrame.getPlayerName2();
        this.caroGraphics.player = this.caroGraphics.playerRoot;
        this.lbNamePlayerX.setText(this.playerName1);
        this.lbNamePlayerO.setText(this.playerName2);
        this.caroGraphics.playerRoot = this.selectPlayerFrame.getStart() == 1;
        this.caroGraphics.player = this.caroGraphics.playerRoot;
        this.caroGraphics.setStatus();
        System.out.println("updated");
    }

    private JMenuBar createJMenuBar() {
        JMenuBar mb = new JMenuBar();
        String[] game = new String[]{"Tr\u00f2 ch\u01a1i m\u1edbi", "Hi\u1ec7p m\u1edbi", "", "Tho\u00e1t"};
        mb.add(this.createJMenu("Tr\u00f2 ch\u01a1i", game, 84));
        String[] help = new String[]{"H\u01b0\u1edbng d\u1eabn", "", "Gi\u1edbi thi\u1ec7u"};
        mb.add(this.createJMenu("H\u01b0\u1edbng d\u1eabn", help, 72));
        return mb;
    }

    private JMenu createJMenu(String menuName, String[] itemName, int key) {
        JMenu m = new JMenu(menuName);
        m.addActionListener(this);
        m.setMnemonic(key);
        int i = 0;
        while (i < itemName.length) {
            if (itemName[i].equals("")) {
                m.add(new JSeparator());
            } else {
                m.add(this.createJMenuItem(itemName[i]));
            }
            ++i;
        }
        return m;
    }

    private JMenuItem createJMenuItem(String itName) {
        JMenuItem mi = new JMenuItem(itName);
        mi.addActionListener(this);
        return mi;
    }

    private JPanel createMainPainl() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createPanelGraphics(), "Center");
        panel.add((Component)this.createSidebarPanel(true), "West");
        panel.add((Component)this.createSidebarPanel(false), "East");
        return panel;
    }

    private JPanel createPanelGraphics() {
        JPanel panelGraphics = new JPanel(null);
        panelGraphics.add((Component)this.caroGraphics, "Center");
        int bound = 10;
        this.caroGraphics.setBounds(bound, bound, 541, 541);
        panelGraphics.setPreferredSize(new Dimension(541 + bound * 2, 541 + bound * 2));
        panelGraphics.setBorder(new LineBorder(Color.black));
        panelGraphics.setBackground(Color.blue);
        return panelGraphics;
    }

    private JPanel createSidebarPanel(boolean player) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createPanelStatus(player), "First");
        panel.add((Component)this.createPlayerPanel(player), "Center");
        panel.add((Component)this.createPanelBottom(player), "Last");
        return panel;
    }

    private JPanel createPanelStatus(boolean player) {
        JPanel panelStatus = new JPanel(new GridLayout(2, 1, 2, 2));
        JPanel panel1 = new JPanel();
        if (player) {
            lbStatusX = new JLabel();
            lbStatusX.setHorizontalAlignment(0);
            this.lbNamePlayerX = new JLabel("Ng\u01b0\u1eddi ch\u01a1i 1");
            this.lbNamePlayerX.setHorizontalAlignment(0);
            this.lbScoreX = new JLabel("0");
            this.lbScoreX.setFont(this.lbScoreX.getFont().deriveFont(0, 35.0f));
            this.lbScoreX.setForeground(Color.red);
            this.lbScoreX.setHorizontalAlignment(0);
            panel1.add(lbStatusX);
            panel1.add(this.lbNamePlayerX);
            panelStatus.add(panel1);
            panelStatus.add(this.lbScoreX);
        } else {
            lbStatusO = new JLabel();
            lbStatusO.setHorizontalAlignment(0);
            this.lbNamePlayerO = new JLabel("Ng\u01b0\u1eddi ch\u01a1i 2");
            this.lbNamePlayerO.setHorizontalAlignment(0);
            this.lbScoreO = new JLabel("0");
            this.lbScoreO.setFont(this.lbScoreO.getFont().deriveFont(0, 35.0f));
            this.lbScoreO.setForeground(Color.blue);
            this.lbScoreO.setHorizontalAlignment(0);
            panel1.add(lbStatusO);
            panel1.add(this.lbNamePlayerO);
            panelStatus.add(panel1);
            panelStatus.add(this.lbScoreO);
        }
        int bound = 1;
        panelStatus.setBorder(new LineBorder(Color.green));
        panelStatus.setPreferredSize(new Dimension(this.width / 3, this.height / 6 - 25));
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(bound, bound, bound, bound));
        panel.add(panelStatus);
        return panel;
    }

    private JPanel createPlayerPanel(boolean player) {
        int boundw = 10;
        int boundh = 10;
        int h = this.height * 2 / 3 + boundh;
        int w = this.width / 3;
        String imgPlayerO = "playerO.gif";
        String imgPlayerX = "playerX.gif";
        this.iconPlayerO = new ImageIcon(this.myImage.reSizeImage(this.myImage.getMyImageIcon(imgPlayerO), w - boundw, h - boundh));
        this.iconPlayerX = new ImageIcon(this.myImage.reSizeImage(this.myImage.getMyImageIcon(imgPlayerX), w - boundw, h - boundh));
        ImageIcon icon = player ? this.iconPlayerX : this.iconPlayerO;
        JLabel lbPlayer = new JLabel(icon);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(w, h));
        panel.add((Component)lbPlayer, "Center");
        int bound = 1;
        panel.setBorder(new LineBorder(Color.green));
        JPanel panel1 = new JPanel();
        panel1.setBorder(new EmptyBorder(bound, bound, bound, bound));
        panel1.add(panel);
        return panel1;
    }

    private JPanel createPanelBottom(boolean player) {
        String[] str1 = new String[]{"\u0110i l\u1ea1i", "Xin thua"};
        String[] str2 = new String[]{"Tr\u00f2 ch\u01a1i m\u1edbi", "Hi\u1ec7p m\u1edbi"};
        String[] str = player ? str1 : str2;
        int size = str.length;
        JPanel panel = new JPanel(new GridLayout(size, 1, 5, 5));
        int i = 0;
        while (i < size) {
            panel.add(this.createJButton(str[i]));
            ++i;
        }
        int bound = 1;
        panel.setBorder(new LineBorder(Color.green));
        panel.setPreferredSize(new Dimension(this.width / 3, this.height / 6));
        JPanel panel1 = new JPanel();
        panel1.setBorder(new EmptyBorder(bound, bound, bound, bound));
        panel1.add(panel);
        return panel1;
    }

    private JButton createJButton(String btnName) {
        JButton btn = new JButton(btnName);
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "Tr\u00f2 ch\u01a1i m\u1edbi") {
            this.actionNewGame();
        }
        if (command == "Hi\u1ec7p m\u1edbi") {
            this.actionNewUnit();
        }
        if (command == "Tho\u00e1t") {
            this.actionExit();
        }
        if (command == "H\u01b0\u1edbng d\u1eabn") {
            this.actionHelp();
        }
        if (command == "Gi\u1edbi thi\u1ec7u") {
            this.actionAbout();
        }
        if (command == "\u0110i l\u1ea1i") {
            this.actionUndo();
        }
        if (command == "Xin thua") {
            this.actionGiveIn();
        }
    }

    private void actionNewGame() {
        int select = this.showDialog("C\u00e1c b\u1ea1n th\u1ef1c s\u1ef1 mu\u1ed1n t\u1ea1o tr\u00f2 ch\u01a1i m\u1edbi?", "Tr\u00f2 ch\u01a1i m\u1edbi");
        if (select == 0) {
            this.scoreO = 0;
            this.scoreX = 0;
            this.clear();
        }
    }

    private void actionNewUnit() {
        int select = this.showDialog("C\u00e1c b\u1ea1n th\u1ef1c s\u1ef1 mu\u1ed1n t\u1ea1o hi\u1ec7p m\u1edbi?", "Hi\u1ec7p m\u1edbi");
        if (select == 0) {
            this.clear();
        }
    }

    private void actionExit() {
        int select = this.showDialog("C\u00e1c b\u1ea1n th\u1ef1c s\u1ef1 mu\u1ed1n tho\u00e1t?", "Tho\u00e1t");
        if (select == 0) {
            System.exit(0);
        }
    }

    private void actionHelp() {
        new CaroInfo(0);
    }

    private void actionAbout() {
        new CaroInfo(1);
    }

    private void actionUndo() {
        this.caroGraphics.undo();
    }

    private void actionGiveIn() {
        int sO = 0;
        int sX = 0;
        String playerName = "";
        if (this.caroGraphics.player) {
            sO = 1;
            playerName = this.playerName1;
        } else {
            sX = 1;
            playerName = this.playerName2;
        }
        int select = this.showDialog(String.valueOf(playerName) + " th\u1ef1c s\u1ef1 mu\u1ed1n xin thua?", "Tr\u00f2 ch\u01a1i m\u1edbi");
        if (select == 0) {
            this.scoreO += sO;
            this.scoreX += sX;
            this.clear();
        }
    }

    private int showDialog(String message, String title) {
        int select = JOptionPane.showOptionDialog(null, message, title, 0, 3, null, null, null);
        return select;
    }

    private void clear() {
        this.caroGraphics.init();
        this.updateScore();
        this.selectPlayer();
        this.caroGraphics.setStatus();
    }

    private void updateScore() {
        this.lbScoreO.setText(String.valueOf(this.scoreO));
        this.lbScoreX.setText(String.valueOf(this.scoreX));
    }

    private void win(int winer) {
        String playerName = "";
        if (winer == 1) {
            ++this.scoreX;
            playerName = this.playerName1;
        } else {
            ++this.scoreO;
            playerName = this.playerName2;
        }
        Object[] options = new Object[]{"Tr\u00f2 ch\u01a1i m\u1edbi", "Hi\u1ec7p m\u1edbi", "Tho\u00e1t"};
        int select = JOptionPane.showOptionDialog(this, "Ch\u00fac m\u1eebng " + playerName + " \u0111\u00e3 chi\u1ebfn th\u1eafng trong hi\u1ec7p \u0111\u1ea5u " + (this.scoreO + this.scoreX), "A Silly Question", 1, 3, null, options, options[options.length - 1]);
        if (select == 2) {
            this.actionExit();
        } else if (select == 0) {
            this.scoreO = 0;
            this.scoreX = 0;
        }
        this.clear();
    }
}

