/*
 * Decompiled with CFR 0.152.
 */
package nguyenvanquan7826;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoManager;
import nguyenvanquan7826.CaroFrame;
import nguyenvanquan7826.MyImage;
import nguyenvanquan7826.Process;
import nguyenvanquan7826.UndoablePaintSquare;

public class CaroGraphics
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int sizeCell = 30;
    public static final int row = 18;
    public static final int col = 18;
    public static final int width = 541;
    public static final int height = 541;
    private int sizeImg = 28;
    public boolean player;
    public boolean playerRoot;
    private Process process;
    private MyImage myImage = new MyImage();
    private Icon iconActive;
    private UndoManager undoManager = new UndoManager();
    protected Vector<Point> pointVector;
    private int winer = 0;

    public int getWiner() {
        return this.winer;
    }

    public void setWiner(int winer) {
        this.winer = winer;
    }

    public CaroGraphics() {
        this.makeIcon();
        this.setPreferredSize(new Dimension(541, 541));
        this.init();
    }

    public void init() {
        this.winer = 0;
        this.process = new Process();
        this.player = this.playerRoot;
        this.pointVector = new Vector();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(new Color(238, 238, 238));
        int i = 0;
        while (i <= 18) {
            g.drawLine(i * 30, 0, i * 30, 540);
            g.drawLine(0, i * 30, 540, i * 30);
            ++i;
        }
        this.drawImg(g);
        System.out.println("a");
    }

    private void drawImg(Graphics g) {
        boolean player = this.playerRoot;
        int i = 0;
        while (i < this.pointVector.size()) {
            Image image = player ? this.myImage.imgCross : this.myImage.imgNought;
            Point point = this.convertPointToCaro(this.convertPoint(this.pointVector.get(i)));
            g.drawImage(image, point.x, point.y, null);
            player = !player;
            ++i;
        }
    }

    private Point convertPoint(Point point) {
        int deviation = 1;
        int x = point.x % 30 > deviation ? point.x / 30 * 30 + 15 : point.x / 30 * 30 - 15;
        int y = point.y % 30 > deviation ? point.y / 30 * 30 + 15 : point.y / 30 * 30 - 15;
        return new Point(x, y);
    }

    private Point convertPointToMaxtrix(Point point) {
        return new Point(point.y / 30, point.x / 30);
    }

    private Point convertPointToCaro(Point point) {
        return new Point(point.x - this.sizeImg / 2, point.y - this.sizeImg / 2);
    }

    public void setStatus() {
        CaroFrame.lbStatusO.setIcon(this.iconActive);
        CaroFrame.lbStatusX.setIcon(this.iconActive);
        if (this.player) {
            CaroFrame.lbStatusX.setEnabled(true);
            CaroFrame.lbStatusO.setEnabled(false);
        } else {
            CaroFrame.lbStatusX.setEnabled(false);
            CaroFrame.lbStatusO.setEnabled(true);
        }
    }

    private void makeIcon() {
        this.iconActive = new ImageIcon(this.myImage.reSizeImage(this.myImage.getMyImageIcon("active.png"), 20, 20));
    }

    void actionClick(Point point) {
        Point pointTemp = this.convertPoint(point);
        if (this.process.updateMatrix(this.player, this.convertPointToMaxtrix(pointTemp))) {
            this.pointVector.addElement(point);
            this.undoManager.undoableEditHappened(new UndoableEditEvent(this, new UndoablePaintSquare(point, this.pointVector)));
            this.repaint();
            this.player = !this.player;
            this.setStatus();
            if (this.process.getWin() > 0) {
                this.winer = this.process.getWin();
            }
        }
    }

    public void undo() {
        this.player = !this.player;
        Point point = this.pointVector.get(this.pointVector.size() - 1);
        point = this.convertPointToMaxtrix(this.convertPoint(point));
        this.process.undoMatrix(point);
        this.undoManager.undo();
        this.setStatus();
        this.repaint();
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }
}

