'use strict';

//
// Autogenerated by Thrift Compiler (0.6.0-en-exported)
//
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
//


// Define types and services

var Thrift = require('../thrift');
var UserStore = require('./UserStore');
var Types = require('./Types');
var Errors = require('./Errors');
var Limits = require('./Limits');

module.exports.UserSetting = {
  'RECEIVE_REMINDER_EMAIL': 1,
  'TIMEZONE': 2
};

module.exports.ShareRelationshipPrivilegeLevel = {
  'READ_NOTEBOOK': 0,
  'READ_NOTEBOOK_PLUS_ACTIVITY': 10,
  'MODIFY_NOTEBOOK_PLUS_ACTIVITY': 20,
  'FULL_ACCESS': 30
};

module.exports.SyncState = Thrift.Struct.define('SyncState', {
  1: { alias: 'currentTime', type: Thrift.Type.I64 },
  2: { alias: 'fullSyncBefore', type: Thrift.Type.I64 },
  3: { alias: 'updateCount', type: Thrift.Type.I32 },
  4: { alias: 'uploaded', type: Thrift.Type.I64 },
  5: { alias: 'userLastUpdated', type: Thrift.Type.I64 },
  6: { alias: 'userMaxMessageEventId', type: Thrift.Type.I64 }
});

module.exports.SyncChunk = Thrift.Struct.define('SyncChunk', {
  1: { alias: 'currentTime', type: Thrift.Type.I64 },
  2: { alias: 'chunkHighUSN', type: Thrift.Type.I32 },
  3: { alias: 'updateCount', type: Thrift.Type.I32 },
  4: { alias: 'notes', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Note) },
  5: { alias: 'notebooks', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Notebook) },
  6: { alias: 'tags', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Tag) },
  7: { alias: 'searches', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.SavedSearch) },
  8: { alias: 'resources', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Resource) },
  9: { alias: 'expungedNotes', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  10: { alias: 'expungedNotebooks', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  11: { alias: 'expungedTags', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  12: { alias: 'expungedSearches', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  13: { alias: 'linkedNotebooks', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.LinkedNotebook) },
  14: { alias: 'expungedLinkedNotebooks', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) }
});

module.exports.SyncChunkFilter = Thrift.Struct.define('SyncChunkFilter', {
  1: { alias: 'includeNotes', type: Thrift.Type.BOOL },
  2: { alias: 'includeNoteResources', type: Thrift.Type.BOOL },
  3: { alias: 'includeNoteAttributes', type: Thrift.Type.BOOL },
  4: { alias: 'includeNotebooks', type: Thrift.Type.BOOL },
  5: { alias: 'includeTags', type: Thrift.Type.BOOL },
  6: { alias: 'includeSearches', type: Thrift.Type.BOOL },
  7: { alias: 'includeResources', type: Thrift.Type.BOOL },
  8: { alias: 'includeLinkedNotebooks', type: Thrift.Type.BOOL },
  9: { alias: 'includeExpunged', type: Thrift.Type.BOOL },
  10: { alias: 'includeNoteApplicationDataFullMap', type: Thrift.Type.BOOL },
  12: { alias: 'includeResourceApplicationDataFullMap', type: Thrift.Type.BOOL },
  13: { alias: 'includeNoteResourceApplicationDataFullMap', type: Thrift.Type.BOOL },
  17: { alias: 'includeSharedNotes', type: Thrift.Type.BOOL },
  16: { alias: 'omitSharedNotebooks', type: Thrift.Type.BOOL },
  11: { alias: 'requireNoteContentClass', type: Thrift.Type.STRING },
  15: { alias: 'notebookGuids', type: Thrift.Type.SET, def: Thrift.Set.define(Thrift.Type.STRING) }
});

module.exports.NoteFilter = Thrift.Struct.define('NoteFilter', {
  1: { alias: 'order', type: Thrift.Type.I32 },
  2: { alias: 'ascending', type: Thrift.Type.BOOL },
  3: { alias: 'words', type: Thrift.Type.STRING },
  4: { alias: 'notebookGuid', type: Thrift.Type.STRING },
  5: { alias: 'tagGuids', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  6: { alias: 'timeZone', type: Thrift.Type.STRING },
  7: { alias: 'inactive', type: Thrift.Type.BOOL },
  8: { alias: 'emphasized', type: Thrift.Type.STRING },
  9: { alias: 'includeAllReadableNotebooks', type: Thrift.Type.BOOL }
});

module.exports.NoteList = Thrift.Struct.define('NoteList', {
  1: { alias: 'startIndex', type: Thrift.Type.I32 },
  2: { alias: 'totalNotes', type: Thrift.Type.I32 },
  3: { alias: 'notes', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Note) },
  4: { alias: 'stoppedWords', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  5: { alias: 'searchedWords', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  6: { alias: 'updateCount', type: Thrift.Type.I32 }
});

module.exports.NoteMetadata = Thrift.Struct.define('NoteMetadata', {
  1: { alias: 'guid', type: Thrift.Type.STRING },
  2: { alias: 'title', type: Thrift.Type.STRING },
  5: { alias: 'contentLength', type: Thrift.Type.I32 },
  6: { alias: 'created', type: Thrift.Type.I64 },
  7: { alias: 'updated', type: Thrift.Type.I64 },
  8: { alias: 'deleted', type: Thrift.Type.I64 },
  10: { alias: 'updateSequenceNum', type: Thrift.Type.I32 },
  11: { alias: 'notebookGuid', type: Thrift.Type.STRING },
  12: { alias: 'tagGuids', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  14: { alias: 'attributes', type: Thrift.Type.STRUCT, def: Types.NoteAttributes },
  20: { alias: 'largestResourceMime', type: Thrift.Type.STRING },
  21: { alias: 'largestResourceSize', type: Thrift.Type.I32 }
});

module.exports.NotesMetadataList = Thrift.Struct.define('NotesMetadataList', {
  1: { alias: 'startIndex', type: Thrift.Type.I32 },
  2: { alias: 'totalNotes', type: Thrift.Type.I32 },
  3: { alias: 'notes', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.NoteMetadata) },
  4: { alias: 'stoppedWords', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  5: { alias: 'searchedWords', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  6: { alias: 'updateCount', type: Thrift.Type.I32 }
});

module.exports.NotesMetadataResultSpec = Thrift.Struct.define('NotesMetadataResultSpec', {
  2: { alias: 'includeTitle', type: Thrift.Type.BOOL },
  5: { alias: 'includeContentLength', type: Thrift.Type.BOOL },
  6: { alias: 'includeCreated', type: Thrift.Type.BOOL },
  7: { alias: 'includeUpdated', type: Thrift.Type.BOOL },
  8: { alias: 'includeDeleted', type: Thrift.Type.BOOL },
  10: { alias: 'includeUpdateSequenceNum', type: Thrift.Type.BOOL },
  11: { alias: 'includeNotebookGuid', type: Thrift.Type.BOOL },
  12: { alias: 'includeTagGuids', type: Thrift.Type.BOOL },
  14: { alias: 'includeAttributes', type: Thrift.Type.BOOL },
  20: { alias: 'includeLargestResourceMime', type: Thrift.Type.BOOL },
  21: { alias: 'includeLargestResourceSize', type: Thrift.Type.BOOL }
});

module.exports.NoteCollectionCounts = Thrift.Struct.define('NoteCollectionCounts', {
  1: { alias: 'notebookCounts', type: Thrift.Type.MAP, def: Thrift.Map.define(Thrift.Type.STRING, Thrift.Type.I32) },
  2: { alias: 'tagCounts', type: Thrift.Type.MAP, def: Thrift.Map.define(Thrift.Type.STRING, Thrift.Type.I32) },
  3: { alias: 'trashCount', type: Thrift.Type.I32 }
});

module.exports.NoteResultSpec = Thrift.Struct.define('NoteResultSpec', {
  1: { alias: 'includeContent', type: Thrift.Type.BOOL },
  2: { alias: 'includeResourcesData', type: Thrift.Type.BOOL },
  3: { alias: 'includeResourcesRecognition', type: Thrift.Type.BOOL },
  4: { alias: 'includeResourcesAlternateData', type: Thrift.Type.BOOL },
  5: { alias: 'includeSharedNotes', type: Thrift.Type.BOOL },
  6: { alias: 'includeNoteAppDataValues', type: Thrift.Type.BOOL },
  7: { alias: 'includeResourceAppDataValues', type: Thrift.Type.BOOL },
  8: { alias: 'includeAccountLimits', type: Thrift.Type.BOOL }
});

module.exports.NoteEmailParameters = Thrift.Struct.define('NoteEmailParameters', {
  1: { alias: 'guid', type: Thrift.Type.STRING },
  2: { alias: 'note', type: Thrift.Type.STRUCT, def: Types.Note },
  3: { alias: 'toAddresses', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  4: { alias: 'ccAddresses', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
  5: { alias: 'subject', type: Thrift.Type.STRING },
  6: { alias: 'message', type: Thrift.Type.STRING }
});

module.exports.NoteVersionId = Thrift.Struct.define('NoteVersionId', {
  1: { alias: 'updateSequenceNum', type: Thrift.Type.I32 },
  2: { alias: 'updated', type: Thrift.Type.I64 },
  3: { alias: 'saved', type: Thrift.Type.I64 },
  4: { alias: 'title', type: Thrift.Type.STRING },
  5: { alias: 'lastEditorId', type: Thrift.Type.I32 }
});

module.exports.RelatedQuery = Thrift.Struct.define('RelatedQuery', {
  1: { alias: 'noteGuid', type: Thrift.Type.STRING },
  2: { alias: 'plainText', type: Thrift.Type.STRING },
  3: { alias: 'filter', type: Thrift.Type.STRUCT, def: module.exports.NoteFilter },
  4: { alias: 'referenceUri', type: Thrift.Type.STRING },
  5: { alias: 'context', type: Thrift.Type.STRING },
  6: { alias: 'cacheKey', type: Thrift.Type.STRING }
});

module.exports.RelatedResult = Thrift.Struct.define('RelatedResult', {
  1: { alias: 'notes', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Note) },
  2: { alias: 'notebooks', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Notebook) },
  3: { alias: 'tags', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Tag) },
  4: { alias: 'containingNotebooks', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.NotebookDescriptor) },
  5: { alias: 'debugInfo', type: Thrift.Type.STRING },
  6: { alias: 'experts', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.UserProfile) },
  7: { alias: 'relatedContent', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.RelatedContent) },
  8: { alias: 'cacheKey', type: Thrift.Type.STRING },
  9: { alias: 'cacheExpires', type: Thrift.Type.I32 }
});

module.exports.RelatedResultSpec = Thrift.Struct.define('RelatedResultSpec', {
  1: { alias: 'maxNotes', type: Thrift.Type.I32 },
  2: { alias: 'maxNotebooks', type: Thrift.Type.I32 },
  3: { alias: 'maxTags', type: Thrift.Type.I32 },
  4: { alias: 'writableNotebooksOnly', type: Thrift.Type.BOOL },
  5: { alias: 'includeContainingNotebooks', type: Thrift.Type.BOOL },
  6: { alias: 'includeDebugInfo', type: Thrift.Type.BOOL },
  7: { alias: 'maxExperts', type: Thrift.Type.I32 },
  8: { alias: 'maxRelatedContent', type: Thrift.Type.I32 },
  9: { alias: 'relatedContentTypes', type: Thrift.Type.SET, def: Thrift.Set.define(Thrift.Type.I32) }
});

module.exports.UpdateNoteIfUsnMatchesResult = Thrift.Struct.define('UpdateNoteIfUsnMatchesResult', {
  1: { alias: 'note', type: Thrift.Type.STRUCT, def: Types.Note },
  2: { alias: 'updated', type: Thrift.Type.BOOL }
});

module.exports.ShareRelationshipRestrictions = Thrift.Struct.define('ShareRelationshipRestrictions', {
  1: { alias: 'noSetReadOnly', type: Thrift.Type.BOOL },
  2: { alias: 'noSetReadPlusActivity', type: Thrift.Type.BOOL },
  3: { alias: 'noSetModify', type: Thrift.Type.BOOL },
  4: { alias: 'noSetFullAccess', type: Thrift.Type.BOOL }
});

module.exports.InvitationShareRelationship = Thrift.Struct.define('InvitationShareRelationship', {
  1: { alias: 'displayName', type: Thrift.Type.STRING },
  2: { alias: 'recipientUserIdentity', type: Thrift.Type.STRUCT, def: Types.UserIdentity },
  3: { alias: 'privilege', type: Thrift.Type.I32 },
  5: { alias: 'sharerUserId', type: Thrift.Type.I32 }
});

module.exports.MemberShareRelationship = Thrift.Struct.define('MemberShareRelationship', {
  1: { alias: 'displayName', type: Thrift.Type.STRING },
  2: { alias: 'recipientUserId', type: Thrift.Type.I32 },
  3: { alias: 'bestPrivilege', type: Thrift.Type.I32 },
  4: { alias: 'individualPrivilege', type: Thrift.Type.I32 },
  5: { alias: 'restrictions', type: Thrift.Type.STRUCT, def: module.exports.ShareRelationshipRestrictions },
  6: { alias: 'sharerUserId', type: Thrift.Type.I32 }
});

module.exports.ShareRelationships = Thrift.Struct.define('ShareRelationships', {
  1: { alias: 'invitations', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.InvitationShareRelationship) },
  2: { alias: 'memberships', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.MemberShareRelationship) },
  3: { alias: 'invitationRestrictions', type: Thrift.Type.STRUCT, def: module.exports.ShareRelationshipRestrictions }
});

module.exports.ManageNotebookSharesParameters = Thrift.Struct.define('ManageNotebookSharesParameters', {
  1: { alias: 'notebookGuid', type: Thrift.Type.STRING },
  2: { alias: 'inviteMessage', type: Thrift.Type.STRING },
  3: { alias: 'membershipsToUpdate', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.MemberShareRelationship) },
  4: { alias: 'invitationsToCreateOrUpdate', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.InvitationShareRelationship) },
  5: { alias: 'unshares', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.UserIdentity) }
});

module.exports.ManageNotebookSharesError = Thrift.Struct.define('ManageNotebookSharesError', {
  1: { alias: 'userIdentity', type: Thrift.Type.STRUCT, def: Types.UserIdentity },
  2: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
  3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
});

module.exports.ManageNotebookSharesResult = Thrift.Struct.define('ManageNotebookSharesResult', {
  1: { alias: 'errors', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.ManageNotebookSharesError) }
});

module.exports.SharedNoteTemplate = Thrift.Struct.define('SharedNoteTemplate', {
  1: { alias: 'noteGuid', type: Thrift.Type.STRING },
  4: { alias: 'recipientThreadId', type: Thrift.Type.I64 },
  2: { alias: 'recipientContacts', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Contact) },
  3: { alias: 'privilege', type: Thrift.Type.I32 }
});

module.exports.NotebookShareTemplate = Thrift.Struct.define('NotebookShareTemplate', {
  1: { alias: 'notebookGuid', type: Thrift.Type.STRING },
  4: { alias: 'recipientThreadId', type: Thrift.Type.I64 },
  2: { alias: 'recipientContacts', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Contact) },
  3: { alias: 'privilege', type: Thrift.Type.I32 }
});

module.exports.CreateOrUpdateNotebookSharesResult = Thrift.Struct.define('CreateOrUpdateNotebookSharesResult', {
  1: { alias: 'updateSequenceNum', type: Thrift.Type.I32 },
  2: { alias: 'matchingShares', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.SharedNotebook) }
});

module.exports.NoteShareRelationshipRestrictions = Thrift.Struct.define('NoteShareRelationshipRestrictions', {
  1: { alias: 'noSetReadNote', type: Thrift.Type.BOOL },
  2: { alias: 'noSetModifyNote', type: Thrift.Type.BOOL },
  3: { alias: 'noSetFullAccess', type: Thrift.Type.BOOL }
});

module.exports.NoteMemberShareRelationship = Thrift.Struct.define('NoteMemberShareRelationship', {
  1: { alias: 'displayName', type: Thrift.Type.STRING },
  2: { alias: 'recipientUserId', type: Thrift.Type.I32 },
  3: { alias: 'privilege', type: Thrift.Type.I32 },
  4: { alias: 'restrictions', type: Thrift.Type.STRUCT, def: module.exports.NoteShareRelationshipRestrictions },
  5: { alias: 'sharerUserId', type: Thrift.Type.I32 }
});

module.exports.NoteInvitationShareRelationship = Thrift.Struct.define('NoteInvitationShareRelationship', {
  1: { alias: 'displayName', type: Thrift.Type.STRING },
  2: { alias: 'recipientIdentityId', type: Thrift.Type.I64 },
  3: { alias: 'privilege', type: Thrift.Type.I32 },
  5: { alias: 'sharerUserId', type: Thrift.Type.I32 }
});

module.exports.NoteShareRelationships = Thrift.Struct.define('NoteShareRelationships', {
  1: { alias: 'invitations', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.NoteInvitationShareRelationship) },
  2: { alias: 'memberships', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.NoteMemberShareRelationship) },
  3: { alias: 'invitationRestrictions', type: Thrift.Type.STRUCT, def: module.exports.NoteShareRelationshipRestrictions }
});

module.exports.ManageNoteSharesParameters = Thrift.Struct.define('ManageNoteSharesParameters', {
  1: { alias: 'noteGuid', type: Thrift.Type.STRING },
  2: { alias: 'membershipsToUpdate', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.NoteMemberShareRelationship) },
  3: { alias: 'invitationsToUpdate', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.NoteInvitationShareRelationship) },
  4: { alias: 'membershipsToUnshare', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.I32) },
  5: { alias: 'invitationsToUnshare', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.I64) }
});

module.exports.ManageNoteSharesError = Thrift.Struct.define('ManageNoteSharesError', {
  1: { alias: 'identityID', type: Thrift.Type.I64 },
  2: { alias: 'userID', type: Thrift.Type.I32 },
  3: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
  4: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
});

module.exports.ManageNoteSharesResult = Thrift.Struct.define('ManageNoteSharesResult', {
  1: { alias: 'errors', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.ManageNoteSharesError) }
});

var NoteStore = module.exports.NoteStore = {};

NoteStore.getSyncState = Thrift.Method.define({
  alias: 'getSyncState',
  args: Thrift.Struct.define('getSyncStateArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getSyncStateResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.SyncState },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.getFilteredSyncChunk = Thrift.Method.define({
  alias: 'getFilteredSyncChunk',
  args: Thrift.Struct.define('getFilteredSyncChunkArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'afterUSN', type: Thrift.Type.I32, index: 1 },
    3: { alias: 'maxEntries', type: Thrift.Type.I32, index: 2 },
    4: { alias: 'filter', type: Thrift.Type.STRUCT, def: module.exports.SyncChunkFilter, index: 3 }
  }),
  result: Thrift.Struct.define('getFilteredSyncChunkResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.SyncChunk },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.getLinkedNotebookSyncState = Thrift.Method.define({
  alias: 'getLinkedNotebookSyncState',
  args: Thrift.Struct.define('getLinkedNotebookSyncStateArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'linkedNotebook', type: Thrift.Type.STRUCT, def: Types.LinkedNotebook, index: 1 }
  }),
  result: Thrift.Struct.define('getLinkedNotebookSyncStateResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.SyncState },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getLinkedNotebookSyncChunk = Thrift.Method.define({
  alias: 'getLinkedNotebookSyncChunk',
  args: Thrift.Struct.define('getLinkedNotebookSyncChunkArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'linkedNotebook', type: Thrift.Type.STRUCT, def: Types.LinkedNotebook, index: 1 },
    3: { alias: 'afterUSN', type: Thrift.Type.I32, index: 2 },
    4: { alias: 'maxEntries', type: Thrift.Type.I32, index: 3 },
    5: { alias: 'fullSyncOnly', type: Thrift.Type.BOOL, index: 4 }
  }),
  result: Thrift.Struct.define('getLinkedNotebookSyncChunkResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.SyncChunk },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.listNotebooks = Thrift.Method.define({
  alias: 'listNotebooks',
  args: Thrift.Struct.define('listNotebooksArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listNotebooksResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Notebook) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.listAccessibleBusinessNotebooks = Thrift.Method.define({
  alias: 'listAccessibleBusinessNotebooks',
  args: Thrift.Struct.define('listAccessibleBusinessNotebooksArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listAccessibleBusinessNotebooksResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Notebook) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.getNotebook = Thrift.Method.define({
  alias: 'getNotebook',
  args: Thrift.Struct.define('getNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Notebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getDefaultNotebook = Thrift.Method.define({
  alias: 'getDefaultNotebook',
  args: Thrift.Struct.define('getDefaultNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getDefaultNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Notebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.createNotebook = Thrift.Method.define({
  alias: 'createNotebook',
  args: Thrift.Struct.define('createNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'notebook', type: Thrift.Type.STRUCT, def: Types.Notebook, index: 1 }
  }),
  result: Thrift.Struct.define('createNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Notebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.updateNotebook = Thrift.Method.define({
  alias: 'updateNotebook',
  args: Thrift.Struct.define('updateNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'notebook', type: Thrift.Type.STRUCT, def: Types.Notebook, index: 1 }
  }),
  result: Thrift.Struct.define('updateNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.expungeNotebook = Thrift.Method.define({
  alias: 'expungeNotebook',
  args: Thrift.Struct.define('expungeNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('expungeNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.listTags = Thrift.Method.define({
  alias: 'listTags',
  args: Thrift.Struct.define('listTagsArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listTagsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Tag) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.listTagsByNotebook = Thrift.Method.define({
  alias: 'listTagsByNotebook',
  args: Thrift.Struct.define('listTagsByNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'notebookGuid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('listTagsByNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.Tag) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getTag = Thrift.Method.define({
  alias: 'getTag',
  args: Thrift.Struct.define('getTagArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getTagResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Tag },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.createTag = Thrift.Method.define({
  alias: 'createTag',
  args: Thrift.Struct.define('createTagArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'tag', type: Thrift.Type.STRUCT, def: Types.Tag, index: 1 }
  }),
  result: Thrift.Struct.define('createTagResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Tag },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.updateTag = Thrift.Method.define({
  alias: 'updateTag',
  args: Thrift.Struct.define('updateTagArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'tag', type: Thrift.Type.STRUCT, def: Types.Tag, index: 1 }
  }),
  result: Thrift.Struct.define('updateTagResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.untagAll = Thrift.Method.define({
  alias: 'untagAll',
  args: Thrift.Struct.define('untagAllArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('untagAllResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.expungeTag = Thrift.Method.define({
  alias: 'expungeTag',
  args: Thrift.Struct.define('expungeTagArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('expungeTagResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.listSearches = Thrift.Method.define({
  alias: 'listSearches',
  args: Thrift.Struct.define('listSearchesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listSearchesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.SavedSearch) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.getSearch = Thrift.Method.define({
  alias: 'getSearch',
  args: Thrift.Struct.define('getSearchArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getSearchResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.SavedSearch },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.createSearch = Thrift.Method.define({
  alias: 'createSearch',
  args: Thrift.Struct.define('createSearchArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'search', type: Thrift.Type.STRUCT, def: Types.SavedSearch, index: 1 }
  }),
  result: Thrift.Struct.define('createSearchResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.SavedSearch },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.updateSearch = Thrift.Method.define({
  alias: 'updateSearch',
  args: Thrift.Struct.define('updateSearchArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'search', type: Thrift.Type.STRUCT, def: Types.SavedSearch, index: 1 }
  }),
  result: Thrift.Struct.define('updateSearchResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.expungeSearch = Thrift.Method.define({
  alias: 'expungeSearch',
  args: Thrift.Struct.define('expungeSearchArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('expungeSearchResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.findNoteOffset = Thrift.Method.define({
  alias: 'findNoteOffset',
  args: Thrift.Struct.define('findNoteOffsetArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'filter', type: Thrift.Type.STRUCT, def: module.exports.NoteFilter, index: 1 },
    3: { alias: 'guid', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('findNoteOffsetResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.findNotesMetadata = Thrift.Method.define({
  alias: 'findNotesMetadata',
  args: Thrift.Struct.define('findNotesMetadataArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'filter', type: Thrift.Type.STRUCT, def: module.exports.NoteFilter, index: 1 },
    3: { alias: 'offset', type: Thrift.Type.I32, index: 2 },
    4: { alias: 'maxNotes', type: Thrift.Type.I32, index: 3 },
    5: { alias: 'resultSpec', type: Thrift.Type.STRUCT, def: module.exports.NotesMetadataResultSpec, index: 4 }
  }),
  result: Thrift.Struct.define('findNotesMetadataResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.NotesMetadataList },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.findNoteCounts = Thrift.Method.define({
  alias: 'findNoteCounts',
  args: Thrift.Struct.define('findNoteCountsArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'filter', type: Thrift.Type.STRUCT, def: module.exports.NoteFilter, index: 1 },
    3: { alias: 'withTrash', type: Thrift.Type.BOOL, index: 2 }
  }),
  result: Thrift.Struct.define('findNoteCountsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.NoteCollectionCounts },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteWithResultSpec = Thrift.Method.define({
  alias: 'getNoteWithResultSpec',
  args: Thrift.Struct.define('getNoteWithResultSpecArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'resultSpec', type: Thrift.Type.STRUCT, def: module.exports.NoteResultSpec, index: 2 }
  }),
  result: Thrift.Struct.define('getNoteWithResultSpecResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Note },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNote = Thrift.Method.define({
  alias: 'getNote',
  args: Thrift.Struct.define('getNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'withContent', type: Thrift.Type.BOOL, index: 2 },
    4: { alias: 'withResourcesData', type: Thrift.Type.BOOL, index: 3 },
    5: { alias: 'withResourcesRecognition', type: Thrift.Type.BOOL, index: 4 },
    6: { alias: 'withResourcesAlternateData', type: Thrift.Type.BOOL, index: 5 }
  }),
  result: Thrift.Struct.define('getNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Note },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteApplicationData = Thrift.Method.define({
  alias: 'getNoteApplicationData',
  args: Thrift.Struct.define('getNoteApplicationDataArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getNoteApplicationDataResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.LazyMap },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteApplicationDataEntry = Thrift.Method.define({
  alias: 'getNoteApplicationDataEntry',
  args: Thrift.Struct.define('getNoteApplicationDataEntryArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'key', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('getNoteApplicationDataEntryResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRING },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.setNoteApplicationDataEntry = Thrift.Method.define({
  alias: 'setNoteApplicationDataEntry',
  args: Thrift.Struct.define('setNoteApplicationDataEntryArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'key', type: Thrift.Type.STRING, index: 2 },
    4: { alias: 'value', type: Thrift.Type.STRING, index: 3 }
  }),
  result: Thrift.Struct.define('setNoteApplicationDataEntryResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.unsetNoteApplicationDataEntry = Thrift.Method.define({
  alias: 'unsetNoteApplicationDataEntry',
  args: Thrift.Struct.define('unsetNoteApplicationDataEntryArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'key', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('unsetNoteApplicationDataEntryResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteContent = Thrift.Method.define({
  alias: 'getNoteContent',
  args: Thrift.Struct.define('getNoteContentArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getNoteContentResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRING },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteSearchText = Thrift.Method.define({
  alias: 'getNoteSearchText',
  args: Thrift.Struct.define('getNoteSearchTextArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'noteOnly', type: Thrift.Type.BOOL, index: 2 },
    4: { alias: 'tokenizeForIndexing', type: Thrift.Type.BOOL, index: 3 }
  }),
  result: Thrift.Struct.define('getNoteSearchTextResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRING },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceSearchText = Thrift.Method.define({
  alias: 'getResourceSearchText',
  args: Thrift.Struct.define('getResourceSearchTextArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getResourceSearchTextResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRING },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteTagNames = Thrift.Method.define({
  alias: 'getNoteTagNames',
  args: Thrift.Struct.define('getNoteTagNamesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getNoteTagNamesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRING) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.createNote = Thrift.Method.define({
  alias: 'createNote',
  args: Thrift.Struct.define('createNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'note', type: Thrift.Type.STRUCT, def: Types.Note, index: 1 }
  }),
  result: Thrift.Struct.define('createNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Note },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.updateNote = Thrift.Method.define({
  alias: 'updateNote',
  args: Thrift.Struct.define('updateNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'note', type: Thrift.Type.STRUCT, def: Types.Note, index: 1 }
  }),
  result: Thrift.Struct.define('updateNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Note },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.deleteNote = Thrift.Method.define({
  alias: 'deleteNote',
  args: Thrift.Struct.define('deleteNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('deleteNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.expungeNote = Thrift.Method.define({
  alias: 'expungeNote',
  args: Thrift.Struct.define('expungeNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('expungeNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.copyNote = Thrift.Method.define({
  alias: 'copyNote',
  args: Thrift.Struct.define('copyNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'noteGuid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'toNotebookGuid', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('copyNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Note },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.listNoteVersions = Thrift.Method.define({
  alias: 'listNoteVersions',
  args: Thrift.Struct.define('listNoteVersionsArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'noteGuid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('listNoteVersionsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.NoteVersionId) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getNoteVersion = Thrift.Method.define({
  alias: 'getNoteVersion',
  args: Thrift.Struct.define('getNoteVersionArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'noteGuid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'updateSequenceNum', type: Thrift.Type.I32, index: 2 },
    4: { alias: 'withResourcesData', type: Thrift.Type.BOOL, index: 3 },
    5: { alias: 'withResourcesRecognition', type: Thrift.Type.BOOL, index: 4 },
    6: { alias: 'withResourcesAlternateData', type: Thrift.Type.BOOL, index: 5 }
  }),
  result: Thrift.Struct.define('getNoteVersionResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Note },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResource = Thrift.Method.define({
  alias: 'getResource',
  args: Thrift.Struct.define('getResourceArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'withData', type: Thrift.Type.BOOL, index: 2 },
    4: { alias: 'withRecognition', type: Thrift.Type.BOOL, index: 3 },
    5: { alias: 'withAttributes', type: Thrift.Type.BOOL, index: 4 },
    6: { alias: 'withAlternateData', type: Thrift.Type.BOOL, index: 5 }
  }),
  result: Thrift.Struct.define('getResourceResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Resource },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceApplicationData = Thrift.Method.define({
  alias: 'getResourceApplicationData',
  args: Thrift.Struct.define('getResourceApplicationDataArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getResourceApplicationDataResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.LazyMap },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceApplicationDataEntry = Thrift.Method.define({
  alias: 'getResourceApplicationDataEntry',
  args: Thrift.Struct.define('getResourceApplicationDataEntryArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'key', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('getResourceApplicationDataEntryResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRING },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.setResourceApplicationDataEntry = Thrift.Method.define({
  alias: 'setResourceApplicationDataEntry',
  args: Thrift.Struct.define('setResourceApplicationDataEntryArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'key', type: Thrift.Type.STRING, index: 2 },
    4: { alias: 'value', type: Thrift.Type.STRING, index: 3 }
  }),
  result: Thrift.Struct.define('setResourceApplicationDataEntryResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.unsetResourceApplicationDataEntry = Thrift.Method.define({
  alias: 'unsetResourceApplicationDataEntry',
  args: Thrift.Struct.define('unsetResourceApplicationDataEntryArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'key', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('unsetResourceApplicationDataEntryResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.updateResource = Thrift.Method.define({
  alias: 'updateResource',
  args: Thrift.Struct.define('updateResourceArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'resource', type: Thrift.Type.STRUCT, def: Types.Resource, index: 1 }
  }),
  result: Thrift.Struct.define('updateResourceResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceData = Thrift.Method.define({
  alias: 'getResourceData',
  args: Thrift.Struct.define('getResourceDataArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getResourceDataResult', {
    0: { alias: 'returnValue', type: Thrift.Type.BINARY },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceByHash = Thrift.Method.define({
  alias: 'getResourceByHash',
  args: Thrift.Struct.define('getResourceByHashArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'noteGuid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'contentHash', type: Thrift.Type.BINARY, index: 2 },
    4: { alias: 'withData', type: Thrift.Type.BOOL, index: 3 },
    5: { alias: 'withRecognition', type: Thrift.Type.BOOL, index: 4 },
    6: { alias: 'withAlternateData', type: Thrift.Type.BOOL, index: 5 }
  }),
  result: Thrift.Struct.define('getResourceByHashResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Resource },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceRecognition = Thrift.Method.define({
  alias: 'getResourceRecognition',
  args: Thrift.Struct.define('getResourceRecognitionArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getResourceRecognitionResult', {
    0: { alias: 'returnValue', type: Thrift.Type.BINARY },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceAlternateData = Thrift.Method.define({
  alias: 'getResourceAlternateData',
  args: Thrift.Struct.define('getResourceAlternateDataArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getResourceAlternateDataResult', {
    0: { alias: 'returnValue', type: Thrift.Type.BINARY },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getResourceAttributes = Thrift.Method.define({
  alias: 'getResourceAttributes',
  args: Thrift.Struct.define('getResourceAttributesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getResourceAttributesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.ResourceAttributes },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.getPublicNotebook = Thrift.Method.define({
  alias: 'getPublicNotebook',
  args: Thrift.Struct.define('getPublicNotebookArgs', {
    1: { alias: 'userId', type: Thrift.Type.I32, index: 0 },
    2: { alias: 'publicUri', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getPublicNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Notebook },
    1: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.shareNotebook = Thrift.Method.define({
  alias: 'shareNotebook',
  args: Thrift.Struct.define('shareNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'sharedNotebook', type: Thrift.Type.STRUCT, def: Types.SharedNotebook, index: 1 },
    3: { alias: 'message', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('shareNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.SharedNotebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.createOrUpdateNotebookShares = Thrift.Method.define({
  alias: 'createOrUpdateNotebookShares',
  args: Thrift.Struct.define('createOrUpdateNotebookSharesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'shareTemplate', type: Thrift.Type.STRUCT, def: module.exports.NotebookShareTemplate, index: 1 }
  }),
  result: Thrift.Struct.define('createOrUpdateNotebookSharesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.CreateOrUpdateNotebookSharesResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    4: { alias: 'invalidContactsException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMInvalidContactsException }
  })
});

NoteStore.updateSharedNotebook = Thrift.Method.define({
  alias: 'updateSharedNotebook',
  args: Thrift.Struct.define('updateSharedNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'sharedNotebook', type: Thrift.Type.STRUCT, def: Types.SharedNotebook, index: 1 }
  }),
  result: Thrift.Struct.define('updateSharedNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.setNotebookRecipientSettings = Thrift.Method.define({
  alias: 'setNotebookRecipientSettings',
  args: Thrift.Struct.define('setNotebookRecipientSettingsArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'notebookGuid', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'recipientSettings', type: Thrift.Type.STRUCT, def: Types.NotebookRecipientSettings, index: 2 }
  }),
  result: Thrift.Struct.define('setNotebookRecipientSettingsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.Notebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.listSharedNotebooks = Thrift.Method.define({
  alias: 'listSharedNotebooks',
  args: Thrift.Struct.define('listSharedNotebooksArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listSharedNotebooksResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.SharedNotebook) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.createLinkedNotebook = Thrift.Method.define({
  alias: 'createLinkedNotebook',
  args: Thrift.Struct.define('createLinkedNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'linkedNotebook', type: Thrift.Type.STRUCT, def: Types.LinkedNotebook, index: 1 }
  }),
  result: Thrift.Struct.define('createLinkedNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.LinkedNotebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.updateLinkedNotebook = Thrift.Method.define({
  alias: 'updateLinkedNotebook',
  args: Thrift.Struct.define('updateLinkedNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'linkedNotebook', type: Thrift.Type.STRUCT, def: Types.LinkedNotebook, index: 1 }
  }),
  result: Thrift.Struct.define('updateLinkedNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.listLinkedNotebooks = Thrift.Method.define({
  alias: 'listLinkedNotebooks',
  args: Thrift.Struct.define('listLinkedNotebooksArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listLinkedNotebooksResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.LinkedNotebook) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.expungeLinkedNotebook = Thrift.Method.define({
  alias: 'expungeLinkedNotebook',
  args: Thrift.Struct.define('expungeLinkedNotebookArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('expungeLinkedNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.I32 },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.authenticateToSharedNotebook = Thrift.Method.define({
  alias: 'authenticateToSharedNotebook',
  args: Thrift.Struct.define('authenticateToSharedNotebookArgs', {
    1: { alias: 'shareKeyOrGlobalId', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('authenticateToSharedNotebookResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: UserStore.AuthenticationResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.getSharedNotebookByAuth = Thrift.Method.define({
  alias: 'getSharedNotebookByAuth',
  args: Thrift.Struct.define('getSharedNotebookByAuthArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getSharedNotebookByAuthResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.SharedNotebook },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.emailNote = Thrift.Method.define({
  alias: 'emailNote',
  args: Thrift.Struct.define('emailNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'parameters', type: Thrift.Type.STRUCT, def: module.exports.NoteEmailParameters, index: 1 }
  }),
  result: Thrift.Struct.define('emailNoteResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.shareNote = Thrift.Method.define({
  alias: 'shareNote',
  args: Thrift.Struct.define('shareNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('shareNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRING },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.stopSharingNote = Thrift.Method.define({
  alias: 'stopSharingNote',
  args: Thrift.Struct.define('stopSharingNoteArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'guid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('stopSharingNoteResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.authenticateToSharedNote = Thrift.Method.define({
  alias: 'authenticateToSharedNote',
  args: Thrift.Struct.define('authenticateToSharedNoteArgs', {
    1: { alias: 'guid', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'noteKey', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('authenticateToSharedNoteResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: UserStore.AuthenticationResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.findRelated = Thrift.Method.define({
  alias: 'findRelated',
  args: Thrift.Struct.define('findRelatedArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'query', type: Thrift.Type.STRUCT, def: module.exports.RelatedQuery, index: 1 },
    3: { alias: 'resultSpec', type: Thrift.Type.STRUCT, def: module.exports.RelatedResultSpec, index: 2 }
  }),
  result: Thrift.Struct.define('findRelatedResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.RelatedResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

NoteStore.updateNoteIfUsnMatches = Thrift.Method.define({
  alias: 'updateNoteIfUsnMatches',
  args: Thrift.Struct.define('updateNoteIfUsnMatchesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'note', type: Thrift.Type.STRUCT, def: Types.Note, index: 1 }
  }),
  result: Thrift.Struct.define('updateNoteIfUsnMatchesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.UpdateNoteIfUsnMatchesResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.manageNotebookShares = Thrift.Method.define({
  alias: 'manageNotebookShares',
  args: Thrift.Struct.define('manageNotebookSharesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'parameters', type: Thrift.Type.STRUCT, def: module.exports.ManageNotebookSharesParameters, index: 1 }
  }),
  result: Thrift.Struct.define('manageNotebookSharesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.ManageNotebookSharesResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

NoteStore.getNotebookShares = Thrift.Method.define({
  alias: 'getNotebookShares',
  args: Thrift.Struct.define('getNotebookSharesArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'notebookGuid', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('getNotebookSharesResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.ShareRelationships },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    3: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

// Define NoteStore Client

function NoteStoreClient(output) {
  this.output = output;
  this.seqid = 0;
}

NoteStoreClient.prototype.getSyncState = function (authenticationToken, callback) {
  var mdef = NoteStore.getSyncState;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getFilteredSyncChunk = function (authenticationToken, afterUSN, maxEntries, filter, callback) {
  var mdef = NoteStore.getFilteredSyncChunk;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.afterUSN = afterUSN;
  args.maxEntries = maxEntries;
  args.filter = filter;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getLinkedNotebookSyncState = function (authenticationToken, linkedNotebook, callback) {
  var mdef = NoteStore.getLinkedNotebookSyncState;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.linkedNotebook = linkedNotebook;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getLinkedNotebookSyncChunk = function (authenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly, callback) {
  var mdef = NoteStore.getLinkedNotebookSyncChunk;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.linkedNotebook = linkedNotebook;
  args.afterUSN = afterUSN;
  args.maxEntries = maxEntries;
  args.fullSyncOnly = fullSyncOnly;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listNotebooks = function (authenticationToken, callback) {
  var mdef = NoteStore.listNotebooks;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listAccessibleBusinessNotebooks = function (authenticationToken, callback) {
  var mdef = NoteStore.listAccessibleBusinessNotebooks;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNotebook = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getDefaultNotebook = function (authenticationToken, callback) {
  var mdef = NoteStore.getDefaultNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.createNotebook = function (authenticationToken, notebook, callback) {
  var mdef = NoteStore.createNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.notebook = notebook;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateNotebook = function (authenticationToken, notebook, callback) {
  var mdef = NoteStore.updateNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.notebook = notebook;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.expungeNotebook = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.expungeNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listTags = function (authenticationToken, callback) {
  var mdef = NoteStore.listTags;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listTagsByNotebook = function (authenticationToken, notebookGuid, callback) {
  var mdef = NoteStore.listTagsByNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.notebookGuid = notebookGuid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getTag = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getTag;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.createTag = function (authenticationToken, tag, callback) {
  var mdef = NoteStore.createTag;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.tag = tag;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateTag = function (authenticationToken, tag, callback) {
  var mdef = NoteStore.updateTag;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.tag = tag;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.untagAll = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.untagAll;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.expungeTag = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.expungeTag;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listSearches = function (authenticationToken, callback) {
  var mdef = NoteStore.listSearches;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getSearch = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getSearch;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.createSearch = function (authenticationToken, search, callback) {
  var mdef = NoteStore.createSearch;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.search = search;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateSearch = function (authenticationToken, search, callback) {
  var mdef = NoteStore.updateSearch;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.search = search;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.expungeSearch = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.expungeSearch;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.findNoteOffset = function (authenticationToken, filter, guid, callback) {
  var mdef = NoteStore.findNoteOffset;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.filter = filter;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.findNotesMetadata = function (authenticationToken, filter, offset, maxNotes, resultSpec, callback) {
  var mdef = NoteStore.findNotesMetadata;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.filter = filter;
  args.offset = offset;
  args.maxNotes = maxNotes;
  args.resultSpec = resultSpec;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.findNoteCounts = function (authenticationToken, filter, withTrash, callback) {
  var mdef = NoteStore.findNoteCounts;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.filter = filter;
  args.withTrash = withTrash;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteWithResultSpec = function (authenticationToken, guid, resultSpec, callback) {
  var mdef = NoteStore.getNoteWithResultSpec;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.resultSpec = resultSpec;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNote = function (authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData, callback) {
  var mdef = NoteStore.getNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.withContent = withContent;
  args.withResourcesData = withResourcesData;
  args.withResourcesRecognition = withResourcesRecognition;
  args.withResourcesAlternateData = withResourcesAlternateData;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteApplicationData = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getNoteApplicationData;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteApplicationDataEntry = function (authenticationToken, guid, key, callback) {
  var mdef = NoteStore.getNoteApplicationDataEntry;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.key = key;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.setNoteApplicationDataEntry = function (authenticationToken, guid, key, value, callback) {
  var mdef = NoteStore.setNoteApplicationDataEntry;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.key = key;
  args.value = value;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.unsetNoteApplicationDataEntry = function (authenticationToken, guid, key, callback) {
  var mdef = NoteStore.unsetNoteApplicationDataEntry;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.key = key;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteContent = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getNoteContent;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteSearchText = function (authenticationToken, guid, noteOnly, tokenizeForIndexing, callback) {
  var mdef = NoteStore.getNoteSearchText;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.noteOnly = noteOnly;
  args.tokenizeForIndexing = tokenizeForIndexing;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceSearchText = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getResourceSearchText;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteTagNames = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getNoteTagNames;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.createNote = function (authenticationToken, note, callback) {
  var mdef = NoteStore.createNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.note = note;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateNote = function (authenticationToken, note, callback) {
  var mdef = NoteStore.updateNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.note = note;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.deleteNote = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.deleteNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.expungeNote = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.expungeNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.copyNote = function (authenticationToken, noteGuid, toNotebookGuid, callback) {
  var mdef = NoteStore.copyNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.noteGuid = noteGuid;
  args.toNotebookGuid = toNotebookGuid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listNoteVersions = function (authenticationToken, noteGuid, callback) {
  var mdef = NoteStore.listNoteVersions;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.noteGuid = noteGuid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNoteVersion = function (authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData, callback) {
  var mdef = NoteStore.getNoteVersion;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.noteGuid = noteGuid;
  args.updateSequenceNum = updateSequenceNum;
  args.withResourcesData = withResourcesData;
  args.withResourcesRecognition = withResourcesRecognition;
  args.withResourcesAlternateData = withResourcesAlternateData;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResource = function (authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData, callback) {
  var mdef = NoteStore.getResource;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.withData = withData;
  args.withRecognition = withRecognition;
  args.withAttributes = withAttributes;
  args.withAlternateData = withAlternateData;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceApplicationData = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getResourceApplicationData;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceApplicationDataEntry = function (authenticationToken, guid, key, callback) {
  var mdef = NoteStore.getResourceApplicationDataEntry;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.key = key;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.setResourceApplicationDataEntry = function (authenticationToken, guid, key, value, callback) {
  var mdef = NoteStore.setResourceApplicationDataEntry;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.key = key;
  args.value = value;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.unsetResourceApplicationDataEntry = function (authenticationToken, guid, key, callback) {
  var mdef = NoteStore.unsetResourceApplicationDataEntry;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  args.key = key;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateResource = function (authenticationToken, resource, callback) {
  var mdef = NoteStore.updateResource;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.resource = resource;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceData = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getResourceData;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceByHash = function (authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData, callback) {
  var mdef = NoteStore.getResourceByHash;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.noteGuid = noteGuid;
  args.contentHash = contentHash;
  args.withData = withData;
  args.withRecognition = withRecognition;
  args.withAlternateData = withAlternateData;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceRecognition = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getResourceRecognition;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceAlternateData = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getResourceAlternateData;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getResourceAttributes = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.getResourceAttributes;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getPublicNotebook = function (userId, publicUri, callback) {
  var mdef = NoteStore.getPublicNotebook;
  var args = new mdef.args();
  args.userId = userId;
  args.publicUri = publicUri;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.shareNotebook = function (authenticationToken, sharedNotebook, message, callback) {
  var mdef = NoteStore.shareNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.sharedNotebook = sharedNotebook;
  args.message = message;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.createOrUpdateNotebookShares = function (authenticationToken, shareTemplate, callback) {
  var mdef = NoteStore.createOrUpdateNotebookShares;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.shareTemplate = shareTemplate;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateSharedNotebook = function (authenticationToken, sharedNotebook, callback) {
  var mdef = NoteStore.updateSharedNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.sharedNotebook = sharedNotebook;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.setNotebookRecipientSettings = function (authenticationToken, notebookGuid, recipientSettings, callback) {
  var mdef = NoteStore.setNotebookRecipientSettings;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.notebookGuid = notebookGuid;
  args.recipientSettings = recipientSettings;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listSharedNotebooks = function (authenticationToken, callback) {
  var mdef = NoteStore.listSharedNotebooks;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.createLinkedNotebook = function (authenticationToken, linkedNotebook, callback) {
  var mdef = NoteStore.createLinkedNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.linkedNotebook = linkedNotebook;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateLinkedNotebook = function (authenticationToken, linkedNotebook, callback) {
  var mdef = NoteStore.updateLinkedNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.linkedNotebook = linkedNotebook;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.listLinkedNotebooks = function (authenticationToken, callback) {
  var mdef = NoteStore.listLinkedNotebooks;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.expungeLinkedNotebook = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.expungeLinkedNotebook;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.authenticateToSharedNotebook = function (shareKeyOrGlobalId, authenticationToken, callback) {
  var mdef = NoteStore.authenticateToSharedNotebook;
  var args = new mdef.args();
  args.shareKeyOrGlobalId = shareKeyOrGlobalId;
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getSharedNotebookByAuth = function (authenticationToken, callback) {
  var mdef = NoteStore.getSharedNotebookByAuth;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.emailNote = function (authenticationToken, parameters, callback) {
  var mdef = NoteStore.emailNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.parameters = parameters;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.shareNote = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.shareNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.stopSharingNote = function (authenticationToken, guid, callback) {
  var mdef = NoteStore.stopSharingNote;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.guid = guid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.authenticateToSharedNote = function (guid, noteKey, authenticationToken, callback) {
  var mdef = NoteStore.authenticateToSharedNote;
  var args = new mdef.args();
  args.guid = guid;
  args.noteKey = noteKey;
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.findRelated = function (authenticationToken, query, resultSpec, callback) {
  var mdef = NoteStore.findRelated;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.query = query;
  args.resultSpec = resultSpec;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.updateNoteIfUsnMatches = function (authenticationToken, note, callback) {
  var mdef = NoteStore.updateNoteIfUsnMatches;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.note = note;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.manageNotebookShares = function (authenticationToken, parameters, callback) {
  var mdef = NoteStore.manageNotebookShares;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.parameters = parameters;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

NoteStoreClient.prototype.getNotebookShares = function (authenticationToken, notebookGuid, callback) {
  var mdef = NoteStore.getNotebookShares;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.notebookGuid = notebookGuid;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

module.exports.NoteStore.Client = NoteStoreClient;

// Define NoteStore Server

function NoteStoreServer(service, stransport, Protocol) {
  var methodName;
  this.service = service;
  this.stransport = stransport;
  this.processor = new Thrift.Processor();
  for (methodName in NoteStore) {
    if (service[methodName]) {
      this.processor.addMethod(NoteStore[methodName], service[methodName].bind(service));
    }
  }
  this.stransport.process = function (input, output, noop) {
    var inprot = new Protocol(input);
    var outprot = new Protocol(output);
    this.processor.process(inprot, outprot, noop);
  }.bind(this);
}

NoteStoreServer.prototype.start = function () {
  this.stransport.listen();
};
NoteStoreServer.prototype.stop = function () {
  this.stransport.close();
};

module.exports.NoteStore.Server = NoteStoreServer;