
/*******************************************************
 * Copyright (C) 2018 XMind Ltd. - All Rights Reserved
 *******************************************************/

#include <nan.h>

/*
 * Make the file activated, so that it can be handoff to iOS.
 * arguments:
 *   activateFile: String
 *   userActivityType: String
 */
NAN_METHOD(HoActivateFile);

/*
 * When the file is closed, call this method to deactivate the file to free resource.
 * arguments:
 *   path: String
 */
NAN_METHOD(HoDeactivateFile);

/*
 * Ensure the icloud folder is created. Not 100% work.
 * arguments:
 *   appIdentifier: String
 */
NAN_METHOD(HoEnsureUbiquityContainer);

/*
 * Call this method to try downloading an iCloud file.
 * arguments:
 *   path: String
 * returns:
 *   true if the file starts to download.
 *   false if the file doesn't need to download.
 */
NAN_METHOD(HoDownloadICloudFile);

NAN_METHOD(HoGetUbiquitousItemDownloadingStatus);
