/*******************************************************
 * Copyright (C) 2018 XMind Ltd. - All Rights Reserved
 *******************************************************/
let exportObj

if ( process.platform === 'darwin' ) {
  let OSXApi = require( 'bindings' )( 'handoff.node' )

  exportObj = {
    // Make a file available for handoff. The file should be located in iCloud storage.
    // argument:
    //   filePath: String.
    //   activityType: String. App specific id string to indicate what the activity is.
    activateFile(filePath, activityType) {
      var result = OSXApi.hoActivateFile(filePath, activityType)
      if (typeof result === 'string') {
        throw new Error(result)
      }
    },

    // Stop a file from handoff.
    // argument:
    //   filePath: String
    deactivateFile(filePath) {
      var result = OSXApi.hoDeactivateFile(filePath)
      if (typeof result === 'string') {
        // An error occurred.
        throw new Error(result)
      }
    },

    // Try to make sure there's a app specific folder in iCloud drive.
    // argument:
    //   bundleId: String. The id of the app.
    ensureUbiquityContainer(bookmarkData) {
      let result = OSXApi.hoEnsureUbiquityContainer(bookmarkData)
      if (result === false) {
        throw new Error('OperationFailed')
      }
    },

    // returns:
    //   true if the file starts to download.
    //   false if the file doesn't need to download.
    downloadICloudFile(filePath) {
      return OSXApi.hoDownloadICloudFile(filePath)
    },

    // Get the status of an iCloud Document
    // returns:
    //  "NSURLUbiquitousItemDownloadingStatusCurrent"
    //  "NSURLUbiquitousItemDownloadingStatusDownloaded"
    //  "NSURLUbiquitousItemDownloadingStatusNotDownloaded"
    getUbiquitousItemDownloadingStatus(filePath) {
      return OSXApi.hoGetUbiquitousItemDownloadingStatus(filePath)
    }
  }

} else {
  // In non-osx system. All apis are not available
  exportObj = new Proxy( {}, {
    get() { throw new Error( 'NotAvailable' ) }
  } )
}

module.exports = exportObj
