
/*******************************************************
 * Copyright (C) 2018 XMind Ltd. - All Rights Reserved
 *******************************************************/

#include <nan.h>

/*
 * Create a boomark data for file resource.
 * arguments:
 *   filePath: String
 * return:
 *   bookmarkData: String
 */
NAN_METHOD(SbCreateBookmarkDataForSecurityScopedResource);

/*
 * Convert bookmarkData to filePath
 * arguments:
 *   bookmarkData: String
 * return:
 *   filePath: String
 */
NAN_METHOD(SbResolveBookmarkDataForSecurityScopedResource);

/*
 * Call these method before open and after close for a sandboxed file.
 * arguments:
 *   bookmarkData: String
 * return:
 *   success: Bool
 */
NAN_METHOD(SbStartAccessingSecurityScopedResource);
NAN_METHOD(SbStopAccessingSecurityScopedResource);
