/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKFileChooserUI;
import com.sun.java.swing.plaf.gtk.GTKParser;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import sun.security.action.GetPropertyAction;

public class GTKLookAndFeel
extends SynthLookAndFeel {
    private static final boolean IS_22;
    private Font fallbackFont;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !GTKLookAndFeel.class.desiredAssertionStatus();
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("swing.gtk.version"));
        IS_22 = string != null ? string.equals("2.2") : true;
    }

    public void initialize() {
        this.loadStylesFromThemeFiles();
    }

    private void loadStylesFromThemeFiles() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                GTKParser gTKParser = new GTKParser();
                String string = System.getProperty("swing.gtkthemefile");
                if (string == null || !GTKLookAndFeel.this.parseThemeFile(string, gTKParser)) {
                    String string2;
                    String string3 = System.getProperty("user.home");
                    if (string3 != null) {
                        GTKLookAndFeel.this.parseThemeFile(string3 + "/.gtkrc-2.0", gTKParser);
                    }
                    if ((string2 = (String)Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Net/ThemeName")) == null) {
                        string2 = "Default";
                    }
                    if (!GTKLookAndFeel.this.parseThemeFile(string3 + "/.themes/" + string2 + "/gtk-2.0/gtkrc", gTKParser)) {
                        String string4 = System.getProperty("swing.gtkthemedir");
                        if (string4 == null) {
                            String[] stringArray = new String[]{"/usr/share/themes", "/opt/gnome2/share/themes"};
                            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                                if (!new File(stringArray[i2] + "/" + string2 + "/gtk-2.0/gtkrc").canRead()) continue;
                                string4 = stringArray[i2];
                                break;
                            }
                        }
                        if (string4 != null) {
                            GTKLookAndFeel.this.parseThemeFile(string4 + "/" + string2 + "/gtk-2.0/gtkrc", gTKParser);
                        }
                    }
                }
                SynthLookAndFeel.setStyleFactory(GTKLookAndFeel.this.handleParsedData(gTKParser));
                gTKParser.clearParser();
                return null;
            }
        });
    }

    static boolean is2_2() {
        return IS_22;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    static int SwingOrientationConstantToGTK(int n2) {
        switch (n2) {
            case 2: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknowning orientation: " + n2));
        }
        return n2;
    }

    static boolean isText(Region region) {
        return region == Region.TEXT_FIELD || region == Region.FORMATTED_TEXT_FIELD || region == Region.LIST || region == Region.PASSWORD_FIELD || region == Region.SPINNER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE || region == Region.TREE;
    }

    static int synthStateToGTKState(Region region, int n2) {
        int n3 = n2;
        n2 = (n2 & 4) != 0 ? (region == Region.RADIO_BUTTON || region == Region.CHECK_BOX || region == Region.TOGGLE_BUTTON || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.SPLIT_PANE ? 2 : 4) : ((n2 & 0x200) != 0 ? (region == Region.MENU ? 2 : (region == Region.RADIO_BUTTON || region == Region.TOGGLE_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.CHECK_BOX || region == Region.BUTTON ? ((n2 & 2) != 0 ? 2 : 4) : (region == Region.TABBED_PANE_TAB ? 1 : 512))) : ((n2 & 2) != 0 ? 2 : ((n2 & 8) != 0 ? 8 : (region == Region.SLIDER_TRACK ? 4 : (region == Region.TABBED_PANE_TAB ? 4 : 1)))));
        return n2;
    }

    public String getDescription() {
        return "GTK look and feel";
    }

    public String getID() {
        return "GTK";
    }

    public String getName() {
        return "GTK look and feel";
    }

    private boolean configIconSizes(String string) {
        String[] stringArray = string.split(":");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split("=");
            if (stringArray2.length != 2) {
                return false;
            }
            String string2 = stringArray2[0].trim().intern();
            if (string2.length() < 1) {
                return false;
            }
            if ((stringArray2 = stringArray2[1].split(",")).length != 2) {
                return false;
            }
            String string3 = stringArray2[0].trim();
            String string4 = stringArray2[1].trim();
            if (string3.length() < 1 || string4.length() < 1) {
                return false;
            }
            int n2 = 0;
            int n3 = 0;
            try {
                n2 = Integer.parseInt(string3);
                n3 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n2 > 0 && n3 > 0) {
                if (GTKStyle.getIconSize(string2) == null) continue;
                GTKStyle.setIconSize(string2, n2, n3);
                continue;
            }
            System.err.println("Invalid size in gtk-icon-sizes: " + n2 + "," + n3);
        }
        return true;
    }

    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = super.getDefaults();
        uIDefaults.put("FileChooserUI", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        uIDefaults.addResourceBundle("com.sun.java.swing.plaf.gtk.resources.gtk");
        GTKStyle.GTKLazyValue gTKLazyValue = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder");
        uIDefaults.put("List.focusCellHighlightBorder", gTKLazyValue);
        uIDefaults.put("Table.focusCellHighlightBorder", gTKLazyValue);
        uIDefaults.put("Table.gridColor", new ColorUIResource(Color.gray));
        uIDefaults.put("Table.selectionForeground", new ColorUIResource(Color.BLACK));
        uIDefaults.put("Table.selectionBackground", new ColorUIResource(128));
        uIDefaults.put("control", new ColorUIResource(0xC0C0C0));
        if (this.fallbackFont != null) {
            uIDefaults.put("TitledBorder.font", this.fallbackFont);
        }
        uIDefaults.put("TitledBorder.titleColor", new ColorUIResource(Color.BLACK));
        uIDefaults.put("TitledBorder.border", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource"));
        return uIDefaults;
    }

    private boolean parseThemeFile(String string, GTKParser gTKParser) {
        File file = new File(string);
        if (file.canRead()) {
            try {
                gTKParser.parseFile(file, string);
            }
            catch (IOException iOException) {
                System.err.println("error: (" + iOException.toString() + ") while parsing file: \"" + string + "\"");
            }
            return true;
        }
        return false;
    }

    private GTKStyleFactory handleParsedData(GTKParser gTKParser) {
        Object object;
        HashMap hashMap = gTKParser.getGTKSettings();
        Object object2 = hashMap.get("gtk-icon-sizes");
        if (object2 instanceof String && !this.configIconSizes((String)object2)) {
            System.err.println("Error parsing gtk-icon-sizes string: '" + object2 + "'");
        }
        if (!((object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName")) instanceof String) && !((object = hashMap.get("gtk-font-name")) instanceof String)) {
            object = "sans 10";
        }
        Font font = PangoFonts.lookupFont((String)object);
        GTKStyle gTKStyle = new GTKStyle(font);
        GTKStyleFactory gTKStyleFactory = new GTKStyleFactory(gTKStyle);
        gTKParser.loadStylesInto(gTKStyleFactory);
        this.fallbackFont = font;
        return gTKStyleFactory;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        String string = jComponent.getUIClassID().intern();
        if (string == "FileChooserUI") {
            return GTKFileChooserUI.createUI(jComponent);
        }
        return SynthLookAndFeel.createUI(jComponent);
    }
}

