/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.SimpleOutputDeviceProvider;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;

class SimpleOutputDevice
extends AbstractMixer {
    private AudioFormat format = null;
    private int bufferSize = -1;
    private Port[] ports;
    static /* synthetic */ Class class$javax$sound$sampled$Port;

    private native int nGetNumPorts();

    public void implClose() {
        this.nClose();
    }

    protected void implOpen() throws LineUnavailableException {
        int n2;
        int n3 = n2 = this.bufferSize == -1 ? -1 : this.bufferSize / this.format.getFrameSize();
        if (n2 <= 0) {
            n2 = (int)(this.format.getFrameRate() / 2.0f);
        }
        this.nOpen(((SimpleOutputDeviceProvider.OutputDeviceInfo)this.getMixerInfo()).getIndex(), (int)this.format.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), n2);
        this.bufferSize = n2 == -1 ? -1 : n2 * this.format.getFrameSize();
    }

    protected void implStart() {
        this.nStart();
    }

    protected void implStop() {
        this.nStart();
    }

    private native void nClose();

    private native void nStart();

    private native void nStop();

    private native boolean nSupportsSampleRate(float var1);

    private native boolean nSupportsChannels(int var1);

    private native boolean nSupportsSampleSizeInBits(int var1);

    private native void nOpen(int var1, float var2, int var3, int var4, int var5) throws LineUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleOutputDevice(SimpleOutputDeviceProvider.OutputDeviceInfo outputDeviceInfo) {
        super(outputDeviceInfo, null, null, null);
        AudioFormat[] audioFormatArray;
        Platform.initialize();
        boolean bl2 = this.nSupportsSampleSizeInBits(8);
        boolean bl3 = this.nSupportsSampleSizeInBits(16);
        boolean bl4 = this.nSupportsChannels(1);
        boolean bl5 = this.nSupportsChannels(2);
        boolean bl6 = this.nSupportsSampleRate(8000.0f);
        boolean bl7 = this.nSupportsSampleRate(11025.0f);
        boolean bl8 = this.nSupportsSampleRate(16000.0f);
        boolean bl9 = this.nSupportsSampleRate(22050.0f);
        boolean bl10 = this.nSupportsSampleRate(32000.0f);
        boolean bl11 = this.nSupportsSampleRate(44100.0f);
        Vector vector = new Vector();
        if (bl2 && bl4 && bl6) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 8, 1, 1, 8000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 8, 1, 1, 8000.0f, false));
        }
        if (bl2 && bl5 && bl6) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 8, 2, 2, 8000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 8, 2, 2, 8000.0f, false));
        }
        if (bl3 && bl4 && bl6) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, true));
        }
        if (bl3 && bl5 && bl6) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 2, 4, 8000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 2, 4, 8000.0f, true));
        }
        if (bl2 && bl4 && bl7) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 8, 1, 1, 11025.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 11025.0f, 8, 1, 1, 11025.0f, false));
        }
        if (bl2 && bl5 && bl7) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 8, 2, 2, 11025.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 11025.0f, 8, 2, 2, 11025.0f, false));
        }
        if (bl3 && bl4 && bl7) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 1, 2, 11025.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 1, 2, 11025.0f, true));
        }
        if (bl3 && bl5 && bl7) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 2, 4, 11025.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 2, 4, 11025.0f, true));
        }
        if (bl2 && bl4 && bl8) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 8, 1, 1, 16000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 16000.0f, 8, 1, 1, 16000.0f, false));
        }
        if (bl2 && bl5 && bl8) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 8, 2, 2, 16000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 16000.0f, 8, 2, 2, 16000.0f, false));
        }
        if (bl3 && bl4 && bl8) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, true));
        }
        if (bl3 && bl5 && bl8) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 2, 4, 16000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 2, 4, 16000.0f, true));
        }
        if (bl2 && bl4 && bl9) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 1, 1, 22050.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 22050.0f, 8, 1, 1, 22050.0f, false));
        }
        if (bl2 && bl5 && bl9) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 2, 2, 22050.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 22050.0f, 8, 2, 2, 22050.0f, false));
        }
        if (bl3 && bl4 && bl9) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, true));
        }
        if (bl3 && bl5 && bl9) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 2, 4, 22050.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 2, 4, 22050.0f, true));
        }
        if (bl2 && bl4 && bl10) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 8, 1, 1, 32000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 32000.0f, 8, 1, 1, 32000.0f, false));
        }
        if (bl2 && bl5 && bl10) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 8, 2, 2, 32000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 32000.0f, 8, 2, 2, 32000.0f, false));
        }
        if (bl3 && bl4 && bl10) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 1, 2, 32000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 1, 2, 32000.0f, true));
        }
        if (bl3 && bl5 && bl10) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 2, 4, 32000.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 2, 4, 32000.0f, true));
        }
        if (bl2 && bl4 && bl11) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 1, 1, 44100.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 1, 1, 44100.0f, false));
        }
        if (bl2 && bl5 && bl11) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 2, 2, 44100.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 2, 2, 44100.0f, false));
        }
        if (bl3 && bl4 && bl11) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, true));
        }
        if (bl3 && bl5 && bl11) {
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false));
            vector.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, true));
        }
        Vector vector2 = vector;
        synchronized (vector2) {
            audioFormatArray = new AudioFormat[vector.size()];
            for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
                audioFormatArray[i2] = (AudioFormat)vector.elementAt(i2);
            }
        }
        int n2 = this.nGetNumPorts();
        this.targetLineInfo = new Port.Info[n2];
        this.ports = new Port[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            String string = this.nGetPortName(i3);
            this.targetLineInfo[i3] = this.getPortInfo(string);
            this.ports[i3] = new OutputDevicePort((Port.Info)this.targetLineInfo[i3], this, new Control[0]);
        }
        this.sourceLineInfo = new DataLine.Info[1];
        this.sourceLineInfo[0] = new DataLine.Info(SourceDataLine.class, audioFormatArray, 0, -1);
        this.format = vector.size() > 0 ? (AudioFormat)vector.lastElement() : null;
    }

    private native String nGetPortName(int var1);

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return this.ports.length;
        }
        if (info2 instanceof DataLine.Info) {
            return 1;
        }
        return 0;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        DataLine.Info info2;
        Line.Info info3 = this.getLineInfo(info);
        if (info3 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info3 instanceof Port.Info) {
            for (int i2 = 0; i2 < this.ports.length; ++i2) {
                if (!info3.equals(this.ports[i2].getLineInfo())) continue;
                return this.ports[i2];
            }
        }
        if (info3 instanceof DataLine.Info && (info2 = (DataLine.Info)info).getLineClass().isAssignableFrom(OutputDeviceDataLine.class)) {
            AudioFormat[] audioFormatArray = info2.getFormats();
            AudioFormat audioFormat = audioFormatArray[audioFormatArray.length - 1];
            return new OutputDeviceDataLine(info2, this, audioFormat, info2.getMaxBufferSize());
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    private Port.Info getPortInfo(String string) {
        if (string.equals(Port.Info.SPEAKER.toString())) {
            return Port.Info.SPEAKER;
        }
        if (string.equals(Port.Info.HEADPHONE.toString())) {
            return Port.Info.HEADPHONE;
        }
        if (string.equals(Port.Info.LINE_OUT.toString())) {
            return Port.Info.LINE_OUT;
        }
        return new OutputDevicePortInfo(string);
    }

    private class OutputDeviceDataLine
    extends AbstractDataLine
    implements SourceDataLine {
        private CircularBuffer circularBuffer;

        public int available() {
            return 0;
        }

        void implClose() {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        void implStart() {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        void implStop() {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        public int write(byte[] byArray, int n2, int n3) {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        private CircularBuffer getCircularBuffer() {
            return this.circularBuffer;
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        private OutputDeviceDataLine(DataLine.Info info, SimpleOutputDevice simpleOutputDevice2, AudioFormat audioFormat, int n2) {
            super(info, simpleOutputDevice2, null, audioFormat, n2);
            this.circularBuffer = null;
        }
    }

    private class OutputDevicePort
    extends AbstractLine
    implements Port {
        public void close() {
        }

        public void open() throws LineUnavailableException {
        }

        private OutputDevicePort(Port.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
            super(info, abstractMixer, controlArray);
        }
    }

    private static class OutputDevicePortInfo
    extends Port.Info {
        private OutputDevicePortInfo(String string) {
            super(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = SimpleOutputDevice.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port, string, false);
        }
    }
}

