/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import sun.awt.DebugHelper;

public class Container
extends Component {
    int ncomponents;
    Component[] component = new Component[0];
    LayoutManager layoutMgr;
    private LightweightDispatcher dispatcher;
    private Dimension maxSize;
    private transient FocusTraversalPolicy focusTraversalPolicy;
    private boolean focusCycleRoot = false;
    private transient Set printingThreads;
    private transient boolean printing = false;
    transient ContainerListener containerListener;
    transient int listeningChildren;
    transient int listeningBoundsChildren;
    transient int descendantsCount;
    private static final long serialVersionUID = 4613797578919906343L;
    private static final DebugHelper dbg = DebugHelper.create(Container.class);
    static final boolean INCLUDE_SELF = true;
    static final boolean SEARCH_HEAVYWEIGHTS = true;
    private int containerSerializedDataVersion = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignmentX() {
        float f2;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f2 = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f2 = super.getAlignmentX();
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignmentY() {
        float f2;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f2 = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f2 = super.getAlignmentY();
        }
        return f2;
    }

    public int countComponents() {
        return this.ncomponents;
    }

    int countHierarchyMembers() {
        return this.descendantsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessibleChildrenCount() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            Component[] componentArray = this.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!(componentArray[i2] instanceof Accessible)) continue;
                ++n2;
            }
            return n2;
        }
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Container.initIDs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (!(this.peer instanceof LightweightPeer)) {
                this.dispatcher = new LightweightDispatcher(this);
            }
            int n2 = this.ncomponents;
            Component[] componentArray = this.component;
            for (int i2 = 0; i2 < n2; ++i2) {
                componentArray[i2].addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCurrentFocusCycleRootOnHide() {
        Container container;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object = this.getTreeLock();
        synchronized (object) {
            for (container = keyboardFocusManager.getCurrentFocusCycleRoot(); this != container && !(container instanceof Window) && container != null; container = container.getParent()) {
            }
        }
        if (container == this) {
            keyboardFocusManager.setGlobalCurrentFocusCycleRoot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMostRecentFocusOwnerOnHide() {
        Container container;
        Component component = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null) {
                for (component = KeyboardFocusManager.getMostRecentFocusOwner((Window)container); component != null && component != this && !(component instanceof Window); component = component.getParent()) {
                }
            }
        }
        if (component == this) {
            KeyboardFocusManager.setMostRecentFocusOwner((Window)container, null);
        }
        if (container != null) {
            object = (Window)container;
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                Class clazz = KeyboardFocusManager.class;
                synchronized (clazz) {
                    Component component2 = ((Window)object).getTemporaryLostComponent();
                    if (this.isParentOf(component2) || component2 == this) {
                        ((Window)object).setTemporaryLostComponent(null);
                    }
                }
            }
        }
    }

    public void doLayout() {
        this.layout();
    }

    private static native void initIDs();

    void initializeFocusTraversalKeys() {
        this.focusTraversalKeys = new Set[4];
    }

    public void invalidate() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            layoutManager2.invalidateLayout(this);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < this.ncomponents; ++i2) {
                Component component = this.component[i2];
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                    continue;
                }
                if (!component.valid) continue;
                component.invalidate();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.adjustListeningChildren(32768L, -this.listeningChildren);
            this.adjustListeningChildren(65536L, -this.listeningBoundsChildren);
            this.adjustDescendants(-this.descendantsCount);
            while (this.ncomponents > 0) {
                Component component = this.component[--this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.dispatchEvent(containerEvent);
                }
                component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            }
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.ncomponents;
            Component[] componentArray = this.component;
            for (int i2 = 0; i2 < n2; ++i2) {
                componentArray[i2].removeNotify();
            }
            if (this.dispatcher != null) {
                this.dispatcher.dispose();
                this.dispatcher = null;
            }
            super.removeNotify();
        }
    }

    public void transferFocusBackward() {
        if (this.isFocusCycleRoot()) {
            Container container = this.findTraversalRoot();
            Container container2 = this;
            while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
                container2 = container;
                container = container2.getFocusCycleRootAncestor();
            }
            if (container != null) {
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentBefore(container, container2);
                if (component == null) {
                    component = focusTraversalPolicy.getDefaultComponent(container);
                }
                if (component != null) {
                    component.requestFocus();
                }
            }
        } else {
            super.transferFocusBackward();
        }
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(this);
            Component component = this.getFocusTraversalPolicy().getDefaultComponent(this);
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            boolean bl2 = false;
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.valid && this.peer != null) {
                    ContainerPeer containerPeer = null;
                    if (this.peer instanceof ContainerPeer) {
                        containerPeer = (ContainerPeer)this.peer;
                    }
                    if (containerPeer != null) {
                        containerPeer.beginValidate();
                    }
                    this.validateTree();
                    this.valid = true;
                    if (containerPeer != null) {
                        containerPeer.endValidate();
                        bl2 = this.isVisible();
                    }
                }
            }
            if (bl2) {
                this.updateCursorImmediately();
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).beginLayout();
            }
            this.doLayout();
            Component[] componentArray = this.component;
            for (int i2 = 0; i2 < this.ncomponents; ++i2) {
                Component component = componentArray[i2];
                if (component instanceof Container && !(component instanceof Window) && !component.valid) {
                    ((Container)component).validateTree();
                    continue;
                }
                component.validate();
            }
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).endLayout();
            }
        }
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean containsFocus() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            for (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component != null && !(component instanceof Window) && component != this; component = component.getParent()) {
            }
            return component == this;
        }
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy != null;
    }

    boolean nextFocusHelper() {
        if (this.isFocusCycleRoot()) {
            Container container;
            Container container2 = this.findTraversalRoot();
            Container container3 = this;
            while (!(container2 == null || (container = container2.getFocusCycleRootAncestor()) == null || container2.isShowing() && container2.isFocusable() && container2.isEnabled())) {
                container3 = container2;
                container2 = container;
            }
            if (container2 != null) {
                FocusTraversalPolicy focusTraversalPolicy = container2.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(container2, container3);
                if (component == null) {
                    component = focusTraversalPolicy.getDefaultComponent(container2);
                }
                if (component != null) {
                    return component.requestFocus(false);
                }
            }
            return false;
        }
        return super.nextFocusHelper();
    }

    boolean postsOldMouseEvents() {
        return true;
    }

    void adjustDecendantsOnParent(int n2) {
        if (this.parent != null) {
            this.parent.adjustDescendants(n2);
        }
    }

    void adjustDescendants(int n2) {
        if (n2 == 0) {
            return;
        }
        this.descendantsCount += n2;
        this.adjustDecendantsOnParent(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n2 < 0 || n2 >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            Component component = this.component[n2];
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            this.adjustDescendants(-component.countHierarchyMembers());
            component.parent = null;
            System.arraycopy(this.component, n2 + 1, this.component, n2, this.ncomponents - n2 - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    public boolean areFocusTraversalKeysSet(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n2] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createChildHierarchyEvents(int n2, long l2, boolean bl2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3 = 0;
            switch (n2) {
                case 1400: {
                    n3 = this.listeningChildren;
                    break;
                }
                case 1401: 
                case 1402: {
                    n3 = this.listeningBoundsChildren;
                    break;
                }
            }
            if (bl2) {
                n3 = this.descendantsCount;
            }
            int n4 = n3;
            int n5 = 0;
            while (n4 > 0) {
                n4 -= this.component[n5].createHierarchyEvents(n2, this, this.parent, l2, bl2);
                ++n5;
            }
        }
    }

    int numListening(long l2) {
        int n2 = super.numListening(l2);
        if (l2 == 32768L) {
            return this.listeningChildren + n2;
        }
        if (l2 == 65536L) {
            return this.listeningBoundsChildren + n2;
        }
        return n2;
    }

    void proxyEnableEvents(long l2) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                this.parent.proxyEnableEvents(l2);
            }
        } else if (this.dispatcher != null) {
            this.dispatcher.enableEvents(l2);
        }
    }

    void adjustListeningChildren(long l2, int n2) {
        if (n2 == 0) {
            return;
        }
        if ((l2 & 0x8000L) != 0L) {
            this.listeningChildren += n2;
        }
        if ((l2 & 0x10000L) != 0L) {
            this.listeningBoundsChildren += n2;
        }
        this.adjustListeningChildrenOnParent(l2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusCycleRoot(boolean bl2) {
        boolean bl3;
        Container container = this;
        synchronized (container) {
            bl3 = this.focusCycleRoot;
            this.focusCycleRoot = bl2;
        }
        this.firePropertyChange("focusCycleRoot", bl3, bl2);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            if (this.peer != null) {
                this.peer.handleEvent(aWTEvent);
            }
            return;
        }
        super.dispatchEventImpl(aWTEvent);
        switch (aWTEvent.getID()) {
            case 101: {
                this.createChildHierarchyEvents(1402, 0L, Toolkit.enabledOnToolkit(65536L));
                break;
            }
            case 100: {
                this.createChildHierarchyEvents(1401, 0L, Toolkit.enabledOnToolkit(65536L));
                break;
            }
        }
    }

    void dispatchEventToSelf(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        if (n2 == 300 || n2 == 301) {
            return (this.eventMask & 2L) != 0L || this.containerListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public Component[] getComponents() {
        return this.getComponents_NoClientCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Component[] getComponents_NoClientCode() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            return componentArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n2 < 0 || n2 >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("No such child: " + n2);
            }
            return this.component[n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component findComponentAt(int n2, int n3) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.findComponentAt(n2, n3, true);
        }
    }

    public Component getComponentAt(int n2, int n3) {
        return this.locate(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component locate(int n2, int n3) {
        if (!this.contains(n2, n3)) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            int n4;
            for (n4 = 0; n4 < this.ncomponents; ++n4) {
                component = this.component[n4];
                if (component == null || component.peer instanceof LightweightPeer || !component.contains(n2 - component.x, n3 - component.y)) continue;
                return component;
            }
            for (n4 = 0; n4 < this.ncomponents; ++n4) {
                component = this.component[n4];
                if (component == null || !(component.peer instanceof LightweightPeer) || !component.contains(n2 - component.x, n3 - component.y)) continue;
                return component;
            }
        }
        return this;
    }

    final Component findComponentAt(int n2, int n3, boolean bl2) {
        Component component;
        int n4;
        if (!this.contains(n2, n3) || !this.visible || !bl2 && !this.enabled) {
            return null;
        }
        int n5 = this.ncomponents;
        Component[] componentArray = this.component;
        for (n4 = 0; n4 < n5; ++n4) {
            component = componentArray[n4];
            if (component == null || component.peer instanceof LightweightPeer || (component = component instanceof Container ? ((Container)component).findComponentAt(n2 - component.x, n3 - component.y, bl2) : component.locate(n2 - component.x, n3 - component.y)) == null || !component.visible || !bl2 && !component.enabled) continue;
            return component;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            component = componentArray[n4];
            if (component == null || !(component.peer instanceof LightweightPeer) || (component = component instanceof Container ? ((Container)component).findComponentAt(n2 - component.x, n3 - component.y, bl2) : component.locate(n2 - component.x, n3 - component.y)) == null || !component.visible || !bl2 && !component.enabled) continue;
            return component;
        }
        return this;
    }

    Component getDropTargetEventTarget(int n2, int n3, boolean bl2) {
        return this.getMouseEventTarget(n2, n3, bl2, DropTargetEventTargetFilter.FILTER, true);
    }

    Component getMouseEventTarget(int n2, int n3, boolean bl2) {
        return this.getMouseEventTarget(n2, n3, bl2, MouseEventTargetFilter.FILTER, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent == this) {
                Component[] componentArray = this.component;
                int n2 = this.ncomponents;
                while (--n2 >= 0) {
                    if (componentArray[n2] != component) continue;
                    this.remove(n2);
                }
            }
        }
    }

    public boolean isAncestorOf(Component component) {
        Container container;
        if (component == null || (container = component.getParent()) == null) {
            return false;
        }
        while (container != null) {
            if (container == this) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isParentOf(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (component != null && component != this && !(component instanceof Window)) {
                component = component.getParent();
            }
            return component == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setZOrder(Component component, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            Container container;
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n2 > this.ncomponents || n2 < 0 && n2 != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                container = this;
                while (container != null) {
                    if (container == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    container = container.parent;
                }
                if (component instanceof Window) {
                    throw new IllegalArgumentException("adding a window to a container");
                }
            }
            if (!(component.peer instanceof LightweightPeer)) {
                throw new IllegalArgumentException("should be lightweight component");
            }
            Container container2 = container = this.peer instanceof LightweightPeer ? this.getNativeContainer() : this;
            if (container != component.getNativeContainer()) {
                throw new IllegalArgumentException("component should be in the same heavyweight container");
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (component.parent != null) {
                int n3;
                object2 = component.parent;
                Component[] componentArray = ((Container)object2).component;
                int n4 = n3 = ((Container)object2).ncomponents;
                while (--n4 >= 0) {
                    if (componentArray[n4] != component) continue;
                    if (((Container)object2).layoutMgr != null) {
                        ((Container)object2).layoutMgr.removeLayoutComponent(component);
                    }
                    ((Container)object2).adjustListeningChildren(32768L, -component.numListening(32768L));
                    ((Container)object2).adjustListeningChildren(65536L, -component.numListening(65536L));
                    ((Container)object2).adjustDescendants(-component.countHierarchyMembers());
                    component.parent = null;
                    System.arraycopy(((Container)object2).component, n4 + 1, ((Container)object2).component, n4, ((Container)object2).ncomponents - n4 - 1);
                    componentArray[--((Container)object2).ncomponents] = null;
                    if (((Container)object2).valid) {
                        ((Container)object2).invalidate();
                    }
                    if (((Container)object2).containerListener != null || (((Container)object2).eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                        ContainerEvent containerEvent = new ContainerEvent((Component)object2, 301, component);
                        ((Component)object2).dispatchEvent(containerEvent);
                    }
                    component.createHierarchyEvents(1400, component, (Container)object2, 1L, Toolkit.enabledOnToolkit(32768L));
                    if (((Container)object2).peer == null || ((Container)object2).layoutMgr != null || !((Component)object2).isVisible()) continue;
                    ((Component)object2).updateCursorImmediately();
                }
                if (n2 > n3) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (this.ncomponents == this.component.length) {
                object2 = new Component[this.ncomponents * 2 + 1];
                System.arraycopy(this.component, 0, object2, 0, this.ncomponents);
                this.component = object2;
            }
            if (n2 == -1 || n2 == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n2, this.component, n2 + 1, this.ncomponents - n2);
                this.component[n2] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
                ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, null);
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                object2 = new ContainerEvent(this, 300, component);
                this.dispatchEvent((AWTEvent)object2);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        for (int i2 = 0; i2 < this.ncomponents; ++i2) {
            this.component[i2].applyComponentOrientation(componentOrientation);
        }
    }

    private Container findTraversalRoot() {
        Container container;
        Container container2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (container2 == this) {
            container = this;
        } else {
            container = this.getFocusCycleRootAncestor();
            if (container == null) {
                container = this;
            }
        }
        if (container != container2) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container);
        }
        return container;
    }

    public boolean isFocusCycleRoot(Container container) {
        if (this.isFocusCycleRoot() && container == this) {
            return true;
        }
        return super.isFocusCycleRoot(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                this.maxSize = layoutManager2.maximumLayoutSize(this);
            }
        } else {
            this.maxSize = super.getMaximumSize();
        }
        return this.maxSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.minSize = this.layoutMgr != null ? this.layoutMgr.minimumLayoutSize(this) : super.minimumSize();
            return this.minSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.prefSize = this.layoutMgr != null ? this.layoutMgr.preferredLayoutSize(this) : super.preferredSize();
            return this.prefSize;
        }
    }

    public void deliverEvent(Event event) {
        Component component = this.getComponentAt(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
        } else {
            this.postEvent(event);
        }
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.focusTraversalPolicy;
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy;
        }
        Container container = this.getFocusCycleRootAncestor();
        if (container != null) {
            return container.getFocusTraversalPolicy();
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2;
        Container container = this;
        synchronized (container) {
            focusTraversalPolicy2 = this.focusTraversalPolicy;
            this.focusTraversalPolicy = focusTraversalPolicy;
        }
        this.firePropertyChange("focusTraversalPolicy", focusTraversalPolicy2, focusTraversalPolicy);
    }

    public void setFont(Font font) {
        boolean bl2 = false;
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
            this.invalidateTree();
        }
    }

    void lightweightPaint(Graphics graphics) {
        super.lightweightPaint(graphics);
        this.paintHeavyweightComponents(graphics);
    }

    void lightweightPrint(Graphics graphics) {
        super.lightweightPrint(graphics);
        this.printHeavyweightComponents(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            if (this.printing) {
                Container container = this;
                synchronized (container) {
                    if (this.printing && this.printingThreads.contains(Thread.currentThread())) {
                        return;
                    }
                }
            }
            GraphicsCallback.PaintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void paintComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void paintHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        if (this.isShowing()) {
            Container container;
            Thread thread = Thread.currentThread();
            try {
                Container container2 = this;
                synchronized (container2) {
                    if (this.printingThreads == null) {
                        this.printingThreads = new HashSet();
                    }
                    this.printingThreads.add(thread);
                    this.printing = true;
                }
                super.print(graphics);
                Object var6_5 = null;
                container = this;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Container container3 = this;
                synchronized (container3) {
                    this.printingThreads.remove(thread);
                    this.printing = !this.printingThreads.isEmpty();
                }
                throw throwable;
            }
            synchronized (container) {
                this.printingThreads.remove(thread);
                this.printing = !this.printingThreads.isEmpty();
            }
            GraphicsCallback.PrintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void printComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void printHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (!(this.peer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.width, this.height);
            }
            this.paint(graphics);
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer != null && this.peer instanceof ContainerPeer) {
            ContainerPeer containerPeer = (ContainerPeer)this.peer;
            return (Insets)containerPeer.insets().clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        ContainerListener containerListener = this.containerListener;
        if (containerListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    containerListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    containerListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])this.getListeners(ContainerListener.class);
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.postProcessKeyEvent(keyEvent);
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.preProcessKeyEvent(keyEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block6: {
            Object object;
            Object object2;
            objectInputStream.defaultReadObject();
            Component[] componentArray = this.component;
            for (int i2 = 0; i2 < this.ncomponents; ++i2) {
                componentArray[i2].parent = this;
                this.adjustListeningChildren(32768L, componentArray[i2].numListening(32768L));
                this.adjustListeningChildren(65536L, componentArray[i2].numListening(65536L));
                this.adjustDescendants(componentArray[i2].countHierarchyMembers());
            }
            while (null != (object2 = objectInputStream.readObject())) {
                object = ((String)object2).intern();
                if ("containerL" == object) {
                    this.addContainerListener((ContainerListener)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
            try {
                object = objectInputStream.readObject();
                if (object instanceof FocusTraversalPolicy) {
                    this.focusTraversalPolicy = (FocusTraversalPolicy)object;
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block6;
                throw optionalDataException;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        objectOutputStream.writeObject(null);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    public void list(PrintStream printStream, int n2) {
        super.list(printStream, n2);
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        for (int i2 = 0; i2 < n3; ++i2) {
            Component component = componentArray[i2];
            if (component == null) continue;
            component.list(printStream, n2 + 1);
        }
    }

    public void list(PrintWriter printWriter, int n2) {
        super.list(printWriter, n2);
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        for (int i2 = 0; i2 < n3; ++i2) {
            Component component = componentArray[i2];
            if (component == null) continue;
            component.list(printWriter, n2 + 1);
        }
    }

    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = string + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    void checkGD(String string) {
        for (int i2 = 0; i2 < this.component.length; ++i2) {
            Component component = this.component[i2];
            if (component == null) continue;
            component.checkGD(string);
        }
    }

    public Set getFocusTraversalKeys(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.getFocusTraversalKeys_NoIDCheck(n2);
    }

    public void setFocusTraversalKeys(int n2, Set set) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        this.setFocusTraversalKeys_NoIDCheck(n2, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleChild(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n3 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!(componentArray[i2] instanceof Accessible)) continue;
                if (n3 == n2) {
                    return (Accessible)((Object)componentArray[i2]);
                }
                ++n3;
            }
            return null;
        }
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(Component component, int n2) {
        this.addImpl(component, null, n2);
        return component;
    }

    private Component getMouseEventTarget(int n2, int n3, boolean bl2, EventTargetFilter eventTargetFilter, boolean bl3) {
        Component component = null;
        if (bl3) {
            component = this.getMouseEventTargetImpl(n2, n3, bl2, eventTargetFilter, true, bl3);
        }
        if (component == null || component == this) {
            component = this.getMouseEventTargetImpl(n2, n3, bl2, eventTargetFilter, false, bl3);
        }
        return component;
    }

    private Component getMouseEventTargetImpl(int n2, int n3, boolean bl2, EventTargetFilter eventTargetFilter, boolean bl3, boolean bl4) {
        int n4;
        int n5 = this.ncomponents;
        Component[] componentArray = this.component;
        for (n4 = 0; n4 < n5; ++n4) {
            Component component = componentArray[n4];
            if (component == null || !component.visible || (bl3 || !(component.peer instanceof LightweightPeer)) && (!bl3 || component.peer instanceof LightweightPeer) || !component.contains(n2 - component.x, n3 - component.y)) continue;
            if (component instanceof Container) {
                Container container = (Container)component;
                Component component2 = container.getMouseEventTarget(n2 - container.x, n3 - container.y, bl2, eventTargetFilter, bl4);
                if (component2 == null) continue;
                return component2;
            }
            if (!eventTargetFilter.accept(component)) continue;
            return component;
        }
        n4 = this.peer instanceof LightweightPeer || bl2 ? 1 : 0;
        boolean bl5 = this.contains(n2, n3);
        if (bl5 && n4 != 0 && eventTargetFilter.accept(this)) {
            return this;
        }
        return null;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    int createHierarchyEvents(int n2, Component component, Container container, long l2, boolean bl2) {
        int n3 = 0;
        switch (n2) {
            case 1400: {
                n3 = this.listeningChildren;
                break;
            }
            case 1401: 
            case 1402: {
                n3 = this.listeningBoundsChildren;
                break;
            }
        }
        if (bl2) {
            n3 = this.descendantsCount;
        }
        int n4 = n3;
        int n5 = 0;
        while (n4 > 0) {
            n4 -= this.component[n5].createHierarchyEvents(n2, component, container, l2, bl2);
            ++n5;
        }
        return n3 + super.createHierarchyEvents(n2, component, container, l2, bl2);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n2) {
        this.addImpl(component, object, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n2) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3;
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n2 > this.ncomponents || n2 < 0 && n2 != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                object3 = this;
                while (object3 != null) {
                    if (object3 == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    object3 = object3.parent;
                }
                if (component instanceof Window) {
                    throw new IllegalArgumentException("adding a window to a container");
                }
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (component.parent != null) {
                component.parent.remove(component);
                if (n2 > this.ncomponents) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (this.ncomponents == this.component.length) {
                object3 = new Component[this.ncomponents * 2 + 1];
                System.arraycopy(this.component, 0, object3, 0, this.ncomponents);
                this.component = object3;
            }
            if (n2 == -1 || n2 == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n2, this.component, n2 + 1, this.ncomponents - n2);
                this.component[n2] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                object3 = new ContainerEvent((Component)this, 300, component);
                this.dispatchEvent((AWTEvent)object3);
            }
            component.createHierarchyEvents(1400, component, (Container)this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    public EventListener[] getListeners(Class clazz) {
        ContainerListener containerListener = null;
        if (clazz != ContainerListener.class) {
            return super.getListeners(clazz);
        }
        containerListener = this.containerListener;
        return AWTEventMulticaster.getListeners(containerListener, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleAt(Point point) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)this);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext != null) {
                    int n2 = accessibleContext.getAccessibleChildrenCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        AccessibleComponent accessibleComponent;
                        accessible = accessibleContext.getAccessibleChild(i2);
                        if (accessible == null || (accessibleContext = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null || !accessibleComponent.isShowing()) continue;
                        Point point2 = accessibleComponent.getLocation();
                        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                        if (!accessibleComponent.contains(point3)) continue;
                        return accessible;
                    }
                }
                return (Accessible)((Object)this);
            }
            Component component = this;
            if (!this.contains(point.x, point.y)) {
                component = null;
            } else {
                int n3 = this.getComponentCount();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Component component2 = this.getComponent(i3);
                    if (component2 == null || !component2.isShowing()) continue;
                    Point point4 = component2.getLocation();
                    if (!component2.contains(point.x - point4.x, point.y - point4.y)) continue;
                    component = component2;
                }
            }
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        protected ContainerListener accessibleContainerHandler = null;

        public int getAccessibleChildrenCount() {
            return Container.this.getAccessibleChildrenCount();
        }

        protected AccessibleAWTContainer() {
        }

        public Accessible getAccessibleChild(int n2) {
            return Container.this.getAccessibleChild(n2);
        }

        public Accessible getAccessibleAt(Point point) {
            return Container.this.getAccessibleAt(point);
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }

    static class DropTargetEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new DropTargetEventTargetFilter();

        private DropTargetEventTargetFilter() {
        }

        public boolean accept(Component component) {
            DropTarget dropTarget = component.getDropTarget();
            return dropTarget != null && dropTarget.isActive();
        }
    }

    static interface EventTargetFilter {
        public boolean accept(Component var1);
    }

    static class MouseEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new MouseEventTargetFilter();

        private MouseEventTargetFilter() {
        }

        public boolean accept(Component component) {
            return (component.eventMask & 0x20L) != 0L || (component.eventMask & 0x10L) != 0L || (component.eventMask & 0x20000L) != 0L || component.mouseListener != null || component.mouseMotionListener != null || component.mouseWheelListener != null;
        }
    }
}

