/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected Object viewedBuffer = null;
    private final Cleaner cleaner;
    static final /* synthetic */ boolean $assertionsDisabled;

    public byte get() {
        return unsafe.getByte(this.ix(this.nextGetIndex()));
    }

    public char getChar() {
        return this.getChar(this.ix(this.nextGetIndex(2)));
    }

    public double getDouble() {
        return this.getDouble(this.ix(this.nextGetIndex(8)));
    }

    public float getFloat() {
        return this.getFloat(this.ix(this.nextGetIndex(4)));
    }

    public int getInt() {
        return this.getInt(this.ix(this.nextGetIndex(4)));
    }

    public long address() {
        return this.address;
    }

    public long getLong() {
        return this.getLong(this.ix(this.nextGetIndex(8)));
    }

    public short getShort() {
        return this.getShort(this.ix(this.nextGetIndex(2)));
    }

    static {
        $assertionsDisabled = !DirectByteBuffer.class.desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    byte _get(int n2) {
        return unsafe.getByte(this.address + (long)n2);
    }

    public byte get(int n2) {
        return unsafe.getByte(this.ix(this.checkIndex(n2)));
    }

    public char getChar(int n2) {
        return this.getChar(this.ix(this.checkIndex(n2, 2)));
    }

    public double getDouble(int n2) {
        return this.getDouble(this.ix(this.checkIndex(n2, 8)));
    }

    public float getFloat(int n2) {
        return this.getFloat(this.ix(this.checkIndex(n2, 4)));
    }

    public int getInt(int n2) {
        return this.getInt(this.ix(this.checkIndex(n2, 4)));
    }

    public long getLong(int n2) {
        return this.getLong(this.ix(this.checkIndex(n2, 8)));
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 0);
    }

    public short getShort(int n2) {
        return this.getShort(this.ix(this.checkIndex(n2, 2)));
    }

    DirectByteBuffer(int n2) {
        super(-1, 0, n2, n2, false);
        Bits.reserveMemory(n2);
        int n3 = Bits.pageSize();
        long l2 = 0L;
        try {
            l2 = unsafe.allocateMemory(n2 + n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Bits.unreserveMemory(n2);
            throw outOfMemoryError;
        }
        unsafe.setMemory(l2, n2 + n3, (byte)0);
        this.address = l2 % (long)n3 != 0L ? l2 + (long)n3 - (l2 & (long)(n3 - 1)) : l2;
        this.cleaner = Cleaner.create(this, new Deallocator(l2, n2));
    }

    void _put(int n2, byte by) {
        unsafe.putByte(this.address + (long)n2, by);
    }

    private char getChar(long l2) {
        if (unaligned) {
            char c2 = unsafe.getChar(l2);
            return this.nativeByteOrder ? c2 : Bits.swap(c2);
        }
        return Bits.getChar(l2, this.bigEndian);
    }

    private double getDouble(long l2) {
        if (unaligned) {
            long l3 = unsafe.getLong(l2);
            return Double.longBitsToDouble(this.nativeByteOrder ? l3 : Bits.swap(l3));
        }
        return Bits.getDouble(l2, this.bigEndian);
    }

    private float getFloat(long l2) {
        if (unaligned) {
            int n2 = unsafe.getInt(l2);
            return Float.intBitsToFloat(this.nativeByteOrder ? n2 : Bits.swap(n2));
        }
        return Bits.getFloat(l2, this.bigEndian);
    }

    private int getInt(long l2) {
        if (unaligned) {
            int n2 = unsafe.getInt(l2);
            return this.nativeByteOrder ? n2 : Bits.swap(n2);
        }
        return Bits.getInt(l2, this.bigEndian);
    }

    private long getLong(long l2) {
        if (unaligned) {
            long l3 = unsafe.getLong(l2);
            return this.nativeByteOrder ? l3 : Bits.swap(l3);
        }
        return Bits.getLong(l2, this.bigEndian);
    }

    private short getShort(long l2) {
        if (unaligned) {
            short s2 = unsafe.getShort(l2);
            return this.nativeByteOrder ? s2 : Bits.swap(s2);
        }
        return Bits.getShort(l2, this.bigEndian);
    }

    private DirectByteBuffer(long l2, int n2) {
        super(-1, 0, n2, n2, false);
        this.address = l2;
        this.cleaner = null;
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    protected DirectByteBuffer(int n2, long l2, Runnable runnable) {
        super(-1, 0, n2, n2, true);
        this.address = l2;
        this.viewedBuffer = null;
        this.cleaner = Cleaner.create(this, runnable);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ByteBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 0);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public ByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ByteBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 0;
        return new DirectByteBuffer(this, -1, 0, n4, n4, n5);
    }

    public ByteBuffer put(byte by) {
        unsafe.putByte(this.ix(this.nextPutIndex()), by);
        return this;
    }

    public ByteBuffer putChar(char c2) {
        this.putChar(this.ix(this.nextPutIndex(2)), c2);
        return this;
    }

    public ByteBuffer putDouble(double d2) {
        this.putDouble(this.ix(this.nextPutIndex(8)), d2);
        return this;
    }

    public ByteBuffer putFloat(float f2) {
        this.putFloat(this.ix(this.nextPutIndex(4)), f2);
        return this;
    }

    public ByteBuffer putInt(int n2) {
        this.putInt(this.ix(this.nextPutIndex(4)), n2);
        return this;
    }

    public ByteBuffer put(int n2, byte by) {
        unsafe.putByte(this.ix(this.checkIndex(n2)), by);
        return this;
    }

    public ByteBuffer putChar(int n2, char c2) {
        this.putChar(this.ix(this.checkIndex(n2, 2)), c2);
        return this;
    }

    public ByteBuffer putDouble(int n2, double d2) {
        this.putDouble(this.ix(this.checkIndex(n2, 8)), d2);
        return this;
    }

    public ByteBuffer putFloat(int n2, float f2) {
        this.putFloat(this.ix(this.checkIndex(n2, 4)), f2);
        return this;
    }

    public ByteBuffer putInt(int n2, int n3) {
        this.putInt(this.ix(this.checkIndex(n2, 4)), n3);
        return this;
    }

    public ByteBuffer putLong(int n2, long l2) {
        this.putLong(this.ix(this.checkIndex(n2, 8)), l2);
        return this;
    }

    public ByteBuffer putShort(int n2, short s2) {
        this.putShort(this.ix(this.checkIndex(n2, 2)), s2);
        return this;
    }

    public ByteBuffer putLong(long l2) {
        this.putLong(this.ix(this.nextPutIndex(8)), l2);
        return this;
    }

    private ByteBuffer putChar(long l2, char c2) {
        if (unaligned) {
            char c3 = c2;
            unsafe.putChar(l2, this.nativeByteOrder ? c3 : Bits.swap(c3));
        } else {
            Bits.putChar(l2, c2, this.bigEndian);
        }
        return this;
    }

    private ByteBuffer putDouble(long l2, double d2) {
        if (unaligned) {
            long l3 = Double.doubleToRawLongBits(d2);
            unsafe.putLong(l2, this.nativeByteOrder ? l3 : Bits.swap(l3));
        } else {
            Bits.putDouble(l2, d2, this.bigEndian);
        }
        return this;
    }

    private ByteBuffer putFloat(long l2, float f2) {
        if (unaligned) {
            int n2 = Float.floatToRawIntBits(f2);
            unsafe.putInt(l2, this.nativeByteOrder ? n2 : Bits.swap(n2));
        } else {
            Bits.putFloat(l2, f2, this.bigEndian);
        }
        return this;
    }

    private ByteBuffer putInt(long l2, int n2) {
        if (unaligned) {
            int n3 = n2;
            unsafe.putInt(l2, this.nativeByteOrder ? n3 : Bits.swap(n3));
        } else {
            Bits.putInt(l2, n2, this.bigEndian);
        }
        return this;
    }

    private ByteBuffer putLong(long l2, long l3) {
        if (unaligned) {
            long l4 = l3;
            unsafe.putLong(l2, this.nativeByteOrder ? l4 : Bits.swap(l4));
        } else {
            Bits.putLong(l2, l3, this.bigEndian);
        }
        return this;
    }

    private ByteBuffer putShort(long l2, short s2) {
        if (unaligned) {
            short s3 = s2;
            unsafe.putShort(l2, this.nativeByteOrder ? s3 : Bits.swap(s3));
        } else {
            Bits.putShort(l2, s2, this.bigEndian);
        }
        return this;
    }

    public ByteBuffer putShort(short s2) {
        this.putShort(this.ix(this.nextPutIndex(2)), s2);
        return this;
    }

    public ByteBuffer get(byte[] byArray, int n2, int n3) {
        if (n3 << 0 > 6) {
            int n4;
            DirectByteBuffer.checkBounds(n2, n3, byArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToByteArray(this.ix(n5), byArray, n2 << 0, n3 << 0);
            } else {
                Bits.copyToByteArray(this.ix(n5), byArray, n2 << 0, n3 << 0);
            }
            this.position(n5 + n3);
        } else {
            super.get(byArray, n2, n3);
        }
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n2, int n3) {
        if (n3 << 0 > 6) {
            int n4;
            DirectByteBuffer.checkBounds(n2, n3, byArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromByteArray(byArray, n2 << 0, this.ix(n5), n3 << 0);
            } else {
                Bits.copyFromByteArray(byArray, n2 << 0, this.ix(n5), n3 << 0);
            }
            this.position(n5 + n3);
        } else {
            super.put(byArray, n2, n3);
        }
        return this;
    }

    public CharBuffer asCharBuffer() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n4 >> 1;
        if (!unaligned && (this.address + (long)n2) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, n5, n5, n2) : new ByteBufferAsCharBufferL(this, -1, 0, n5, n5, n2);
        }
        return this.nativeByteOrder ? new DirectCharBufferU(this, -1, 0, n5, n5, n2) : new DirectCharBufferS(this, -1, 0, n5, n5, n2);
    }

    public DoubleBuffer asDoubleBuffer() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n4 >> 3;
        if (!unaligned && (this.address + (long)n2) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, n5, n5, n2) : new ByteBufferAsDoubleBufferL(this, -1, 0, n5, n5, n2);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferU(this, -1, 0, n5, n5, n2) : new DirectDoubleBufferS(this, -1, 0, n5, n5, n2);
    }

    public FloatBuffer asFloatBuffer() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n4 >> 2;
        if (!unaligned && (this.address + (long)n2) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, n5, n5, n2) : new ByteBufferAsFloatBufferL(this, -1, 0, n5, n5, n2);
        }
        return this.nativeByteOrder ? new DirectFloatBufferU(this, -1, 0, n5, n5, n2) : new DirectFloatBufferS(this, -1, 0, n5, n5, n2);
    }

    public IntBuffer asIntBuffer() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n4 >> 2;
        if (!unaligned && (this.address + (long)n2) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, n5, n5, n2) : new ByteBufferAsIntBufferL(this, -1, 0, n5, n5, n2);
        }
        return this.nativeByteOrder ? new DirectIntBufferU(this, -1, 0, n5, n5, n2) : new DirectIntBufferS(this, -1, 0, n5, n5, n2);
    }

    public LongBuffer asLongBuffer() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n4 >> 3;
        if (!unaligned && (this.address + (long)n2) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, n5, n5, n2) : new ByteBufferAsLongBufferL(this, -1, 0, n5, n5, n2);
        }
        return this.nativeByteOrder ? new DirectLongBufferU(this, -1, 0, n5, n5, n2) : new DirectLongBufferS(this, -1, 0, n5, n5, n2);
    }

    public ShortBuffer asShortBuffer() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n4 >> 1;
        if (!unaligned && (this.address + (long)n2) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, n5, n5, n2) : new ByteBufferAsShortBufferL(this, -1, 0, n5, n5, n2);
        }
        return this.nativeByteOrder ? new DirectShortBufferU(this, -1, 0, n5, n5, n2) : new DirectShortBufferS(this, -1, 0, n5, n5, n2);
    }

    public Cleaner cleaner() {
        return this.cleaner;
    }

    DirectByteBuffer(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.viewedBuffer = directBuffer;
        this.cleaner = null;
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof DirectByteBuffer) {
            int n2;
            if (byteBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectByteBuffer directByteBuffer = (DirectByteBuffer)byteBuffer;
            int n3 = directByteBuffer.position();
            int n4 = directByteBuffer.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directByteBuffer.ix(n3), this.ix(n6), n5 << 0);
            directByteBuffer.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!byteBuffer.isDirect()) {
            int n9 = byteBuffer.position();
            int n10 = byteBuffer.limit();
            if (!$assertionsDisabled && n9 > n10) {
                throw new AssertionError();
            }
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(byteBuffer.hb, byteBuffer.offset + n9, n11);
            byteBuffer.position(n9 + n11);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }

    private static class Deallocator
    implements Runnable {
        private static Unsafe unsafe;
        private long address;
        private int capacity;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$java$nio$DirectByteBuffer == null ? (class$java$nio$DirectByteBuffer = DirectByteBuffer.class$("java.nio.DirectByteBuffer")) : class$java$nio$DirectByteBuffer).desiredAssertionStatus();
            unsafe = Unsafe.getUnsafe();
        }

        public void run() {
            if (this.address == 0L) {
                return;
            }
            unsafe.freeMemory(this.address);
            this.address = 0L;
            Bits.unreserveMemory(this.capacity);
        }

        private Deallocator(long l2, int n2) {
            if (!$assertionsDisabled && l2 == 0L) {
                throw new AssertionError();
            }
            this.address = l2;
            this.capacity = n2;
        }
    }
}

