/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.w3c.dom.Element;

class NumeratorFormatter {
    protected Element m_xslNumberElement;
    NumberFormatStringTokenizer m_formatTokenizer;
    Locale m_locale;
    NumberFormat m_formatter;
    TransformerImpl m_processor;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static final char[] m_alphaCountTable = new char[]{'Z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};

    protected String int2alphaCount(int n2, char[] cArray) {
        int n3 = cArray.length;
        char[] cArray2 = new char[100];
        int n4 = cArray2.length - 1;
        int n5 = 1;
        int n6 = 0;
        while ((n5 = (n2 + (n6 = n5 == 0 || n6 != 0 && n5 == n3 - 1 ? n3 - 1 : 0)) % n3) != 0 || (n2 /= n3) != 0) {
            cArray2[n4--] = cArray[n5];
            if (n2 > 0) continue;
        }
        return new String(cArray2, n4 + 1, cArray2.length - n4 - 1);
    }

    String long2roman(long l2, boolean bl2) {
        if (l2 <= 0L) {
            return "#E(" + l2 + ")";
        }
        String string = "";
        int n2 = 0;
        if (l2 <= 3999L) {
            while (true) {
                if (l2 >= NumeratorFormatter.m_romanConvertTable[n2].m_postValue) {
                    string = string + NumeratorFormatter.m_romanConvertTable[n2].m_postLetter;
                    l2 -= NumeratorFormatter.m_romanConvertTable[n2].m_postValue;
                    continue;
                }
                if (bl2 && l2 >= NumeratorFormatter.m_romanConvertTable[n2].m_preValue) {
                    string = string + NumeratorFormatter.m_romanConvertTable[n2].m_preLetter;
                    l2 -= NumeratorFormatter.m_romanConvertTable[n2].m_preValue;
                }
                ++n2;
                if (l2 <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    NumeratorFormatter(Element element, TransformerImpl transformerImpl) {
        this.m_xslNumberElement = element;
        this.m_processor = transformerImpl;
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        int countTokens() {
            int n2 = 0;
            int n3 = this.currentPosition;
            while (n3 < this.maxPosition) {
                int n4 = n3;
                while (n3 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n3))) {
                    ++n3;
                }
                if (n4 == n3 && !Character.isLetterOrDigit(this.str.charAt(n3))) {
                    ++n3;
                }
                ++n2;
            }
            return n2;
        }

        void reset() {
            this.currentPosition = 0;
        }

        boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n2 = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n2 == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n2, this.currentPosition);
        }

        NumberFormatStringTokenizer(String string) {
            this.str = string;
            this.maxPosition = string.length();
        }
    }
}

