/*
 * Decompiled with CFR 0.152.
 */
package emulator.custom.subclass;

import emulator.custom.subclass.SubTimerTask;
import emulator.custom.subclass.TaskQueue;
import emulator.custom.subclass.TimerThread;
import java.util.Date;

public class Timer {
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread;

    public void schedule(SubTimerTask subTimerTask, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(subTimerTask, System.currentTimeMillis() + l2, 0L);
    }

    public void schedule(SubTimerTask subTimerTask, Date date) {
        this.sched(subTimerTask, date.getTime(), 0L);
    }

    public void schedule(SubTimerTask subTimerTask, long l2, long l3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(subTimerTask, System.currentTimeMillis() + l2, -l3);
    }

    public void schedule(SubTimerTask subTimerTask, Date date, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(subTimerTask, date.getTime(), -l2);
    }

    public void scheduleAtFixedRate(SubTimerTask subTimerTask, long l2, long l3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(subTimerTask, System.currentTimeMillis() + l2, l3);
    }

    public void scheduleAtFixedRate(SubTimerTask subTimerTask, Date date, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(subTimerTask, date.getTime(), l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(SubTimerTask subTimerTask, long l2, long l3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.queue.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new TimerThread(this.queue);
                this.thread.start();
            }
            Object object = subTimerTask.lock;
            synchronized (object) {
                if (subTimerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                subTimerTask.nextExecutionTime = l2;
                subTimerTask.period = l3;
                subTimerTask.state = 1;
            }
            this.queue.add(subTimerTask);
            if (this.queue.getMin() == subTimerTask) {
                this.queue.notify();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.queue.notify();
            return;
        }
    }
}

