/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;
import org.eclipse.swt.internal.mozilla.nsISupports;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    public InputStream(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[8];
        nArray[0] = 2;
        nArray[4] = 1;
        nArray[5] = 3;
        nArray[6] = 4;
        nArray[7] = 1;
        this.inputStream = new XPCOMObject(nArray){

            public int method0(int[] nArray) {
                return InputStream.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return InputStream.this.AddRef();
            }

            public int method2(int[] nArray) {
                return InputStream.this.Release();
            }

            public int method3(int[] nArray) {
                return InputStream.this.Close();
            }

            public int method4(int[] nArray) {
                return InputStream.this.Available(nArray[0]);
            }

            public int method5(int[] nArray) {
                return InputStream.this.Read(nArray[0], nArray[1], nArray[2]);
            }

            public int method6(int[] nArray) {
                return InputStream.this.ReadSegments(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method7(int[] nArray) {
                return InputStream.this.IsNonBlocking(nArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    int getAddress() {
        return this.inputStream.getAddress();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n2, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n3, new int[]{this.inputStream.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIInputStream.NS_IINPUTSTREAM_IID)) {
            XPCOM.memmove(n3, new int[]{this.inputStream.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n3, new int[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Close() {
        this.buffer = null;
        this.index = 0;
        return 0;
    }

    int Available(int n2) {
        int n3 = this.buffer == null ? 0 : this.buffer.length - this.index;
        XPCOM.memmove(n2, new int[]{n3}, 4);
        return 0;
    }

    int Read(int n2, int n3, int n4) {
        int n5 = Math.min(n3, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (n5 > 0) {
            byte[] byArray = new byte[n5];
            System.arraycopy(this.buffer, this.index, byArray, 0, n5);
            XPCOM.memmove(n2, byArray, n5);
            this.index += n5;
        }
        XPCOM.memmove(n4, new int[]{n5}, 4);
        return 0;
    }

    int ReadSegments(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n6 = Math.min(n4, this.buffer == null ? 0 : this.buffer.length - this.index);
        while (n7 > 0) {
            int[] nArray = new int[1];
            int n8 = XPCOM.Call(n2, this.getAddress(), n3, this.buffer, this.index, n7, nArray);
            if (n8 != 0) break;
            this.index += nArray[0];
            n7 -= nArray[0];
        }
        XPCOM.memmove(n5, new int[]{n6 - n7}, 4);
        return 0;
    }

    int IsNonBlocking(int n2) {
        XPCOM.memmove(n2, new int[1], 4);
        return 0;
    }
}

