/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;

class PngIhdrChunk
extends PngChunk {
    static final int IHDR_DATA_LENGTH = 13;
    static final int WIDTH_DATA_OFFSET = 8;
    static final int HEIGHT_DATA_OFFSET = 12;
    static final int BIT_DEPTH_OFFSET = 16;
    static final int COLOR_TYPE_OFFSET = 17;
    static final int COMPRESSION_METHOD_OFFSET = 18;
    static final int FILTER_METHOD_OFFSET = 19;
    static final int INTERLACE_METHOD_OFFSET = 20;
    static final byte COLOR_TYPE_GRAYSCALE = 0;
    static final byte COLOR_TYPE_RGB = 2;
    static final byte COLOR_TYPE_PALETTE = 3;
    static final byte COLOR_TYPE_GRAYSCALE_WITH_ALPHA = 4;
    static final byte COLOR_TYPE_RGB_WITH_ALPHA = 6;
    static final int INTERLACE_METHOD_NONE = 0;
    static final int INTERLACE_METHOD_ADAM7 = 1;
    static final int FILTER_NONE = 0;
    static final int FILTER_SUB = 1;
    static final int FILTER_UP = 2;
    static final int FILTER_AVERAGE = 3;
    static final int FILTER_PAETH = 4;
    static final byte[] ValidBitDepths = new byte[]{1, 2, 4, 8, 16};
    static final byte[] ValidColorTypes;
    int width;
    int height;
    byte bitDepth;
    byte colorType;
    byte compressionMethod;
    byte filterMethod;
    byte interlaceMethod;

    static {
        byte[] byArray = new byte[5];
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 6;
        ValidColorTypes = byArray;
    }

    PngIhdrChunk(int n2, int n3, byte by2, byte by3, byte by4, byte by5, byte by6) {
        super(13);
        this.setType(TYPE_IHDR);
        this.setWidth(n2);
        this.setHeight(n3);
        this.setBitDepth(by2);
        this.setColorType(by3);
        this.setCompressionMethod(by4);
        this.setFilterMethod(by5);
        this.setInterlaceMethod(by6);
        this.setCRC(this.computeCRC());
    }

    PngIhdrChunk(byte[] byArray) {
        super(byArray);
        if (byArray.length <= 13) {
            SWT.error(40);
        }
        this.width = this.getInt32(8);
        this.height = this.getInt32(12);
        this.bitDepth = byArray[16];
        this.colorType = byArray[17];
        this.compressionMethod = byArray[18];
        this.filterMethod = byArray[19];
        this.interlaceMethod = byArray[20];
    }

    int getChunkType() {
        return 0;
    }

    int getWidth() {
        return this.width;
    }

    void setWidth(int n2) {
        this.setInt32(8, n2);
        this.width = n2;
    }

    int getHeight() {
        return this.height;
    }

    void setHeight(int n2) {
        this.setInt32(12, n2);
        this.height = n2;
    }

    byte getBitDepth() {
        return this.bitDepth;
    }

    void setBitDepth(byte by2) {
        this.reference[16] = by2;
        this.bitDepth = by2;
    }

    byte getColorType() {
        return this.colorType;
    }

    void setColorType(byte by2) {
        this.reference[17] = by2;
        this.colorType = by2;
    }

    byte getCompressionMethod() {
        return this.compressionMethod;
    }

    void setCompressionMethod(byte by2) {
        this.reference[18] = by2;
        this.compressionMethod = by2;
    }

    byte getFilterMethod() {
        return this.filterMethod;
    }

    void setFilterMethod(byte by2) {
        this.reference[19] = by2;
        this.filterMethod = by2;
    }

    byte getInterlaceMethod() {
        return this.interlaceMethod;
    }

    void setInterlaceMethod(byte by2) {
        this.reference[20] = by2;
        this.interlaceMethod = by2;
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        if (pngFileReadState.readIHDR || pngFileReadState.readPLTE || pngFileReadState.readIDAT || pngFileReadState.readIEND) {
            SWT.error(40);
        } else {
            pngFileReadState.readIHDR = true;
        }
        super.validate(pngFileReadState, pngIhdrChunk);
        if (this.length != 13) {
            SWT.error(40);
        }
        if (this.compressionMethod != 0) {
            SWT.error(40);
        }
        if (this.interlaceMethod != 0 && this.interlaceMethod != 1) {
            SWT.error(40);
        }
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < ValidColorTypes.length) {
            if (ValidColorTypes[n2] == this.colorType) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl2) {
            SWT.error(40);
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < ValidBitDepths.length) {
            if (ValidBitDepths[n3] == this.bitDepth) {
                n2 = 1;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            SWT.error(40);
        }
        if ((this.colorType == 2 || this.colorType == 6 || this.colorType == 4) && this.bitDepth < 8) {
            SWT.error(40);
        }
        if (this.colorType == 3 && this.bitDepth > 8) {
            SWT.error(40);
        }
    }

    String getColorTypeString() {
        switch (this.colorType) {
            case 0: {
                return "Grayscale";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "Palette";
            }
            case 4: {
                return "Grayscale with Alpha";
            }
            case 6: {
                return "RGB with Alpha";
            }
        }
        return "Unknown - " + this.colorType;
    }

    String getFilterMethodString() {
        switch (this.filterMethod) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Sub";
            }
            case 2: {
                return "Up";
            }
            case 3: {
                return "Average";
            }
            case 4: {
                return "Paeth";
            }
        }
        return "Unknown";
    }

    String getInterlaceMethodString() {
        switch (this.interlaceMethod) {
            case 0: {
                return "Not Interlaced";
            }
            case 1: {
                return "Interlaced - ADAM7";
            }
        }
        return "Unknown";
    }

    void contributeToString(StringBuffer stringBuffer) {
        stringBuffer.append("\n\tWidth: ");
        stringBuffer.append(this.width);
        stringBuffer.append("\n\tHeight: ");
        stringBuffer.append(this.height);
        stringBuffer.append("\n\tBit Depth: ");
        stringBuffer.append(this.bitDepth);
        stringBuffer.append("\n\tColor Type: ");
        stringBuffer.append(this.getColorTypeString());
        stringBuffer.append("\n\tCompression Method: ");
        stringBuffer.append(this.compressionMethod);
        stringBuffer.append("\n\tFilter Method: ");
        stringBuffer.append(this.getFilterMethodString());
        stringBuffer.append("\n\tInterlace Method: ");
        stringBuffer.append(this.getInterlaceMethodString());
    }

    boolean getMustHavePalette() {
        return this.colorType == 3;
    }

    boolean getCanHavePalette() {
        return this.colorType != 0 && this.colorType != 4;
    }

    int getBitsPerPixel() {
        switch (this.colorType) {
            case 6: {
                return 4 * this.bitDepth;
            }
            case 2: {
                return 3 * this.bitDepth;
            }
            case 4: {
                return 2 * this.bitDepth;
            }
            case 0: 
            case 3: {
                return this.bitDepth;
            }
        }
        SWT.error(40);
        return 0;
    }

    int getSwtBitsPerPixel() {
        switch (this.colorType) {
            case 2: 
            case 4: 
            case 6: {
                return 24;
            }
            case 0: 
            case 3: {
                return Math.min(this.bitDepth, 8);
            }
        }
        SWT.error(40);
        return 0;
    }

    int getFilterByteOffset() {
        if (this.bitDepth < 8) {
            return 1;
        }
        return this.getBitsPerPixel() / 8;
    }

    boolean usesDirectColor() {
        switch (this.colorType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    PaletteData createGrayscalePalette() {
        int n2 = Math.min(this.bitDepth, 8);
        int n3 = (1 << n2) - 1;
        int n4 = 255 / n3;
        int n5 = 0;
        RGB[] rGBArray = new RGB[n3 + 1];
        int n6 = 0;
        while (n6 <= n3) {
            rGBArray[n6] = new RGB(n5, n5, n5);
            n5 += n4;
            ++n6;
        }
        return new PaletteData(rGBArray);
    }

    PaletteData getPaletteData() {
        switch (this.colorType) {
            case 0: {
                return this.createGrayscalePalette();
            }
            case 2: 
            case 4: 
            case 6: {
                return new PaletteData(0xFF0000, 65280, 255);
            }
        }
        return null;
    }
}

