/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n2) {
        super(composite, n2);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        int n6 = this.scrolledHandle();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n7 = OS.GetWindowLong(n6, -16);
        int n8 = OS.GetWindowLong(n6, -20);
        OS.AdjustWindowRectEx(rECT, n7, false, n8);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        int n9 = rECT.right - rECT.left;
        int n10 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n9, n10);
    }

    ScrollBar createScrollBar(int n2) {
        ScrollBar scrollBar = new ScrollBar(this, n2);
        if ((this.state & 2) != 0) {
            scrollBar.setMaximum(100);
            scrollBar.setThumb(10);
        }
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        int n2 = this.scrolledHandle();
        OS.GetClientRect(n2, rECT);
        int n3 = rECT.left;
        int n4 = rECT.top;
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        if (n2 != this.handle) {
            OS.GetClientRect(this.handle, rECT);
            OS.MapWindowPoints(this.handle, n2, rECT, 2);
            n3 = -rECT.left;
            n4 = -rECT.top;
        }
        return new Rectangle(n3, n4, n5, n6);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseChildren(boolean bl2) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl2);
    }

    int scrolledHandle() {
        return this.handle;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            n2 |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            n2 |= 0x200000;
        }
        return n2;
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_HSCROLL(int n2, int n3) {
        LRESULT lRESULT = super.WM_HSCROLL(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.horizontalBar != null && (n3 == 0 || n3 == this.handle)) {
            return this.wmScroll(this.horizontalBar, (this.state & 2) != 0, this.handle, 276, n2, n3);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEWHEEL(int n2, int n3) {
        Event event;
        int n4;
        LRESULT lRESULT = super.WM_MOUSEWHEEL(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.state & 2) != 0) {
            int n5;
            boolean bl2;
            if ((n2 & 0xC) != 0) {
                return lRESULT;
            }
            boolean bl3 = this.verticalBar != null && this.verticalBar.getEnabled();
            boolean bl4 = bl2 = this.horizontalBar != null && this.horizontalBar.getEnabled();
            int n6 = bl3 ? 277 : (n5 = bl2 ? 276 : 0);
            if (n5 == 0) {
                return lRESULT;
            }
            int[] nArray = new int[1];
            OS.SystemParametersInfo(104, 0, nArray, 0);
            int n7 = n2 >> 16;
            int n8 = 0;
            int n9 = 0;
            if (nArray[0] == -1) {
                n8 = n7 < 0 ? 3 : 2;
                n9 = Math.abs(n7 / 120);
            } else {
                n8 = n7 < 0 ? 1 : 0;
                if ((n7 = Math.abs(n7)) < 120) {
                    return lRESULT;
                }
                n9 = n5 == 277 ? nArray[0] * n7 / 120 : n7 / 120;
            }
            int n10 = 0;
            while (n10 < n9) {
                OS.SendMessage(this.handle, n5, n8, 0);
                ++n10;
            }
            return LRESULT.ZERO;
        }
        int n11 = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int n12 = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int n13 = this.callWindowProc(this.handle, 522, n2, n3);
        if (this.verticalBar != null && (n4 = this.verticalBar.getSelection()) != n11) {
            event = new Event();
            event.detail = n4 < n11 ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
        }
        if (this.horizontalBar != null && (n4 = this.horizontalBar.getSelection()) != n12) {
            event = new Event();
            event.detail = n4 < n12 ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
        }
        return new LRESULT(n13);
    }

    LRESULT WM_SIZE(int n2, int n3) {
        int n4 = this.callWindowProc(this.handle, 5, n2, n3);
        super.WM_SIZE(n2, n3);
        if (n4 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n4);
    }

    LRESULT WM_VSCROLL(int n2, int n3) {
        LRESULT lRESULT = super.WM_VSCROLL(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.verticalBar != null && (n3 == 0 || n3 == this.handle)) {
            return this.wmScroll(this.verticalBar, (this.state & 2) != 0, this.handle, 277, n2, n3);
        }
        return lRESULT;
    }

    LRESULT wmScroll(ScrollBar scrollBar, boolean bl2, int n2, int n3, int n4, int n5) {
        LRESULT lRESULT = null;
        if (bl2) {
            int n6 = n3 == 276 ? 0 : 1;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 21;
            OS.GetScrollInfo(n2, n6, sCROLLINFO);
            sCROLLINFO.fMask = 4;
            int n7 = n4 & 0xFFFF;
            switch (n7) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                    break;
                }
                case 6: {
                    sCROLLINFO.nPos = sCROLLINFO.nMin;
                    break;
                }
                case 7: {
                    sCROLLINFO.nPos = sCROLLINFO.nMax;
                    break;
                }
                case 1: {
                    sCROLLINFO.nPos += scrollBar.getIncrement();
                    break;
                }
                case 0: {
                    int n8 = scrollBar.getIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n8);
                    break;
                }
                case 3: {
                    sCROLLINFO.nPos += scrollBar.getPageIncrement();
                    break;
                }
                case 2: {
                    int n9 = scrollBar.getPageIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n9);
                }
            }
            OS.SetScrollInfo(n2, n6, sCROLLINFO, true);
        } else {
            int n10 = this.callWindowProc(n2, n3, n4, n5);
            lRESULT = n10 == 0 ? LRESULT.ZERO : new LRESULT(n10);
        }
        scrollBar.wmScrollChild(n4, n5);
        return lRESULT;
    }
}

