/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.internal;

import org.apache.juli.logging.Log;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;

public class JuliLogger
implements Log {
    public static final String JULI_FQCN = JuliLogger.class.getName();
    private PaxLogger m_delegate;

    public JuliLogger(PaxLogger delegate) {
        this.m_delegate = delegate;
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public void trace(Object message) {
        if (message != null) {
            this.m_delegate.trace(message.toString(), null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (message != null) {
            this.m_delegate.trace(message.toString(), t);
        } else {
            this.m_delegate.trace(null, t);
        }
    }

    public void debug(Object message) {
        if (message != null) {
            this.m_delegate.debug(message.toString(), null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (message != null) {
            this.m_delegate.debug(message.toString(), t);
        } else {
            this.m_delegate.debug(null, t);
        }
    }

    public void info(Object message) {
        if (message != null) {
            this.m_delegate.inform(message.toString(), null);
        }
    }

    public void info(Object message, Throwable t) {
        if (message != null) {
            this.m_delegate.inform(message.toString(), null);
        }
    }

    public void warn(Object message) {
        if (message != null) {
            this.m_delegate.warn(message.toString(), null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (message != null) {
            this.m_delegate.warn(message.toString(), t);
        } else {
            this.m_delegate.warn(null, t);
        }
    }

    public void error(Object message) {
        if (message != null) {
            this.m_delegate.error(message.toString(), null);
        }
    }

    public void error(Object message, Throwable t) {
        if (message != null) {
            this.m_delegate.error(message.toString(), t);
        } else {
            this.m_delegate.error(null, t);
        }
    }

    public void fatal(Object message) {
        if (message != null) {
            this.m_delegate.fatal(message.toString(), null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (message != null) {
            this.m_delegate.fatal(message.toString(), t);
        } else {
            this.m_delegate.fatal(null, t);
        }
    }

    public int getLogLevel() {
        return this.m_delegate.getLogLevel();
    }

    public void setPaxLoggingManager(PaxLoggingManager paxLoggingManager, String name) {
        this.m_delegate = paxLoggingManager.getLogger(name, JULI_FQCN);
    }
}

