/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui;

import com.jidesoft.gantt.GanttChartPane;
import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.gaia.dialogs.ApplicationPane;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.printing.service.GenericPrintable;
import com.thinkbuzan.gaia.printing.service.MindMapPrintable;
import com.thinkbuzan.gaia.printing.service.MultiPagePrintable;
import com.thinkbuzan.gaia.printing.service.PrintableObject;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.service.ProjectManagementPrintableFactory;
import com.thinkbuzan.gaia.printing.service.model.PageRange;
import com.thinkbuzan.gaia.printing.service.model.PrintServiceAttribute;
import com.thinkbuzan.gaia.printing.ui.PrintDialog;
import com.thinkbuzan.gaia.printing.ui.components.MindMapRangePanel;
import com.thinkbuzan.gaia.printing.ui.components.PreviewPanel;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import com.thinkbuzan.gaia.printing.ui.osgi.Activator;
import com.thinkbuzan.pascal.services.editor.listeners.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import javax.print.attribute.standard.MediaSize;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MindMapPrintDialog
extends PrintDialog {
    private static final long serialVersionUID = -725997065423714436L;
    private static final Logger LOGGER = Logger.getLogger(MindMapPrintDialog.class);
    private transient MultiPagePrintable multiprint;
    private final transient GenericPrintable mindMapPrintable = (GenericPrintable)this.getPrintable();
    private transient GenericPrintable ganttPrintable;
    private transient GenericPrintable tablePrintable;
    private transient JCheckBox printMindMapCheckbox;
    private transient JCheckBox printGanttCheckbox;
    private transient JCheckBox printTableCheckobx;
    private transient MindMapRangePanel rangePanel;
    private transient JPanel printableSelections;
    private JPanel backgroundPanel;

    public MindMapPrintDialog(PrintingService printServiceIn, MindMapPrintable printableObjectIn, final IEditorComponent editor, Frame parentIn) {
        super(printServiceIn, (PrintableObject)printableObjectIn, parentIn);
        this.multiprint.appendPrintable(this.mindMapPrintable);
        ProjectManagementPrintableFactory factory = Activator.getProjectManagmentPrintableFactory();
        if (factory != null) {
            GanttChartPane ganttComponent = factory.getGanttComponent(editor);
            this.ganttPrintable = factory.getGanttPrintable(ganttComponent);
            this.tablePrintable = factory.getTablePrintable(ganttComponent);
            this.multiprint.appendPrintable(this.ganttPrintable);
            this.multiprint.appendPrintable(this.tablePrintable);
            this.updatePrintableSettings();
        } else {
            this.printGanttCheckbox.setEnabled(false);
            this.printTableCheckobx.setEnabled(false);
        }
        this.printMindMapCheckbox.setSelected(true);
        this.printGanttCheckbox.setSelected(false);
        this.printTableCheckobx.setSelected(false);
        this.updatePrintablesVisibility();
        ActionListener printableChangeListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MindMapPrintDialog.this.printableChangedImpl(evt);
            }
        };
        this.printMindMapCheckbox.addActionListener(printableChangeListener);
        this.printGanttCheckbox.addActionListener(printableChangeListener);
        this.printTableCheckobx.addActionListener(printableChangeListener);
        final SelectionListener listener = new SelectionListener(){

            public void selectionChanged(Object ... selComps) {
                MindMapPrintDialog.this.rangePanel.updateSelectionRadio(selComps != null && selComps.length > 0);
            }
        };
        editor.addSelectionListener(listener);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                editor.removeSelectionListener(listener);
                super.windowClosing(e);
            }
        });
        if ("com.thinkbuzan.phoenix.view.BrainstormView".equalsIgnoreCase(editor.getView().getId())) {
            this.printableSelections.setVisible(false);
            this.rangePanel.setVisible(false);
            this.backgroundPanel.setVisible(true);
        } else {
            this.printableSelections.setVisible(true);
            this.rangePanel.updateSelectionRadio(editor.getAllSelectionCells() != null && !editor.getAllSelectionCells().isEmpty());
            this.rangePanel.setVisible(true);
            this.backgroundPanel.setVisible(false);
        }
        boolean project = editor.getMapMetaData().isProjectMap();
        this.printGanttCheckbox.setVisible(project);
        this.printTableCheckobx.setVisible(project);
    }

    private void updatePrintableSettings() {
        PrintServiceAttribute printAttributes = this.getPrintService().getPrintAttributes();
        PageFormat pageFormat = printAttributes.createPageFormat(this.getPrintService().getPrintAttributes().getPrintService());
        if (this.ganttPrintable != null) {
            this.ganttPrintable.setPageFormat(pageFormat);
            this.ganttPrintable.setWaterMarkTool(this.mindMapPrintable.getWaterMarkTool());
            this.ganttPrintable.setHeader(this.mindMapPrintable.getHeader());
            this.ganttPrintable.setFooter(this.mindMapPrintable.getFooter());
        }
        if (this.tablePrintable != null) {
            this.tablePrintable.setPageFormat(pageFormat);
            this.tablePrintable.setWaterMarkTool(this.mindMapPrintable.getWaterMarkTool());
            this.tablePrintable.setHeader(this.mindMapPrintable.getHeader());
            this.tablePrintable.setFooter(this.mindMapPrintable.getFooter());
        }
        this.getPreviewPanel().repaint();
    }

    public final void pageSettingsUpdated() {
        this.updatePrintableSettings();
        super.pageSettingsUpdated();
    }

    protected final void printableChangedImpl(ActionEvent event) {
        if (!(this.printMindMapCheckbox.isSelected() || this.printGanttCheckbox.isSelected() || this.printTableCheckobx.isSelected())) {
            JCheckBox source = (JCheckBox)event.getSource();
            source.setSelected(true);
        }
        this.updatePrintablesVisibility();
    }

    private void updatePrintablesVisibility() {
        this.multiprint.clearPrintables();
        if (this.printMindMapCheckbox.isSelected()) {
            this.multiprint.appendPrintable(this.mindMapPrintable);
        }
        if (this.printGanttCheckbox.isSelected()) {
            this.multiprint.appendPrintable(this.ganttPrintable);
        }
        if (this.printTableCheckobx.isSelected()) {
            this.multiprint.appendPrintable(this.tablePrintable);
        }
        this.getPreviewPanel().updatePreview();
    }

    protected final PreviewPanel createPreviewPanel() {
        if (this.multiprint == null) {
            this.multiprint = new MultiPagePrintable();
        }
        return new PreviewPanel((Pageable)this.multiprint);
    }

    protected final void printAction() {
        this.applyAction();
        try {
            LOGGER.warn((Object)"Printing");
            LOGGER.warn((Object)("  service          :: " + this.getPrintService().getPrintAttributes().getPrintService()));
            try {
                if (this.getPrintService().getPrintAttributes().getMediaSizeName() != null) {
                    MediaSize size = MediaSize.getMediaSizeForName(this.getPrintService().getPrintAttributes().getMediaSizeName());
                    this.getPrintService().getPrintAttributes().setMediaSize(size);
                }
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"couldn't look up media size from name ");
            }
            LOGGER.warn((Object)("  media size       :: " + this.getPrintService().getPrintAttributes().getMediaSize()));
            LOGGER.warn((Object)("  media size name  :: " + this.getPrintService().getPrintAttributes().getMediaSizeName()));
            LOGGER.warn((Object)("  media tray       :: " + this.getPrintService().getPrintAttributes().getMediaTray()));
            LOGGER.warn((Object)("  margins          :: " + this.getPrintService().getPrintAttributes().getMargins()));
            LOGGER.warn((Object)("  orientation      :: " + this.getPrintService().getPrintAttributes().getOrientation()));
            LOGGER.warn((Object)("  copies           :: " + this.getPrintService().getPrintAttributes().getCopies()));
            if (this.multiprint.isCurrentPagePrintable()) {
                this.getPrintService().print((Pageable)this.multiprint, this.getPreviewPanel().getCurrentPageNumber());
            } else {
                this.getPrintService().print((Pageable)this.multiprint, -1);
            }
        }
        catch (PrinterException exc) {
            ApplicationPane.showErrorMessage((Component)((Object)this), (String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.couldnotprintMessage"), (String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.couldnotprintTitle"));
        }
        this.setVisible(false);
        this.dispose();
    }

    protected final void initView() {
        super.initView();
        this.getPageRangePanel().addPageRangeChangedListener(new ActionListener(){
            private transient PageRange.PageRangeType previoustype = PageRange.PageRangeType.ALL;

            public final void actionPerformed(ActionEvent evt) {
                PageRange range = MindMapPrintDialog.this.getPageRangePanel().getPageRange(MindMapPrintDialog.this.getPreviewPanel().getCurrentPageNumber() - 1);
                MindMapPrintDialog.this.multiprint.setPageRange(range);
                if (PageRange.PageRangeType.CURRENT.equals((Object)range.getPageRangeType()) && PageRange.PageRangeType.CUSTOM.equals((Object)this.previoustype)) {
                    MindMapPrintDialog.this.getPreviewPanel().resetPageNumber();
                }
                this.previoustype = range.getPageRangeType();
                MindMapPrintDialog.this.getPreviewPanel().updatePreview();
            }
        });
        this.rangePanel = new MindMapRangePanel(((MindMapPrintable)this.getPrintable()).getPrintRange());
        this.rangePanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MindMapPrintable.PrintRange printRange = MindMapPrintDialog.this.rangePanel.getPrintRange();
                ((MindMapPrintable)MindMapPrintDialog.this.getPrintable()).setPrintRange(printRange);
                MindMapPrintDialog.this.printableChangedImpl(evt);
                MindMapPrintDialog.this.getScalePanel().setEnabled(printRange == MindMapPrintable.PrintRange.MAP);
                MindMapPrintDialog.this.getPreviewPanel().updatePreview();
            }
        });
        this.backgroundPanel = new JPanel(new BorderLayout());
        this.backgroundPanel.setOpaque(false);
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        final JCheckBox check = new JCheckBox(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.background"));
        check.setOpaque(false);
        this.printMindMapCheckbox = CoreUIFactory.createCheckBox((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printmap"));
        this.printMindMapCheckbox.setOpaque(false);
        this.printGanttCheckbox = CoreUIFactory.createCheckBox((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printgantt"));
        this.printGanttCheckbox.setOpaque(false);
        this.printTableCheckobx = CoreUIFactory.createCheckBox((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printtable"));
        this.printTableCheckobx.setOpaque(false);
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (Exception exc) {
            // empty catch block
        }
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MindMapPrintable)MindMapPrintDialog.this.getPrintable()).setBackgroundPainted(check.isSelected());
                ((MindMapPrintable)MindMapPrintDialog.this.getPrintable()).setFillPage(check.isSelected());
                MindMapPrintDialog.this.getPreviewPanel().updatePreview();
            }
        });
        this.backgroundPanel.add((Component)check, "West");
        this.backgroundPanel.setVisible(false);
        if (this.getPrintable() instanceof MindMapPrintable) {
            check.setSelected(((MindMapPrintable)this.getPrintable()).isBackgroundPainted());
        }
        this.getSettingPanel().add(Box.createVerticalStrut(8));
        this.getSettingPanel().add(this.backgroundPanel);
        this.getSettingPanel().add(this.rangePanel);
        JPanel choosePrintable = new JPanel();
        choosePrintable.setOpaque(false);
        choosePrintable.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        choosePrintable.setLayout(new BoxLayout(choosePrintable, 1));
        choosePrintable.add(this.printMindMapCheckbox);
        choosePrintable.add(this.printGanttCheckbox);
        choosePrintable.add(this.printTableCheckobx);
        this.getSettingPanel().add(Box.createVerticalStrut(2));
        this.printableSelections = new JPanel(new BorderLayout());
        this.printableSelections.setOpaque(false);
        this.printableSelections.add(choosePrintable);
        this.getSettingPanel().add(this.printableSelections);
    }
}

