/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.ui.core.win.component.DialogButton;
import com.thinkbuzan.apollo.ui.core.win.component.ModalDialog;
import com.thinkbuzan.gaia.dialogs.ApplicationPane;
import com.thinkbuzan.gaia.printing.service.MultiPagePrintable;
import com.thinkbuzan.gaia.printing.service.PageListener;
import com.thinkbuzan.gaia.printing.service.PrintableObject;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.service.model.PageRange;
import com.thinkbuzan.gaia.printing.service.model.PrintServiceAttribute;
import com.thinkbuzan.gaia.printing.ui.PrintSettingsDialog;
import com.thinkbuzan.gaia.printing.ui.components.CopiesPanel;
import com.thinkbuzan.gaia.printing.ui.components.PageRangePanel;
import com.thinkbuzan.gaia.printing.ui.components.PreviewPanel;
import com.thinkbuzan.gaia.printing.ui.components.PrinterSelectPanel;
import com.thinkbuzan.gaia.printing.ui.components.ScalePanel;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import com.thinkbuzan.gaia.printing.ui.utils.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PrintDialog
extends ModalDialog {
    protected static final long serialVersionUID = -7441742291806480563L;
    private static final Logger LOGGER = Logger.getLogger(PrintDialog.class);
    private static final int DIALOG_HEIGHT = 620;
    private static final int DIALOG_HEIGHT_MAC = 700;
    private static final int DIALOG_WIDTH = 900;
    private static final int PREVIEW_MIN_SIZE = 200;
    private static final Dimension VERTICAL_RIGID_AREA_SPACING = new Dimension(0, 15);
    private static final int BASE_BUTTONS_PADDING = 10;
    private final transient PrintingService printService;
    private final transient PrintableObject printable;
    private transient PrinterSelectPanel printerSelectPane;
    private transient CopiesPanel copiesPanel;
    private transient ScalePanel scalePanel;
    private transient JPanel settingPanel;
    private transient PreviewPanel previewPanel;
    private transient PageRangePanel pageRangePanel;

    public PrintDialog(PrintingService printServiceIn, PrintableObject printableObjectIn, Frame parentIn) {
        super(parentIn, PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.maintitle"));
        Validator.validateNotNull(printServiceIn, "param printing service can not be null");
        Validator.validateNotNull(printableObjectIn, "param printableObjectIn can not be null");
        this.printService = printServiceIn;
        this.printable = printableObjectIn;
        this.getPrintable().setPageFormat(printServiceIn.getPrintAttributes().createPageFormat(this.getPrintService().getPrintAttributes().getPrintService()));
        this.initView();
        this.setDefaultCloseOperation(2);
        if (SystemInfo.isAnyMac()) {
            Locale userLocale = PrintingUII18N.getI18n().getUserLocale();
            if (userLocale != null && (userLocale.toString().contains(Locale.JAPAN.toString()) || userLocale.toString().contains(Locale.JAPANESE.toString()))) {
                this.setPreferredSize(new Dimension(900, 700));
            } else {
                this.setPreferredSize(new Dimension(900, 620));
            }
            this.setUndecorated(false);
        } else {
            this.setPreferredSize(new Dimension(900, 620));
        }
        this.pack();
    }

    protected void initView() {
        int hOffset = 15;
        int vOffset = 5;
        this.printerSelectPane = this.createPrinterSelectsPanel();
        this.copiesPanel = this.createCopiesPanel();
        this.scalePanel = new ScalePanel();
        this.scalePanel.setSelectedScale(this.getPrintable().getScaleMode());
        this.scalePanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evnt) {
                PrintDialog.this.getPrintable().setScaleMode(PrintDialog.this.getScalePanel().getScaleMode());
                PrintDialog.this.getPreviewPanel().updatePreview();
            }
        });
        this.pageRangePanel = new PageRangePanel();
        this.pageRangePanel.setSelectedRange(PageRange.PageRangeType.ALL);
        this.settingPanel = new JPanel();
        this.settingPanel.setOpaque(false);
        this.settingPanel.setLayout(new BoxLayout(this.settingPanel, 1));
        this.settingPanel.add(this.printerSelectPane);
        this.settingPanel.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.settingPanel.add(this.copiesPanel);
        this.settingPanel.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.settingPanel.add(this.scalePanel);
        this.settingPanel.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.settingPanel.add(this.pageRangePanel);
        this.settingPanel.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.previewPanel = this.createPreviewPanel();
        this.previewPanel.setMinimumSize(new Dimension(200, 200));
        this.previewPanel.setPreferredSize(new Dimension(200, 200));
        this.getPrintable().addPageListener(new PageListener(){

            public void numberOfPagesChanged() {
                PrintDialog.this.getPreviewPanel().updatePreview();
            }
        });
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setOpaque(false);
        leftPanel.add((Component)this.getSettingPanel(), "North");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setOpaque(false);
        rightPanel.add((Component)this.getPreviewPanel(), "Center");
        rightPanel.add(this.createControlsButtons(), "South");
        JPanel outerPanel = new JPanel(new BorderLayout(15, 5));
        outerPanel.setOpaque(false);
        outerPanel.add((Component)leftPanel, "West");
        outerPanel.add((Component)rightPanel, "Center");
        this.setContent(outerPanel);
    }

    protected final Component createControlsButtons() {
        DialogButton pageSetupButton = this.createDialogButton(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printpreview.pagesetup"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintDialog.this.applyAction();
                PrintDialog.this.createPageSettingsDialog().setVisible(true);
                PrintDialog.this.pageSettingsUpdated();
            }
        }, DialogButton.DialogButtonColour.brightGrey);
        JPanel wrappedPageSetupButton = this.wrapButton(pageSetupButton);
        DialogButton printButton = this.createDialogButton(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.button.print"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintDialog.this.printAction();
            }
        }, DialogButton.DialogButtonColour.brightGreen);
        JPanel wrappedPrintButton = this.wrapButton(printButton);
        DialogButton cancelButton = this.createDialogButton(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.button.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintDialog.this.closeAction();
            }
        }, DialogButton.DialogButtonColour.brightRed);
        JPanel wrappedCancelButton = this.wrapButton(cancelButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setOpaque(false);
        buttonsPanel.setLayout(new BorderLayout());
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        JPanel leftButtonsPanel = new JPanel();
        leftButtonsPanel.setOpaque(false);
        leftButtonsPanel.setLayout(new BoxLayout(leftButtonsPanel, 0));
        leftButtonsPanel.add(wrappedPageSetupButton);
        JPanel rightButtonsPanel = new JPanel();
        rightButtonsPanel.setOpaque(false);
        rightButtonsPanel.setLayout(new BoxLayout(rightButtonsPanel, 0));
        rightButtonsPanel.add(wrappedPrintButton);
        rightButtonsPanel.add(wrappedCancelButton);
        buttonsPanel.add((Component)leftButtonsPanel, "West");
        buttonsPanel.add((Component)rightButtonsPanel, "East");
        return buttonsPanel;
    }

    private DialogButton createDialogButton(String label, ActionListener buttonClicked, DialogButton.DialogButtonColour buttonColour) {
        DialogButton button = new DialogButton(label, buttonClicked, buttonColour);
        button.setBorder(BorderFactory.createEmptyBorder());
        return button;
    }

    private JPanel wrapButton(DialogButton button) {
        return this.wrapButton(button, true, true);
    }

    private JPanel wrapButton(DialogButton button, boolean includeLeftMargin, boolean includeRightMargin) {
        int leftMargin = true == includeLeftMargin ? 10 : 0;
        int rightMargin = true == includeRightMargin ? 10 : 0;
        JPanel wrapper = new JPanel();
        wrapper.setOpaque(false);
        wrapper.setLayout(new BorderLayout());
        wrapper.setBorder(BorderFactory.createEmptyBorder(10, leftMargin, 10, rightMargin));
        wrapper.add((Component)button, "Center");
        return wrapper;
    }

    protected final PrinterSelectPanel createPrinterSelectsPanel() {
        return new PrinterSelectPanel(this.getPrintService());
    }

    protected final CopiesPanel createCopiesPanel() {
        return new CopiesPanel(this.getPrintService());
    }

    protected final void applyAction() {
        PrintServiceAttribute printAttributes = this.getPrintService().getPrintAttributes();
        printAttributes.setCollate(this.copiesPanel.isCollate());
        printAttributes.setCopies(this.copiesPanel.getCopies().intValue());
        this.getPrintable().setScaleMode(this.getScalePanel().getScaleMode());
    }

    protected void printAction() {
        this.applyAction();
        try {
            if (this.getPrintable() instanceof MultiPagePrintable && ((MultiPagePrintable)this.getPrintable()).isCurrentPagePrintable()) {
                this.getPrintService().print(this.getPrintable(), this.getPreviewPanel().getCurrentPageNumber());
            } else {
                this.getPrintService().print(this.getPrintable(), -1);
            }
        }
        catch (PrinterException exc) {
            LOGGER.error((Object)"printing failed", (Throwable)exc);
            ApplicationPane.showErrorMessage((Component)((Object)this), (String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.couldnotprintMessage"), (String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.couldnotprintTitle"));
        }
        this.setVisible(false);
        this.dispose();
    }

    public final void closeAction() {
        this.setVisible(false);
        this.dispose();
    }

    public void pageSettingsUpdated() {
        this.getPreviewPanel().repaint();
    }

    protected final PrintSettingsDialog createPageSettingsDialog() {
        return new PrintSettingsDialog(this, this.getPrintService(), this.getPrintable());
    }

    protected PreviewPanel createPreviewPanel() {
        return new PreviewPanel((Pageable)this.getPrintable());
    }

    protected final PrintingService getPrintService() {
        return this.printService;
    }

    protected final PrintableObject getPrintable() {
        return this.printable;
    }

    protected final ScalePanel getScalePanel() {
        return this.scalePanel;
    }

    protected final JPanel getSettingPanel() {
        return this.settingPanel;
    }

    protected final PreviewPanel getPreviewPanel() {
        return this.previewPanel;
    }

    protected final PageRangePanel getPageRangePanel() {
        return this.pageRangePanel;
    }
}

