/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui;

import com.thinkbuzan.apollo.ui.core.win.component.ModalDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.PrintableObject;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.service.model.HeaderFooter;
import com.thinkbuzan.gaia.printing.service.model.PrintServiceAttribute;
import com.thinkbuzan.gaia.printing.ui.PrintDialog;
import com.thinkbuzan.gaia.printing.ui.components.HeaderFooterPanel;
import com.thinkbuzan.gaia.printing.ui.components.MarginsPanel;
import com.thinkbuzan.gaia.printing.ui.components.OrientationPane;
import com.thinkbuzan.gaia.printing.ui.components.PaperPanel;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrintSettingsDialog
extends ModalDialog {
    private static final long serialVersionUID = 2036147516314608226L;
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private transient OrientationPane orientationPane;
    private transient MarginsPanel marginsPane;
    private transient HeaderFooterPanel headerPanel;
    private transient HeaderFooterPanel footerPanel;
    private transient PaperPanel paperPane;
    private static final Dimension DIALOG_DIMENSION = new Dimension(900, 500);
    private final transient PrintingService printService;
    private final transient PrintableObject printable;
    private final PrintDialog printDialog;

    public PrintSettingsDialog(PrintDialog parent, PrintingService printingService, PrintableObject printableIn) {
        super(MainFrameUtilities.getMainFrame(), PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pagesetup"));
        this.setMinimumSize(DIALOG_DIMENSION);
        this.setLocationRelativeTo((Component)((Object)parent));
        this.printService = printingService;
        this.printable = printableIn;
        this.printDialog = parent;
        this.initView();
        this.pack();
    }

    private void initView() {
        this.paperPane = new PaperPanel(this.printService);
        this.orientationPane = new OrientationPane();
        this.orientationPane.setOrientation(this.printService.getPrintAttributes().createPageFormat(this.printService.getPrintAttributes().getPrintService()).getOrientation());
        this.marginsPane = new MarginsPanel();
        this.marginsPane.setMargins(this.printService.getPrintAttributes().getMargins());
        JPanel outerPanel = new JPanel(new GridLayout(2, 1), false);
        outerPanel.setOpaque(false);
        JPanel row1Panel = new JPanel(new GridLayout(1, 3), false);
        row1Panel.setOpaque(false);
        JPanel col1Panel = new JPanel();
        col1Panel.setLayout(new BorderLayout());
        col1Panel.setOpaque(false);
        col1Panel.add((Component)this.paperPane, "North");
        JPanel col3Panel = new JPanel();
        col3Panel.setLayout(new BorderLayout());
        col3Panel.setOpaque(false);
        col3Panel.add((Component)this.marginsPane, "North");
        row1Panel.add(col1Panel);
        row1Panel.add(this.orientationPane);
        row1Panel.add(col3Panel);
        outerPanel.add(row1Panel);
        outerPanel.add(this.getHeaderAndFooterPanel());
        this.setContent(outerPanel);
        this.addButtons();
    }

    private JPanel getHeaderAndFooterPanel() {
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(0, 0, 0));
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.headerandfooter"));
        titleLabel.setAlignmentX(0.0f);
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        panel.add(titlePanel);
        Font defaultHeaderFont = new Font(null, 1, 32);
        this.headerPanel = new HeaderFooterPanel(defaultHeaderFont, PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.header"));
        if (this.printable.getHeader() != null) {
            this.headerPanel.setHeaderFooter(this.printable.getHeader());
        }
        panel.add(this.headerPanel);
        Font defaultFooterFont = new Font(null, 0, 16);
        this.footerPanel = new HeaderFooterPanel(defaultFooterFont, PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.footer"));
        if (this.printable.getFooter() != null) {
            this.footerPanel.setHeaderFooter(this.printable.getFooter());
        }
        panel.add(this.footerPanel);
        return panel;
    }

    private void addButtons() {
        this.createOKButton();
        this.createCancelButton();
    }

    private void createOKButton() {
        this.addConfirmActionListener(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.button.ok"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintSettingsDialog.this.applyAction();
                PrintSettingsDialog.this.setVisible(false);
                PrintSettingsDialog.this.dispose();
            }
        });
    }

    private void createCancelButton() {
        this.addDeclineActionListener(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.button.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintSettingsDialog.this.setVisible(false);
                PrintSettingsDialog.this.dispose();
            }
        });
    }

    private void applyAction() {
        PrintServiceAttribute printAttributes = this.printService.getPrintAttributes();
        printAttributes.setMediaSizeName(this.paperPane.getMediaSizeName());
        printAttributes.setOrientation(this.orientationPane.getOrientation());
        printAttributes.setMargins(this.marginsPane.getMargins());
        printAttributes.setMediaTray(this.paperPane.getMediaTray());
        this.printable.setHeader(this.getHeader());
        this.printable.setFooter(this.getFooter());
        this.printable.setPageFormat(printAttributes.createPageFormat(this.printService.getPrintAttributes().getPrintService()));
        this.printDialog.pageSettingsUpdated();
    }

    public final HeaderFooter getHeader() {
        return this.headerPanel.getHeaderFooter();
    }

    public final HeaderFooter getFooter() {
        return this.footerPanel.getHeaderFooter();
    }
}

