/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CopiesPanel
extends JPanel {
    private static final long serialVersionUID = -1020127010117156002L;
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final Dimension VERTICAL_RIGID_AREA_SPACING = new Dimension(0, 4);
    private static final Dimension COMBO_BOX_DIMENSION = new Dimension(50, 25);
    private transient JComboBox copiesComboBox;
    private transient JCheckBox collateCheckBox;
    private final PrintingService printingService;
    private static final Integer[] COPIES = new Integer[]{1, 2, 3, 4, 5, 10, 20, 30};

    public CopiesPanel(PrintingService printingService) {
        this.printingService = printingService;
        this.initView();
    }

    private final void initView() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.print.copies"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        JPanel copiesPanel = new JPanel(new FlowLayout(0, 0, 0), false);
        copiesPanel.setOpaque(false);
        this.copiesComboBox = new JComboBox<Integer>(COPIES);
        this.copiesComboBox.setOpaque(false);
        this.copiesComboBox.setUI(CoreUIFactory.getComboBoxUI());
        this.copiesComboBox.setMinimumSize(COMBO_BOX_DIMENSION);
        this.copiesComboBox.setMaximumSize(COMBO_BOX_DIMENSION);
        this.copiesComboBox.setPreferredSize(COMBO_BOX_DIMENSION);
        if (!SystemInfo.isAnyMac()) {
            this.copiesComboBox.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.collateCheckBox = CoreUIFactory.createCheckBox((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.print.collate"));
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.collateCheckBox.setOpaque(false);
        this.collateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.copiesComboBox.setEditable(true);
        Component editor = this.copiesComboBox.getEditor().getEditorComponent();
        if (editor instanceof JTextField) {
            final JTextField textEditor = (JTextField)editor;
            textEditor.setDocument(new PlainDocument(){
                private static final long serialVersionUID = 3387526798208277989L;

                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    StringBuilder builder = new StringBuilder(str);
                    for (int i = builder.length() - 1; i >= 0; --i) {
                        int cp = builder.codePointAt(i);
                        if (!Character.isDigit(cp)) {
                            return;
                        }
                        String currentText = textEditor.getText();
                        if (currentText == null || currentText.length() <= 1) continue;
                        return;
                    }
                    super.insertString(offs, str, a);
                }
            });
        }
        this.collateCheckBox.setSelected(this.printingService.getPrintAttributes().isCollate());
        this.printingService.getPrintAttributes().setCopies(1);
        this.copiesComboBox.getEditor().setItem(1);
        this.copiesComboBox.setSelectedIndex(0);
        copiesPanel.add(this.copiesComboBox);
        copiesPanel.add(this.collateCheckBox);
        this.add(copiesPanel);
    }

    public final Integer getCopies() {
        Integer copies;
        String copiesString = this.copiesComboBox.getSelectedItem().toString();
        try {
            copies = Integer.parseInt(copiesString);
        }
        catch (Exception e) {
            copies = 0;
        }
        return copies;
    }

    public final boolean isCollate() {
        return this.collateCheckBox.isSelected();
    }
}

