/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.gaia.printing.service.model.Alignment;
import com.thinkbuzan.gaia.printing.service.model.HeaderFooter;
import com.thinkbuzan.gaia.printing.ui.utils.JFontDialog;
import com.thinkbuzan.gaia.printing.ui.utils.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class HeaderFooterPanel
extends JPanel {
    private static final long serialVersionUID = -5758090520410236211L;
    private transient JTextField tagExpression;
    private transient JComboBox alignmentComboBox;
    private final transient String textName;
    private transient JCheckBox printerHeaderCheckBox;
    private transient Font font;
    private transient Color fontColor = Color.BLACK;
    private transient JButton fontButton;
    private transient JLabel headerFontLabel;

    public HeaderFooterPanel(Font fontIn, String title) {
        if (null != fontIn) {
            this.font = fontIn;
        }
        this.textName = title;
        this.initView();
    }

    private void initView() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.addCheckBoxPane();
        this.addTagExpressionPane();
        this.addAlignmentAndFontPane();
        this.setEnable(false);
    }

    private void addCheckBoxPane() {
        JPanel firstPanel = new JPanel(new FlowLayout(0, 0, 3));
        firstPanel.setOpaque(false);
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.printerHeaderCheckBox = CoreUIFactory.createCheckBox((String)this.textName);
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.printerHeaderCheckBox.setOpaque(false);
        firstPanel.add(this.printerHeaderCheckBox);
        this.add(firstPanel);
        this.printerHeaderCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HeaderFooterPanel.this.printerHeaderCheckBox.isSelected()) {
                    HeaderFooterPanel.this.setEnable(true);
                } else {
                    HeaderFooterPanel.this.setEnable(false);
                }
            }
        });
    }

    private void addTagExpressionPane() {
        JPanel secondPanel = new JPanel(new FlowLayout(1, 0, 5));
        secondPanel.setOpaque(false);
        this.tagExpression = new JTextField();
        Dimension tagExpressionDimension = new Dimension(300, 20);
        this.tagExpression.setPreferredSize(tagExpressionDimension);
        secondPanel.add(this.tagExpression);
        this.add(secondPanel);
    }

    private void addAlignmentAndFontPane() {
        JPanel alignmentAndFontPane = new JPanel(new FlowLayout(0, 0, 0));
        alignmentAndFontPane.setOpaque(false);
        JLabel spaceLabel = new JLabel();
        Dimension spaceDimension = new Dimension(15, 20);
        spaceLabel.setPreferredSize(spaceDimension);
        alignmentAndFontPane.add(spaceLabel);
        Alignment[] alignment = new Alignment[]{Alignment.CENTER, Alignment.LEFT, Alignment.RIGHT};
        this.alignmentComboBox = new JComboBox<Alignment>(alignment);
        this.alignmentComboBox.setUI(CoreUIFactory.getComboBoxUI());
        Dimension alignmentDimension = new Dimension(100, 20);
        this.alignmentComboBox.setPreferredSize(alignmentDimension);
        alignmentAndFontPane.add(this.alignmentComboBox);
        alignmentAndFontPane.add(this.getFontButtonPanel());
        this.add(alignmentAndFontPane);
    }

    private JPanel getFontButtonPanel() {
        JPanel fontPanel = new JPanel(new FlowLayout(0));
        fontPanel.setOpaque(false);
        this.fontButton = new JButton(Util.getIcon("font.gif"));
        this.fontColor = this.fontButton.getForeground();
        Dimension fontDimension = new Dimension(24, 20);
        this.fontButton.setPreferredSize(fontDimension);
        fontPanel.add(this.fontButton);
        this.headerFontLabel = new JLabel(this.font.getSize() + "pt " + this.font.getFamily());
        Dimension fontLabelDimension = new Dimension(200, 20);
        this.headerFontLabel.setPreferredSize(fontLabelDimension);
        fontPanel.add(this.headerFontLabel);
        this.fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font customizedFont = HeaderFooterPanel.this.font;
                JFontDialog fontDialog = new JFontDialog(customizedFont, HeaderFooterPanel.this.fontColor);
                customizedFont = fontDialog.getFont(JOptionPane.getRootFrame());
                fontDialog.setVisible(false);
                fontDialog.dispose();
                HeaderFooterPanel.this.headerFontLabel.setText(customizedFont.getSize() + "pt " + customizedFont.getFamily());
                HeaderFooterPanel.this.font = customizedFont;
                HeaderFooterPanel.this.fontColor = fontDialog.getFontColor();
            }
        });
        return fontPanel;
    }

    private void setEnable(boolean enable) {
        this.tagExpression.setEnabled(enable);
        this.alignmentComboBox.setEnabled(enable);
        this.fontButton.setEnabled(enable);
    }

    public final HeaderFooter getHeaderFooter() {
        if (!this.tagExpression.isEnabled()) {
            return null;
        }
        HeaderFooter headerFooter = new HeaderFooter();
        headerFooter.setColor(this.fontColor);
        headerFooter.setFont(this.font);
        Alignment align = (Alignment)this.alignmentComboBox.getSelectedItem();
        if (align == Alignment.RIGHT) {
            headerFooter.setTextRight(this.tagExpression.getText());
        } else if (align == Alignment.LEFT) {
            headerFooter.setTextLeft(this.tagExpression.getText());
        } else {
            headerFooter.setTextCenter(this.tagExpression.getText());
        }
        return headerFooter;
    }

    public final void setHeaderFooter(HeaderFooter component) {
        this.printerHeaderCheckBox.setSelected(true);
        this.setEnable(true);
        this.font = component.getFont();
        this.headerFontLabel.setText(this.font.getSize() + "pt " + this.font.getFamily());
        this.fontColor = component.getColor();
        if (component.getTextLeft(0) != null && !component.getTextLeft(0).isEmpty()) {
            this.alignmentComboBox.setSelectedItem(Alignment.LEFT);
            this.tagExpression.setText(component.getTextLeft(0));
        } else if (component.getTextRight(0) != null && !component.getTextRight(0).isEmpty()) {
            this.alignmentComboBox.setSelectedItem(Alignment.RIGHT);
            this.tagExpression.setText(component.getTextRight(0));
        } else {
            this.alignmentComboBox.setSelectedItem(Alignment.CENTER);
            this.tagExpression.setText(component.getTextCenter(0));
        }
    }
}

