/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.model.Margins;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import com.thinkbuzan.gaia.printing.ui.utils.Validator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;

public class MarginsPanel
extends JPanel {
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final float MAX_MARGIN = 999.0f;
    private static final long serialVersionUID = -2488117810353938750L;
    private transient JTextField left;
    private transient JTextField right;
    private transient JTextField top;
    private transient JTextField bottom;

    public MarginsPanel() {
        this.initView();
    }

    private void initView() {
        this.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.margins"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        GridBagLayout marginLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(marginLayout);
        int insets = 3;
        int columnNumOfRightText = 4;
        int weightxOfText = 3;
        int columnNumOfRight = 3;
        Locale locale = PrintingUII18N.getI18n().getUserLocale();
        String defaultMargin = Locale.GERMAN.equals(locale) || Locale.GERMANY.equals(locale) ? "0,0" : "0.0";
        DecimalFormat format = new DecimalFormat("##.##");
        format.setMaximumIntegerDigits(2);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(2);
        format.setMinimumIntegerDigits(1);
        format.setParseIntegerOnly(false);
        format.setDecimalSeparatorAlwaysShown(true);
        NumberFormatter nf = new NumberFormatter(format);
        nf.setMinimum(new Float(0.0f));
        nf.setMaximum(new Float(999.0f));
        nf.setAllowsInvalid(true);
        nf.setCommitsOnValidEdit(true);
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)titleLabel, constraints);
        constraints.gridy = 1;
        this.add((Component)new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.margins.left")), constraints);
        this.left = new JFormattedTextField(nf);
        this.left.setText(defaultMargin);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 3.0;
        this.add((Component)this.left, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        JLabel marginRight = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.margins.right"));
        this.right = new JFormattedTextField(nf);
        this.right.setText(defaultMargin);
        this.add((Component)marginRight, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 3.0;
        this.add((Component)this.right, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        JLabel marginTop = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.margins.top"));
        this.top = new JFormattedTextField(nf);
        this.top.setText(defaultMargin);
        this.add((Component)marginTop, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 3.0;
        this.add((Component)this.top, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        JLabel marginBottom = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.margins.bottom"));
        this.bottom = new JFormattedTextField(nf);
        this.bottom.setText(defaultMargin);
        this.add((Component)marginBottom, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 3.0;
        this.add((Component)this.bottom, constraints);
    }

    public final Margins getMargins() {
        Margins margins = new Margins();
        margins.setLeft(Float.parseFloat(this.left.getText().replaceAll(",", ".")));
        margins.setRight(Float.parseFloat(this.right.getText().replaceAll(",", ".")));
        margins.setTop(Float.parseFloat(this.top.getText().replaceAll(",", ".")));
        margins.setBottom(Float.parseFloat(this.bottom.getText().replaceAll(",", ".")));
        return margins;
    }

    public final void setMargins(Margins margins) {
        Validator.validateNotNull(margins, "param margins can not be null");
        this.left.setText(String.valueOf(margins.getLeft()));
        this.right.setText(String.valueOf(margins.getRight()));
        this.top.setText(String.valueOf(margins.getTop()));
        this.bottom.setText(String.valueOf(margins.getBottom()));
    }
}

