/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.MindMapPrintable;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import com.thinkbuzan.gaia.printing.ui.licensing.BundleLicenser;
import com.thinkbuzan.gaia.printing.ui.resources.PrintingUIResourcesManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class MindMapRangePanel
extends JPanel {
    private static final long serialVersionUID = -1020127010117156002L;
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final int NUM_OPTIONS = 5;
    private final transient JRadioButton wholeMapRadio;
    private final transient JRadioButton mainBranchesRadio;
    private final transient JRadioButton floatingIdeasRadio;
    private final transient JRadioButton selectAreaRadio;
    private final transient JRadioButton mapSelectionRadio;
    private final transient MindMapPrintable.PrintRange range;
    private final List<ActionListener> listeners;

    public MindMapRangePanel(MindMapPrintable.PrintRange range) {
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.wholeMapRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printrange.wholemap"));
        this.mainBranchesRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printrange.mainbranche"));
        this.floatingIdeasRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.floatingideas"));
        this.selectAreaRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.selectarea"));
        this.mapSelectionRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.mapselection"));
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.range = range;
        this.listeners = new LinkedList<ActionListener>();
        this.initView();
    }

    private void initView() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.setDoubleBuffered(false);
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printrange"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.wholeMapRadio.setOpaque(false);
        this.mainBranchesRadio.setOpaque(false);
        this.floatingIdeasRadio.setOpaque(false);
        this.selectAreaRadio.setOpaque(false);
        this.mapSelectionRadio.setOpaque(false);
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.setOpaque(false);
        panel.add(this.wholeMapRadio);
        panel.add(this.floatingIdeasRadio);
        panel.add(this.mainBranchesRadio);
        if (BundleLicenser.isPrintSelectAreaLicensed()) {
            panel.add(this.selectAreaRadio);
            panel.add(this.mapSelectionRadio);
        } else {
            panel.add(this.mapSelectionRadio);
            JPanel selectAreaWrapper = new JPanel(new FlowLayout(0, 0, 0));
            selectAreaWrapper.setOpaque(false);
            selectAreaWrapper.add(this.selectAreaRadio);
            selectAreaWrapper.add(new JLabel(new ImageIcon(PrintingUIResourcesManager.getBufferedImage("lock_16.png"))));
            panel.add(selectAreaWrapper);
            this.selectAreaRadio.setEnabled(false);
        }
        this.add((Component)panel, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.wholeMapRadio);
        buttonGroup.add(this.floatingIdeasRadio);
        buttonGroup.add(this.mainBranchesRadio);
        buttonGroup.add(this.selectAreaRadio);
        buttonGroup.add(this.mapSelectionRadio);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MindMapRangePanel.this.notifyChange();
            }
        };
        this.wholeMapRadio.addActionListener(listener);
        this.floatingIdeasRadio.addActionListener(listener);
        this.mainBranchesRadio.addActionListener(listener);
        this.mapSelectionRadio.addActionListener(listener);
        this.selectAreaRadio.addActionListener(listener);
        this.setPrintRange(this.range);
    }

    protected void notifyChange() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public void setPrintRange(MindMapPrintable.PrintRange range) {
        if (range == MindMapPrintable.PrintRange.MAP) {
            this.wholeMapRadio.setSelected(true);
        } else if (range == MindMapPrintable.PrintRange.MAIN_BRANCHES) {
            this.mainBranchesRadio.setSelected(true);
        } else if (range == MindMapPrintable.PrintRange.FLOATING_IDEAS) {
            this.floatingIdeasRadio.setSelected(true);
        } else if (range == MindMapPrintable.PrintRange.SELECTION) {
            this.selectAreaRadio.setSelected(true);
        } else if (range == MindMapPrintable.PrintRange.MAP_SELECTION) {
            this.mapSelectionRadio.setSelected(true);
        } else {
            throw new IllegalStateException("unknown range " + range);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public MindMapPrintable.PrintRange getPrintRange() {
        if (this.wholeMapRadio.isSelected()) {
            return MindMapPrintable.PrintRange.MAP;
        }
        if (this.mainBranchesRadio.isSelected()) {
            return MindMapPrintable.PrintRange.MAIN_BRANCHES;
        }
        if (this.floatingIdeasRadio.isSelected()) {
            return MindMapPrintable.PrintRange.FLOATING_IDEAS;
        }
        if (this.mapSelectionRadio.isSelected()) {
            return MindMapPrintable.PrintRange.MAP_SELECTION;
        }
        return MindMapPrintable.PrintRange.SELECTION;
    }

    public void updateSelectionRadio(boolean enable) {
        this.mapSelectionRadio.setEnabled(enable);
        this.revalidate();
    }
}

