/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.Color;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class OrientationPane
extends JPanel {
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final long serialVersionUID = 6836358047449634911L;
    private transient JRadioButton automaticRadio;
    private transient JRadioButton portraitRadio;
    private transient JRadioButton landscapeRadio;

    public OrientationPane() {
        this.initView();
    }

    private void initView() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager.orientation"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        this.add(titleLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        LookAndFeel previousLF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.automaticRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager.Orientation.automatic"));
        this.portraitRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager.Orientation.portrait"));
        this.landscapeRadio = CoreUIFactory.createRadioButton((String)PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager.Orientation.landscapet"));
        try {
            UIManager.setLookAndFeel(previousLF);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.automaticRadio.setOpaque(false);
        this.add(this.automaticRadio);
        buttonGroup.add(this.automaticRadio);
        this.portraitRadio.setOpaque(false);
        this.add(this.portraitRadio);
        buttonGroup.add(this.portraitRadio);
        this.landscapeRadio.setOpaque(false);
        this.add(this.landscapeRadio);
        buttonGroup.add(this.landscapeRadio);
    }

    public final int getOrientation() {
        if (this.landscapeRadio.isSelected()) {
            return 0;
        }
        if (this.portraitRadio.isSelected()) {
            return 1;
        }
        return 2;
    }

    public final void setOrientation(int orientation) {
        if (orientation == 1) {
            this.portraitRadio.setSelected(true);
        } else if (orientation == 0) {
            this.landscapeRadio.setSelected(true);
        } else {
            this.automaticRadio.setSelected(true);
        }
    }
}

