/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.model.PageRange;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PageRangePanel
extends JPanel {
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final Dimension VERTICAL_RIGID_AREA_SPACING = new Dimension(0, 4);
    private static final int PADDING = 5;
    private final transient List<ActionListener> listeners = new ArrayList<ActionListener>();
    private transient JComboBox rangeType;
    private transient JTextField customRange;
    private transient ActionListener rangeTypeListener;
    private transient DocumentListener customRangeListener;

    public PageRangePanel() {
        this.initView();
        this.initListeners();
    }

    private void initView() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.pageRange"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.rangeType = new JComboBox<PageRange.PageRangeType>(PageRange.PageRangeType.values());
        this.rangeType.setOpaque(false);
        this.rangeType.setUI(CoreUIFactory.getComboBoxUI());
        this.rangeType.setSelectedIndex(0);
        this.add(this.rangeType);
        this.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.customRange = new JTextField();
        this.customRange.setOpaque(false);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.setOpaque(false);
        panel.add((Component)new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.pages") + ":"), "West");
        panel.add((Component)this.customRange, "Center");
        this.add(panel);
    }

    private void initListeners() {
        this.rangeTypeListener = new ActionListener(){

            public final void actionPerformed(ActionEvent evt) {
                if (!PageRange.PageRangeType.CUSTOM.equals(PageRangePanel.this.rangeType.getSelectedItem())) {
                    PageRangePanel.this.customRange.getDocument().removeDocumentListener(PageRangePanel.this.customRangeListener);
                    PageRangePanel.this.customRange.setText("");
                    PageRangePanel.this.customRange.getDocument().addDocumentListener(PageRangePanel.this.customRangeListener);
                }
                PageRangePanel.this.firePageRangeChanged();
            }
        };
        this.customRangeListener = new DocumentListener(){

            public final void removeUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            public final void insertUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            public final void changedUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            private void doUpdate() {
                if (PageRangePanel.this.customRange.getText().trim().equals("")) {
                    this.setSelectedRangeType(PageRange.PageRangeType.ALL);
                } else if (!PageRange.PageRangeType.CUSTOM.equals(PageRangePanel.this.rangeType.getSelectedItem())) {
                    this.setSelectedRangeType(PageRange.PageRangeType.CUSTOM);
                }
                PageRangePanel.this.firePageRangeChanged();
            }

            private void setSelectedRangeType(PageRange.PageRangeType type) {
                PageRangePanel.this.rangeType.removeActionListener(PageRangePanel.this.rangeTypeListener);
                PageRangePanel.this.rangeType.setSelectedItem(type);
                PageRangePanel.this.rangeType.addActionListener(PageRangePanel.this.rangeTypeListener);
            }
        };
        this.rangeType.addActionListener(this.rangeTypeListener);
        this.customRange.getDocument().addDocumentListener(this.customRangeListener);
    }

    public final PageRange getPageRange(int currentPage) {
        PageRange range;
        Object selection = this.rangeType.getSelectedItem();
        PageRange.PageRangeType selectedType = selection instanceof PageRange.PageRangeType ? (PageRange.PageRangeType)selection : PageRange.PageRangeType.ALL;
        switch (selectedType) {
            case CUSTOM: {
                range = PageRange.decodeCustomRange((String)this.customRange.getText());
                break;
            }
            case CURRENT: {
                range = new PageRange(PageRange.PageRangeType.CURRENT, null);
                break;
            }
            default: {
                range = new PageRange(PageRange.PageRangeType.ALL, null);
            }
        }
        return range;
    }

    public final void setSelectedRange(PageRange.PageRangeType range) {
        this.rangeType.removeActionListener(this.rangeTypeListener);
        this.rangeType.setSelectedItem(range);
        this.rangeType.addActionListener(this.rangeTypeListener);
        if (!PageRange.PageRangeType.CUSTOM.equals((Object)range)) {
            this.customRange.getDocument().removeDocumentListener(this.customRangeListener);
            this.customRange.setText("");
            this.customRange.getDocument().addDocumentListener(this.customRangeListener);
        }
    }

    public final void addPageRangeChangedListener(ActionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public final void removePageRangeChangedListener(ActionListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void firePageRangeChanged() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, null));
        }
    }
}

