/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.service.model.PrintServiceAttribute;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaperPanel
extends JPanel {
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final long serialVersionUID = 9209599934494104469L;
    private transient JComboBox mediaSizeComboBox;
    private transient JComboBox mediaTrayComboBox;
    private final transient Dimension labelDimension = new Dimension(50, 20);
    private final transient Dimension comboBoxDimension = new Dimension(150, 25);
    private final PrintingService printingService;
    private static final transient Logger LOGGER = Logger.getLogger(PaperPanel.class);

    public PaperPanel(PrintingService service) {
        this.printingService = service;
        this.initView();
        this.setMediaName(service.getPrintAttributes());
        this.setMediaTray(service.getPrintAttributes());
    }

    private void initView() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.setDoubleBuffered(false);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(0, 0, 0));
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.addMediaSizePanel();
        this.addMediaTrayPanel();
    }

    private void addMediaSizePanel() {
        JPanel mediaSizePanel = new JPanel(new FlowLayout(0, 10, 10), false);
        mediaSizePanel.setOpaque(false);
        JLabel sizeLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager.size"));
        sizeLabel.setPreferredSize(this.labelDimension);
        mediaSizePanel.add(sizeLabel);
        Vector names = this.printingService.getPaperSizeItems();
        List<MediaSizeName> nameList = new ArrayList<MediaSizeName>(names);
        nameList = this.processMediaSizeNameList(nameList);
        this.sortAlpha(nameList);
        this.mediaSizeComboBox = new JComboBox<Object>(nameList.toArray());
        this.mediaSizeComboBox.setOpaque(false);
        this.mediaSizeComboBox.setRenderer(new CustomListCellRenderer());
        this.mediaSizeComboBox.setUI(CoreUIFactory.getComboBoxUI());
        this.mediaSizeComboBox.setPreferredSize(this.comboBoxDimension);
        mediaSizePanel.add(this.mediaSizeComboBox);
        this.add(mediaSizePanel);
    }

    private void sortAlpha(List<MediaSizeName> toSort) {
        Collections.sort(toSort, new Comparator<MediaSizeName>(){

            @Override
            public int compare(MediaSizeName o1, MediaSizeName o2) {
                String s1 = PaperPanel.calculateMediaSizeName(o1);
                String s2 = PaperPanel.calculateMediaSizeName(o2);
                return s1.compareTo(s2);
            }
        });
    }

    private List<MediaSizeName> processMediaSizeNameList(List<MediaSizeName> nameList) {
        return nameList;
    }

    private void addMediaTrayPanel() {
        JPanel mediaTrayPanel = new JPanel(new FlowLayout(0, 10, 10), false);
        mediaTrayPanel.setOpaque(false);
        JLabel sourceLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.pager.source"));
        sourceLabel.setPreferredSize(this.labelDimension);
        mediaTrayPanel.add(sourceLabel);
        Vector names = this.printingService.getPaperSourceItems();
        ArrayList nameList = new ArrayList(names);
        this.mediaTrayComboBox = new JComboBox<Object>(nameList.toArray());
        this.mediaTrayComboBox.setPreferredSize(this.comboBoxDimension);
        this.mediaTrayComboBox.setUI(CoreUIFactory.getComboBoxUI());
        mediaTrayPanel.add(this.mediaTrayComboBox);
        this.add(mediaTrayPanel);
    }

    public final void setMediaName(PrintServiceAttribute attribute) {
        if (null == attribute || null == attribute.getMediaSizeName()) {
            return;
        }
        this.mediaSizeComboBox.setSelectedItem(attribute.getMediaSizeName());
    }

    public final MediaSizeName getMediaSizeName() {
        return (MediaSizeName)this.mediaSizeComboBox.getSelectedItem();
    }

    public final void setMediaTray(PrintServiceAttribute attribute) {
        if (null == attribute || null == attribute.getMediaTray()) {
            return;
        }
        this.mediaTrayComboBox.setSelectedItem(attribute.getMediaTray());
    }

    public final MediaTray getMediaTray() {
        if (this.mediaTrayComboBox.getItemCount() == 0) {
            return null;
        }
        return (MediaTray)this.mediaTrayComboBox.getSelectedItem();
    }

    private static String calculateMediaSizeName(MediaSizeName mediaSizeName) {
        return mediaSizeName.toString();
    }

    private static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6480948774165625896L;

        private CustomListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof MediaSizeName) {
                String representation = PaperPanel.calculateMediaSizeName((MediaSizeName)value);
                label.setText(representation);
            }
            return label;
        }
    }
}

