/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.gaia.printing.service.MindMapPrintable;
import com.thinkbuzan.gaia.printing.service.MultiPagePrintable;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicArrowButton;
import org.apache.log4j.Logger;

public class PreviewPanel
extends JPanel {
    private static final BasicStroke MARGINS_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 8.0f}, 0.0f);
    private static final Stroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final long serialVersionUID = 9196691414913250437L;
    private static final Logger LOGGER = Logger.getLogger(PreviewPanel.class);
    private transient Pageable pageable;
    private transient int pageIndex = 0;
    private transient int pagesCount;
    private float scale = 1.0f;
    private transient boolean showMargins = true;
    private final JScrollPane scrollPane;
    private final Preview preview;
    private JFormattedTextField pageTextField;
    private final JLabel pageCountLabel;
    private static final float SCALE_PERCENTAGE = 0.25f;
    private static final float ZOOM_UPPER_LIMIT = 4.0f;
    private static final float ZOOM_LOWER_LIMIT = 0.25f;
    private static final int QUARTER = 4;
    private transient Rectangle2D selectionArea;
    private transient double currentScale;
    private transient double translateX;
    private transient double translateY;
    private transient double innerX;
    private transient double innerY;
    private transient double innerWidth;
    private transient double innerHeight;
    private Rectangle2D.Double paintRegion;
    protected static final int TOP_LEFT = 0;
    protected static final int TOP_RIGHT = 1;
    protected static final int BOTTOM_LEFT = 2;
    protected static final int BOTTOM_RIGHT = 3;
    protected static final int HANDLE_COUNT = 4;
    protected static final int HANDLE_SIZE = 8;

    public final void resetPageNumber() {
        this.pageIndex = 0;
        this.pageTextField.setValue(0);
    }

    public final void updatePreview() {
        int pageCount = this.pageable.getNumberOfPages();
        if (this.pagesCount != pageCount) {
            this.pagesCount = pageCount;
            this.pageIndex = 0;
            this.pageTextField.setValue(this.getCurrentPageNumber());
            this.pageCountLabel.setText(PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.ofpages", new Object[]{this.getPagesCount()}));
        }
        this.revalidate();
        this.repaint();
    }

    public PreviewPanel(Pageable pageableIn) {
        super(new BorderLayout(2, 2));
        this.setOpaque(false);
        this.preview = new Preview();
        this.scrollPane = new JScrollPane(this.preview);
        this.scrollPane.setOpaque(false);
        this.add((Component)this.scrollPane, "Center");
        this.pageable = pageableIn;
        this.pagesCount = this.pageable.getNumberOfPages();
        this.pageCountLabel = new JLabel();
        this.initialiseCommands();
        MouseAdapter listener = this.createMouseListener();
        this.preview.addMouseListener(listener);
        this.preview.addMouseMotionListener(listener);
    }

    private void initialiseCommands() {
        this.pageTextField = new JFormattedTextField((Object)this.getCurrentPageNumber());
        this.pageTextField.setColumns(2);
        this.pageCountLabel.setText(PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.ofpages", new Object[]{this.getPagesCount()}));
        BasicArrowButton previousArrow = new BasicArrowButton(7);
        BasicArrowButton nextArrow = new BasicArrowButton(3);
        JPanel buttonPanel = new JPanel(new FlowLayout(3, 1, 1));
        buttonPanel.setOpaque(false);
        buttonPanel.add(previousArrow);
        buttonPanel.add(this.pageTextField);
        buttonPanel.add(this.pageCountLabel);
        buttonPanel.add(nextArrow);
        this.pageTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.goToPage((Integer)PreviewPanel.this.pageTextField.getValue());
            }
        });
        previousArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.previousPage();
            }
        });
        nextArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.nextPage();
            }
        });
        this.add((Component)buttonPanel, "South");
    }

    public final void previousPage() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"previousPage called");
        }
        if (this.pageIndex > 0) {
            --this.pageIndex;
            this.pageTextField.setValue(this.getCurrentPageNumber());
            this.repaint();
        }
    }

    public final void nextPage() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"nextPage called");
        }
        if (this.pageIndex < this.pagesCount - 1) {
            ++this.pageIndex;
            this.pageTextField.setValue(this.getCurrentPageNumber());
            this.repaint();
        }
    }

    public final void goToPage(int pageNumber) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("goToPage called " + pageNumber));
        }
        if (pageNumber <= this.pagesCount && pageNumber > 0) {
            this.pageIndex = pageNumber - 1;
            this.pageTextField.setValue(this.getCurrentPageNumber());
            this.repaint();
        }
    }

    public final void zoomIn() {
        if (this.scale < 4.0f) {
            this.scale += 0.25f;
            this.preview.revalidate();
            this.repaint();
        }
    }

    public final void zoomOut() {
        if (this.scale > 0.25f) {
            this.scale -= 0.25f;
            this.preview.revalidate();
            this.repaint();
        }
    }

    public final void showMargin(boolean show) {
        this.showMargins = show;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCurrentPage(Graphics g) {
        Printable printable = this.pageable.getPrintable(this.pageIndex);
        boolean userDefined = this.isSelectArea(printable);
        PageFormat pageFormat = this.pageable.getPageFormat(this.pageIndex);
        double width = pageFormat.getWidth();
        double height = pageFormat.getHeight();
        BufferedImage image = new BufferedImage((int)width, (int)height, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics().create();
        Graphics2D regionG = (Graphics2D)image.getGraphics().create();
        try {
            double scaleToFit;
            if (this.pageIndex >= this.pageable.getNumberOfPages()) {
                return;
            }
            Dimension size = this.preview.getSize();
            this.currentScale = scaleToFit = Math.min(size.getWidth() / width, size.getHeight() / height);
            this.translateX = (size.getWidth() - width * scaleToFit) / 2.0;
            this.translateY = (size.getHeight() - height * scaleToFit) / 2.0;
            this.innerX = pageFormat.getImageableX();
            this.innerY = pageFormat.getImageableY();
            this.innerWidth = pageFormat.getImageableWidth();
            this.innerHeight = pageFormat.getImageableHeight();
            g2d.translate(this.translateX, this.translateY);
            g2d.scale(this.currentScale, this.currentScale);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, (int)width, (int)height);
            AffineTransform transform = g2d.getTransform();
            Shape clip = g2d.getClip();
            try {
                if (userDefined) {
                    double paintRegionH;
                    double paintRegionW;
                    double paintRegionY;
                    double paintRegionX;
                    double bScale;
                    Rectangle paintBounds = ((MindMapPrintable)((MultiPagePrintable)printable).getPrintableAt(this.pageIndex)).getPaintBounds();
                    if (this.innerWidth / paintBounds.getWidth() > this.innerHeight / paintBounds.getHeight()) {
                        bScale = this.innerHeight / paintBounds.getHeight();
                        paintRegionX = this.innerX + this.innerWidth / 2.0 - bScale * paintBounds.getWidth() / 2.0;
                        paintRegionY = this.innerY + this.innerHeight / 2.0 - bScale * paintBounds.getHeight() / 2.0;
                        paintRegionW = bScale * paintBounds.getWidth();
                        paintRegionH = bScale * paintBounds.getHeight();
                    } else {
                        bScale = this.innerWidth / paintBounds.getWidth();
                        paintRegionX = this.innerX + this.innerWidth / 2.0 - bScale * paintBounds.getWidth() / 2.0;
                        paintRegionY = this.innerY + this.innerHeight / 2.0 - bScale * paintBounds.getHeight() / 2.0;
                        paintRegionW = bScale * paintBounds.getWidth();
                        paintRegionH = bScale * paintBounds.getHeight();
                    }
                    this.paintRegion = new Rectangle2D.Double(paintRegionX, paintRegionY, paintRegionW, paintRegionH);
                    if (this.selectionArea == null) {
                        this.selectionArea = new Rectangle2D.Double(Math.max(this.paintRegion.getX(), width / 4.0), Math.max(this.paintRegion.getY(), height / 4.0), Math.min(this.paintRegion.getWidth(), width / 2.0), Math.min(this.paintRegion.getHeight(), height / 2.0));
                    }
                    g2d.setClip((int)this.selectionArea.getX(), (int)this.selectionArea.getY(), (int)this.selectionArea.getWidth(), (int)this.selectionArea.getHeight());
                    this.updateSelectionArea(printable, new Rectangle2D.Double((this.selectionArea.getX() - this.paintRegion.getX()) / this.paintRegion.getWidth(), (this.selectionArea.getY() - this.paintRegion.getY()) / this.paintRegion.getHeight(), this.selectionArea.getWidth() / this.paintRegion.getWidth(), this.selectionArea.getHeight() / this.paintRegion.getHeight()));
                    ((MindMapPrintable)((MultiPagePrintable)printable).getPrintableAt(this.pageIndex)).print((Graphics)g2d, pageFormat, this.pageIndex, false);
                    Graphics2D g2d2 = (Graphics2D)g.create();
                    g2d2.setTransform(transform);
                    g2d2.setColor(Color.WHITE);
                    g2d2.drawRect((int)paintRegionX, (int)paintRegionY, (int)paintRegionW, (int)paintRegionH);
                    g2d2.dispose();
                } else {
                    printable.print(g2d, pageFormat, this.pageIndex);
                }
            }
            catch (PrinterException exc) {
                LOGGER.warn((Object)exc);
            }
            if (userDefined) {
                Rectangle2D[] handles;
                regionG.translate(this.translateX, this.translateY);
                regionG.scale(this.currentScale, this.currentScale);
                regionG.setStroke(SELECTION_STROKE);
                regionG.setColor(Color.BLUE);
                regionG.drawRect((int)this.selectionArea.getX(), (int)this.selectionArea.getY(), (int)this.selectionArea.getWidth(), (int)this.selectionArea.getHeight());
                for (Rectangle2D handle : handles = this.getHandles()) {
                    regionG.fillRect((int)handle.getX(), (int)handle.getY(), (int)handle.getWidth(), (int)handle.getHeight());
                }
            } else if (this.showMargins) {
                g2d.setTransform(transform);
                g2d.setClip(clip);
                Color oldColor = g2d.getColor();
                g2d.setColor(Color.RED);
                g2d.setStroke(MARGINS_STROKE);
                g2d.drawRect((int)this.innerX, (int)this.innerY, (int)this.innerWidth, (int)this.innerHeight);
                g2d.setColor(oldColor);
            }
        }
        finally {
            g2d.dispose();
            regionG.dispose();
        }
        try {
            g.drawImage(image, 0, 0, (int)width, (int)height, null);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"failed to paint current page ", (Throwable)ex);
        }
    }

    private boolean isSelectArea(Printable printable) {
        Printable print;
        return printable instanceof MultiPagePrintable && (print = ((MultiPagePrintable)printable).getPrintableAt(this.pageIndex)) instanceof MindMapPrintable && MindMapPrintable.PrintRange.SELECTION.equals((Object)((MindMapPrintable)print).getPrintRange());
    }

    private void updateSelectionArea(Printable printable, Rectangle2D bounds) {
        Printable print;
        if (printable instanceof MultiPagePrintable && (print = ((MultiPagePrintable)printable).getPrintableAt(this.pageIndex)) instanceof MindMapPrintable && MindMapPrintable.PrintRange.SELECTION.equals((Object)((MindMapPrintable)print).getPrintRange())) {
            ((MindMapPrintable)print).setRegion(bounds);
        }
    }

    public final int getCurrentPageNumber() {
        return this.pageIndex + 1;
    }

    public final int getPagesCount() {
        return this.pagesCount;
    }

    protected final Rectangle2D[] getHandles() {
        Rectangle2D[] handles = new Rectangle2D[4];
        double handSixe = 8.0 / this.currentScale;
        double handOff = handSixe / 2.0;
        handles[0] = new Rectangle2D.Double(this.selectionArea.getX() - handOff, this.selectionArea.getY() - handOff, handSixe, handSixe);
        handles[1] = new Rectangle2D.Double(this.selectionArea.getMaxX() - handOff, this.selectionArea.getY() - handOff, handSixe, handSixe);
        handles[3] = new Rectangle2D.Double(this.selectionArea.getMaxX() - 4.0, this.selectionArea.getMaxY() - handOff, handSixe, handSixe);
        handles[2] = new Rectangle2D.Double(this.selectionArea.getX() - handOff, this.selectionArea.getMaxY() - handOff, handSixe, handSixe);
        return handles;
    }

    private MouseAdapter createMouseListener() {
        return new MouseAdapter(){
            private transient boolean userArea = false;
            private transient boolean moving = false;
            private transient int resizing = -1;
            private transient Point2D last;

            public void mouseMoved(MouseEvent e) {
                if (this.userArea) {
                    Point2D.Double lastPoint = new Point2D.Double(((double)e.getX() - PreviewPanel.this.translateX) / PreviewPanel.this.currentScale, ((double)e.getY() - PreviewPanel.this.translateY) / PreviewPanel.this.currentScale);
                    boolean hit = false;
                    Rectangle2D[] handles = PreviewPanel.this.getHandles();
                    for (int handleIndex = 0; handleIndex < handles.length; ++handleIndex) {
                        if (!handles[handleIndex].contains(lastPoint)) continue;
                        hit = true;
                        if (handleIndex == 0) {
                            PreviewPanel.this.setCursor(Cursor.getPredefinedCursor(6));
                            continue;
                        }
                        if (handleIndex == 1) {
                            PreviewPanel.this.setCursor(Cursor.getPredefinedCursor(7));
                            continue;
                        }
                        if (handleIndex == 2) {
                            PreviewPanel.this.setCursor(Cursor.getPredefinedCursor(4));
                            continue;
                        }
                        if (handleIndex != 3) continue;
                        PreviewPanel.this.setCursor(Cursor.getPredefinedCursor(5));
                    }
                    if (!hit) {
                        if (PreviewPanel.this.selectionArea.contains(lastPoint)) {
                            PreviewPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        } else {
                            PreviewPanel.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                } else {
                    PreviewPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (this.userArea && PreviewPanel.this.paintRegion != null) {
                    Point2D.Double lastPoint = new Point2D.Double(((double)e.getX() - PreviewPanel.this.translateX) / PreviewPanel.this.currentScale, ((double)e.getY() - PreviewPanel.this.translateY) / PreviewPanel.this.currentScale);
                    if (this.resizing >= 0) {
                        double diffX;
                        double diffY;
                        double newX = PreviewPanel.this.selectionArea.getX();
                        double newY = PreviewPanel.this.selectionArea.getY();
                        double newW = PreviewPanel.this.selectionArea.getWidth();
                        double newH = PreviewPanel.this.selectionArea.getHeight();
                        double x = ((Point2D)lastPoint).getX();
                        double y = ((Point2D)lastPoint).getY();
                        if (this.resizing == 0) {
                            diffY = newY - y;
                            newY = y;
                            if ((newH += diffY) <= 0.0) {
                                this.resizing = 2;
                            }
                            diffX = newX - x;
                            newX = x;
                            if ((newW += diffX) <= 0.0) {
                                this.resizing = 1;
                            }
                        } else if (this.resizing == 2) {
                            diffY = y - newY;
                            newH = diffY;
                            if (newH <= 0.0) {
                                this.resizing = 0;
                            }
                            diffX = newX - x;
                            newX = x;
                            if ((newW += diffX) <= 0.0) {
                                this.resizing = 3;
                            }
                        } else if (this.resizing == 1) {
                            diffY = newY - y;
                            newY = y;
                            if ((newH += diffY) <= 0.0) {
                                this.resizing = 3;
                            }
                            if ((newW = (diffX = x - newX)) <= 0.0) {
                                this.resizing = 0;
                            }
                        } else if (this.resizing == 3) {
                            diffY = y - newY;
                            newH = diffY;
                            if (newH <= 0.0) {
                                this.resizing = 1;
                            }
                            if ((newW = (diffX = x - newX)) <= 0.0) {
                                this.resizing = 2;
                            }
                        }
                        double minX = Math.min(PreviewPanel.this.paintRegion.getMaxX(), Math.max(PreviewPanel.this.paintRegion.getX(), newX));
                        double minY = Math.min(PreviewPanel.this.paintRegion.getMaxY(), Math.max(PreviewPanel.this.paintRegion.getY(), newY));
                        if (newX < PreviewPanel.this.paintRegion.getX()) {
                            newW += newX - PreviewPanel.this.paintRegion.getX();
                        } else if (newX > PreviewPanel.this.paintRegion.getMaxX()) {
                            newW += PreviewPanel.this.paintRegion.getMaxX() - newX;
                        }
                        if (newY < PreviewPanel.this.paintRegion.getY()) {
                            newH += newY - PreviewPanel.this.paintRegion.getY();
                        } else if (newY > PreviewPanel.this.paintRegion.getMaxY()) {
                            newH += PreviewPanel.this.paintRegion.getMaxY() - newY;
                        }
                        double maxX = Math.min(PreviewPanel.this.paintRegion.getMaxX(), minX + newW);
                        double maxY = Math.min(PreviewPanel.this.paintRegion.getMaxY(), minY + newH);
                        PreviewPanel.this.selectionArea.setRect(minX, minY, maxX - minX, maxY - minY);
                    } else if (this.moving) {
                        double diffX = this.last.getX() - ((Point2D)lastPoint).getX();
                        double diffY = this.last.getY() - ((Point2D)lastPoint).getY();
                        double minX = Math.min(PreviewPanel.this.paintRegion.getMaxX() - PreviewPanel.this.selectionArea.getWidth(), Math.max(PreviewPanel.this.paintRegion.getX(), PreviewPanel.this.selectionArea.getX() - diffX));
                        double minY = Math.min(PreviewPanel.this.paintRegion.getMaxY() - PreviewPanel.this.selectionArea.getHeight(), Math.max(PreviewPanel.this.paintRegion.getY(), PreviewPanel.this.selectionArea.getY() - diffY));
                        double maxX = Math.min(PreviewPanel.this.paintRegion.getMaxX(), minX + PreviewPanel.this.selectionArea.getWidth());
                        double maxY = Math.min(PreviewPanel.this.paintRegion.getMaxY(), minY + PreviewPanel.this.selectionArea.getHeight());
                        PreviewPanel.this.selectionArea.setRect(minX, minY, maxX - minX, maxY - minY);
                    }
                    PreviewPanel.this.preview.repaint();
                    this.last = lastPoint;
                }
            }

            public void mousePressed(MouseEvent e) {
                this.userArea = PreviewPanel.this.isSelectArea(PreviewPanel.this.pageable.getPrintable(PreviewPanel.this.pageIndex));
                if (this.userArea) {
                    this.last = new Point2D.Double(((double)e.getX() - PreviewPanel.this.translateX) / PreviewPanel.this.currentScale, ((double)e.getY() - PreviewPanel.this.translateY) / PreviewPanel.this.currentScale);
                    Rectangle2D[] handles = PreviewPanel.this.getHandles();
                    for (int handleIndex = 0; handleIndex < handles.length; ++handleIndex) {
                        if (!handles[handleIndex].contains(this.last)) continue;
                        this.resizing = handleIndex;
                    }
                    if (this.resizing < 0 && PreviewPanel.this.selectionArea.contains(this.last)) {
                        this.moving = true;
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                this.moving = false;
                this.resizing = -1;
            }

            public void mouseEntered(MouseEvent e) {
                this.userArea = PreviewPanel.this.isSelectArea(PreviewPanel.this.pageable.getPrintable(PreviewPanel.this.pageIndex));
            }
        };
    }

    private class Preview
    extends JPanel {
        private static final long serialVersionUID = -7860683572864033133L;

        public Preview() {
            this.setOpaque(false);
            this.setBackground(Color.WHITE);
        }

        public final void paintComponent(Graphics g) {
            super.paintComponent(g);
            PreviewPanel.this.paintCurrentPage(g);
        }
    }
}

