/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.print.PrintService;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrinterSelectPanel
extends JPanel {
    private static final long serialVersionUID = -6196665270184295917L;
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final Dimension VERTICAL_RIGID_AREA_SPACING = new Dimension(0, 4);
    private final transient JLabel printerStatusJLabel = new JLabel("", 2);
    private final List<String> printerNames;
    private transient JComboBox printerComboBox;
    private final PrintingService printingService;

    public PrinterSelectPanel(PrintingService service) {
        this.printingService = service;
        this.printerNames = service.getAllPrintServicesNameList();
        this.initView();
        this.addPrinterSelectChanageListener();
        this.changePrinter();
    }

    private void initView() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.setDoubleBuffered(false);
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printer"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        JPanel contentPanel = new JPanel(new BorderLayout(), false);
        contentPanel.setOpaque(false);
        String[] array = new String[this.printerNames.size()];
        this.printerNames.toArray(array);
        this.printerComboBox = new JComboBox<String>(array);
        this.printerComboBox.setOpaque(false);
        this.printerComboBox.setUI(CoreUIFactory.getComboBoxUI());
        Dimension preferred = this.printerComboBox.getPreferredSize();
        this.printerComboBox.setPreferredSize(new Dimension(200, preferred.height));
        this.printerComboBox.setMinimumSize(new Dimension(150, preferred.height));
        this.printerComboBox.setMaximumSize(new Dimension(200, preferred.height));
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setOpaque(false);
        namePanel.add((Component)new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printer.name"), 2), "West");
        namePanel.add(this.printerComboBox);
        if (this.printingService.getDefaultPrintService() != null) {
            String defaultName = this.printingService.getDefaultPrintService().getName();
            for (String name : this.printerNames) {
                if (!defaultName.equals(name)) continue;
                this.printerComboBox.setSelectedItem(name);
            }
        }
        contentPanel.add((Component)namePanel, "North");
        JPanel statusPanel = new JPanel(new FlowLayout(3, 1, 0));
        statusPanel.setOpaque(false);
        statusPanel.add(new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.printer.status"), 2));
        statusPanel.add(this.printerStatusJLabel);
        contentPanel.add((Component)statusPanel, "South");
        this.add(contentPanel);
    }

    private void changePrinter() {
        int selectedIdx = this.printerComboBox.getSelectedIndex();
        if (selectedIdx == -1) {
            return;
        }
        PrintService printService = this.printingService.getPrintService(String.valueOf(this.printerComboBox.getSelectedItem()));
        if (printService != null) {
            String printStatus = this.printingService.getPrinterServiceStatus(printService);
            this.printerStatusJLabel.setText(printStatus);
            this.printingService.getPrintAttributes().setPrintService(printService);
        }
    }

    private void addPrinterSelectChanageListener() {
        ItemListener printerSelectChanageListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PrinterSelectPanel.this.changePrinter();
                }
            }
        };
        this.printerComboBox.addItemListener(printerSelectChanageListener);
    }

    public final String getSelectedPrinterName() {
        String printerName = this.printerComboBox.getSelectedItem() instanceof String ? (String)this.printerComboBox.getSelectedItem() : null;
        return printerName;
    }
}

