/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.components;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.printing.service.model.ScaleMode;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScalePanel
extends JPanel {
    private static final long serialVersionUID = 4512086651023889194L;
    private static final int SECTION_TITLE_LABEL_FONT_STYLE = 0;
    private static final float SECTION_TITLE_LABEL_FONT_SIZE = 14.0f;
    private static final Color SECTION_TITLE_LABEL_COLOUR = Color.decode("#484852");
    private static final Dimension VERTICAL_RIGID_AREA_SPACING = new Dimension(0, 4);
    private transient JComboBox scalingComboBox;
    private ScaleMode[] modes;
    private String[] scalings;

    public ScalePanel() {
        this.initScalingComboBox();
        this.initView();
    }

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.scalingComboBox.setEnabled(enabled);
    }

    public final void addActionListener(ActionListener al) {
        this.scalingComboBox.addActionListener(al);
    }

    private void initView() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0), false);
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.print.scaling"));
        titleLabel.setForeground(SECTION_TITLE_LABEL_COLOUR);
        titleLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        titlePanel.add(titleLabel);
        this.add(titlePanel);
        this.add(Box.createRigidArea(VERTICAL_RIGID_AREA_SPACING));
        this.add(this.scalingComboBox);
    }

    private void initScalingComboBox() {
        this.scalings = new String[]{PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.noscaling"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.topage"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.halfpage"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.onebytwo"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.twobyone"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.twobytwo"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.threebythree"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.fourbyfour"), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.scaling.fivebyfive")};
        this.modes = new ScaleMode[]{new ScaleMode(ScaleMode.ScaleType.NO_SCALING), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 1, 1), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_HALF), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 1, 2), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 2, 1), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 2, 2), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 3, 3), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 4, 4), new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 5, 5)};
        this.scalingComboBox = new JComboBox<String>(this.scalings);
        this.scalingComboBox.setOpaque(false);
        this.scalingComboBox.setUI(CoreUIFactory.getComboBoxUI());
        this.scalingComboBox.setSelectedIndex(0);
    }

    public final ScaleMode getScaleMode() {
        int selected = this.scalingComboBox.getSelectedIndex();
        if (selected > -1) {
            return this.modes[selected];
        }
        return new ScaleMode(ScaleMode.ScaleType.SCALE_TO_PAGES, 1, 1);
    }

    public final void setSelectedScale(ScaleMode scaleMode) {
        for (int i = 0; i < this.modes.length; ++i) {
            ScaleMode scale = this.modes[i];
            if (scaleMode.getScaleType() != scale.getScaleType() || scaleMode.getRows() != scale.getRows() || scaleMode.getColumns() != scale.getColumns()) continue;
            this.scalingComboBox.setSelectedIndex(i);
        }
    }
}

