/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.osgi;

import com.buzanonline.chaos.action.AbstractAction;
import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceNotAvailableException;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public abstract class AbstractEditorAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(AbstractEditorAction.class);
    private final BundleContext context;
    private final EditorManager editorManager;
    private final String actionId;

    public AbstractEditorAction(BundleContext contextIn, String actionIdIn) {
        this.context = contextIn;
        this.actionId = actionIdIn;
        this.changeState(false);
        OSGiService editorManagerService = new OSGiService(this.context, EditorManager.class);
        this.editorManager = (EditorManager)editorManagerService.get();
        editorManagerService.close();
        this.editorManager.addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent editor) {
                if (editor == null) {
                    AbstractEditorAction.this.changeState(false);
                } else {
                    AbstractEditorAction.this.changeState(true);
                }
            }
        });
    }

    public final EditorManager getEditorManager() {
        return this.editorManager;
    }

    public final IEditorComponent getCurrentEditor() {
        try {
            return this.editorManager.getCurrentEditorComponent();
        }
        catch (IllegalStateException ex) {
            LOGGER.error((Object)"no current editor, action should never be invoked", (Throwable)ex);
            return null;
        }
    }

    public final String getId() {
        return this.actionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forwardAction(String actionIdToRun, Object[] params) {
        OSGiService actionManagerService = new OSGiService(this.context, ActionManager.class);
        if (actionManagerService != null) {
            try {
                ActionManager manager = (ActionManager)actionManagerService.get();
                manager.runAction(actionIdToRun, params);
            }
            catch (ServiceNotAvailableException ex) {
                LOGGER.error((Object)("tried to run action " + actionIdToRun + " but action manager was unavailable"));
            }
            finally {
                actionManagerService.close();
            }
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }

    public final BundleContext getBundleContext() {
        return this.context;
    }
}

