/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.ServiceNotAvailableException;
import com.thinkbuzan.gaia.printing.service.ProjectManagementPrintableFactory;
import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import com.thinkbuzan.gaia.printing.ui.licensing.BundleLicenser;
import com.thinkbuzan.gaia.printing.ui.osgi.PrintAction;
import com.thinkbuzan.gaia.printing.ui.osgi.QuickPrintAction;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    protected static final String BASE_NAME_OF_MESSAGES_FILE = "/i18nproperties/PrintingUIMessages";
    private static OSGiService<ProjectManagementPrintableFactory> PM_SERVICE = null;

    public static ProjectManagementPrintableFactory getProjectManagmentPrintableFactory() {
        if (PM_SERVICE == null) {
            return null;
        }
        try {
            return (ProjectManagementPrintableFactory)PM_SERVICE.get();
        }
        catch (ServiceNotAvailableException ex) {
            return null;
        }
    }

    public final void start(BundleContext context) {
        OSGiService licenseService = new OSGiService(context, PluginLicenseService.class);
        BundleLicenser.initLicenser((PluginLicenseService)licenseService.get());
        licenseService.close();
        ITextBundle bundle = new ITextBundle(){

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return Activator.BASE_NAME_OF_MESSAGES_FILE;
            }
        };
        OSGiService service = new OSGiService(context, I18n.class);
        I18n i18n = (I18n)service.get();
        i18n.register(bundle);
        PrintingUII18N.setI18n(i18n);
        OSGiService actionManager = new OSGiService(context, ActionManager.class);
        ((ActionManager)actionManager.get()).addAction((IAction)new PrintAction(context));
        ((ActionManager)actionManager.get()).addAction((IAction)new QuickPrintAction(context));
        actionManager.close();
        PM_SERVICE = new OSGiService(context, ProjectManagementPrintableFactory.class);
    }

    public final void stop(BundleContext context) {
    }
}

