/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.osgi;

import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.printing.service.MindMapPrintable;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.ui.MindMapPrintDialog;
import com.thinkbuzan.gaia.printing.ui.osgi.AbstractEditorAction;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.Frame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.osgi.framework.BundleContext;

public class PrintAction
extends AbstractEditorAction {
    private final transient BundleContext context;
    private transient PrintingService printingService;
    private transient Map<UUID, Map<String, MindMapPrintable>> graphPrintables = new HashMap<UUID, Map<String, MindMapPrintable>>();

    public PrintAction(BundleContext contextIn) {
        super(contextIn, "com.thinkbuzan.gaia.actions.PrintAction");
        this.context = contextIn;
    }

    public final void runAction(Object ... parameters) {
        Object[] keys;
        List components = this.getEditorManager().getAllEditorComponents();
        for (Object key : keys = this.graphPrintables.keySet().toArray()) {
            boolean found = false;
            for (IEditorComponent comp : components) {
                if (!key.equals(comp.getId())) continue;
                found = true;
            }
            if (found) continue;
            this.graphPrintables.remove(key);
        }
        IEditorComponent editor = this.getCurrentEditor();
        if (editor != null) {
            MindMapPrintable graphPrintable;
            Map<String, MindMapPrintable> viewMap;
            if (this.graphPrintables.containsKey(editor.getId())) {
                viewMap = this.graphPrintables.get(editor.getId());
                if (viewMap.containsKey(editor.getView().getId())) {
                    graphPrintable = viewMap.get(editor.getView().getId());
                } else {
                    graphPrintable = new MindMapPrintable(editor);
                    viewMap.put(editor.getView().getId(), graphPrintable);
                    this.graphPrintables.put(editor.getId(), viewMap);
                }
            } else {
                graphPrintable = new MindMapPrintable(editor);
                viewMap = new HashMap<String, MindMapPrintable>();
                viewMap.put(editor.getView().getId(), graphPrintable);
                this.graphPrintables.put(editor.getId(), viewMap);
            }
            Frame parent = MainFrameUtilities.getMainFrame();
            MindMapPrintDialog printDialog = new MindMapPrintDialog(this.getPrintingService(), graphPrintable, editor, parent);
            printDialog.pack();
            printDialog.setLocationRelativeTo(parent);
            printDialog.setVisible(true);
        }
    }

    private PrintingService getPrintingService() {
        if (this.printingService == null) {
            OSGiService printingServiceService = new OSGiService(this.context, PrintingService.class);
            this.printingService = (PrintingService)printingServiceService.get();
            printingServiceService.close();
        }
        return this.printingService;
    }
}

