/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.osgi;

import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.printing.service.MindMapPrintable;
import com.thinkbuzan.gaia.printing.service.PrintableObject;
import com.thinkbuzan.gaia.printing.service.PrintingService;
import com.thinkbuzan.gaia.printing.ui.osgi.AbstractEditorAction;
import java.awt.print.PrinterException;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;

public class QuickPrintAction
extends AbstractEditorAction {
    private final BundleContext context;
    private static final Logger LOG = Logger.getLogger(QuickPrintAction.class);

    public QuickPrintAction(BundleContext contextIn) {
        super(contextIn, "com.thinkbuzan.gaia.actions.QuickPrintAction");
        this.context = contextIn;
    }

    public final void runAction(Object ... parameters) {
        IEditorComponent editor = this.getCurrentEditor();
        if (editor != null) {
            MindMapPrintable graphPrintable = new MindMapPrintable(editor);
            try {
                this.getPrintingService().print((PrintableObject)graphPrintable, -1);
            }
            catch (PrinterException e) {
                LOG.fatal((Object)e);
                e.printStackTrace();
            }
        }
    }

    private PrintingService getPrintingService() {
        OSGiService printingServiceService = new OSGiService(this.context, PrintingService.class);
        PrintingService printingService = (PrintingService)printingServiceService.get();
        printingServiceService.close();
        return printingService;
    }
}

